/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.timegraph;

import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlTimeGraphEntryModel;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.XmlViewInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.timegraph.Messages;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.ui.views.timegraph.XmlPresentationProvider;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.XmlDataProviderManager;
import org.eclipse.tracecompass.tmf.core.model.filters.TimeQueryFilter;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.timegraph.ITimeGraphState;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphEntryModel;
import org.eclipse.tracecompass.tmf.core.model.tree.TmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.ui.views.TmfViewFactory;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.AbstractTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.views.timegraph.BaseDataProviderTimeGraphView;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphViewer;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NullTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

public class XmlTimeGraphView
extends BaseDataProviderTimeGraphView {
    public static final @NonNull String ID = "org.eclipse.linuxtools.tmf.analysis.xml.ui.views.timegraph";
    private static final String[] DEFAULT_COLUMN_NAMES = new String[]{Messages.XmlTimeGraphView_ColumnName, Messages.XmlTimeGraphView_ColumnId, Messages.XmlTimeGraphView_ColumnParentId};
    private static final String[] DEFAULT_FILTER_COLUMN_NAMES = new String[]{Messages.XmlTimeGraphView_ColumnName, Messages.XmlTimeGraphView_ColumnId};
    private static final int[] fWeight = new int[]{1, 2};
    private static final String EMPTY_STRING = "";
    private static final Comparator<XmlTimeGraphEntryModel> XML_ENTRY_COMPARATOR = Comparator.comparing(XmlTimeGraphEntryModel::getPath, Comparator.nullsFirst(Comparator.naturalOrder())).thenComparing(TmfTreeDataModel::getName).thenComparingLong(TimeGraphEntryModel::getStartTime);
    private static final Comparator<ITimeGraphEntry> ENTRY_COMPARATOR = Comparator.comparing(x -> (XmlTimeGraphEntryModel)((TimeGraphEntry)x).getModel(), XML_ENTRY_COMPARATOR);
    private final @NonNull XmlViewInfo fViewInfo = new XmlViewInfo("org.eclipse.linuxtools.tmf.analysis.xml.ui.views.timegraph");
    private final Map<String, Integer> fStringValueMap = new HashMap<String, Integer>();
    private XmlPresentationProvider fPresentationProvider;

    public XmlTimeGraphView() {
        super(ID, (TimeGraphPresentationProvider)new XmlPresentationProvider(ID), "org.eclipse.tracecompass.tmf.analysis.xml.core.module.XmlTimeGraphDataProvider");
        this.setWeight(fWeight);
        this.setTreeColumns(DEFAULT_COLUMN_NAMES);
        this.setTreeLabelProvider(new XmlTreeLabelProvider());
        this.setFilterColumns(DEFAULT_FILTER_COLUMN_NAMES);
        this.setFilterLabelProvider(new XmlTreeLabelProvider());
        this.setEntryComparator(ENTRY_COMPARATOR);
        this.addPartPropertyListener(event -> {
            Object newValue = event.getNewValue();
            if (event.getProperty().equals("xmlOutputData") && newValue instanceof String) {
                String data = (String)newValue;
                this.fViewInfo.setViewData(data);
                TimeGraphViewer timeGraphViewer = this.getTimeGraphViewer();
                timeGraphViewer.getTimeGraphControl().colorSettingsChanged(timeGraphViewer.getTimeGraphProvider().getStateTable());
                this.rebuild();
            }
        });
    }

    public void createPartControl(Composite parent) {
        String name = this.getViewSite().getSecondaryId();
        if (name != null) {
            name = TmfViewFactory.getBaseSecId((String)name);
        }
        if (name != null) {
            this.fViewInfo.setName(name);
        }
        this.fPresentationProvider = new XmlPresentationProvider(name);
        this.fPresentationProvider.addColorListener(stateItems -> super.getPresentationProvider().refresh());
        super.createPartControl(parent);
    }

    private void setViewTitle(String title) {
        Display.getDefault().asyncExec(() -> this.setPartName(title));
    }

    protected String getNextText() {
        return Messages.XmlTimeGraphView_NextText;
    }

    protected String getNextTooltip() {
        return Messages.XmlTimeGraphView_NextTooltip;
    }

    protected String getPrevText() {
        return Messages.XmlTimeGraphView_PreviousText;
    }

    protected String getPrevTooltip() {
        return Messages.XmlTimeGraphView_PreviousInterval;
    }

    protected XmlPresentationProvider getPresentationProvider() {
        return this.fPresentationProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    protected void buildEntryList(ITmfTrace trace, ITmfTrace parentTrace, IProgressMonitor monitor) {
        viewElement = this.fViewInfo.getViewElement("timeGraphView");
        if (viewElement == null) {
            return;
        }
        this.fStringValueMap.clear();
        pres = this.getPresentationProvider();
        if (pres instanceof XmlPresentationProvider) {
            pres.loadNewStates(viewElement);
            Display.getDefault().asyncExec((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$7(), ()V)((XmlTimeGraphView)this));
        }
        this.setViewTitle((title = this.fViewInfo.getViewTitle(viewElement)) != null ? title : Messages.XmlTimeGraphView_DefaultTitle);
        subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        complete = false;
        provider = XmlDataProviderManager.getInstance().getTimeGraphProvider(trace, viewElement);
        if (provider != null) ** GOTO lbl65
        return;
lbl-1000:
        // 1 sources

        {
            response = provider.fetchTree(new TimeQueryFilter(0L, 0x7FFFFFFFFFFFFFFFL, 2), (IProgressMonitor)subMonitor);
            if (response.getStatus() == ITmfResponse.Status.FAILED) {
                Activator.logError("XML Time Graph Data Provider failed: " + response.getStatusMessage());
                return;
            }
            if (response.getStatus() == ITmfResponse.Status.CANCELLED) {
                return;
            }
            complete = response.getStatus() == ITmfResponse.Status.COMPLETED;
            model = (List)response.getModel();
            if (model != null) {
                var12_12 = this.fEntries;
                synchronized (var12_12) {
                    for (XmlTimeGraphEntryModel entry : model) {
                        tgEntry = (TimeGraphEntry)this.fEntries.get((Object)provider, (Object)entry.getId());
                        if (tgEntry == null) {
                            if (entry.getParentId() == -1L) {
                                tgEntry = new BaseDataProviderTimeGraphView.TraceEntry((TimeGraphEntryModel)entry, trace, provider);
                                this.addToEntryList(parentTrace, Collections.singletonList(tgEntry));
                            } else {
                                tgEntry = new TimeGraphEntry((TimeGraphEntryModel)entry);
                            }
                            this.fEntries.put((Object)provider, (Object)entry.getId(), (Object)tgEntry);
                        } else {
                            tgEntry.updateModel((TimeGraphEntryModel)entry);
                        }
                        if (entry.getParentId() != -1L) continue;
                        this.setStartTime(Long.min(this.getStartTime(), entry.getStartTime()));
                        this.setEndTime(Long.max(this.getEndTime(), entry.getEndTime()));
                    }
                }
                for (TimeGraphEntry child : this.fEntries.row((Object)provider).values()) {
                    parent = (TimeGraphEntry)this.fEntries.get((Object)provider, (Object)child.getModel().getParentId());
                    if (parent == null) continue;
                    parent.addChild(child);
                }
                start = this.getStartTime();
                end = this.getEndTime();
                resolution = Long.max(1L, (end - start) / (long)this.getDisplayWidth());
                this.zoomEntries(this.fEntries.row((Object)provider).values(), start, end, resolution, (IProgressMonitor)subMonitor);
            }
            if (parentTrace.equals(this.getTrace())) {
                this.refresh();
            }
            subMonitor.worked(1);
            if (complete) continue;
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                Activator.logError("Failed to wait for data provider", e);
            }
lbl65:
            // 4 sources

            ** while (!complete && !subMonitor.isCanceled())
        }
lbl66:
        // 1 sources

    }

    protected TimeEvent createTimeEvent(TimeGraphEntry entry, ITimeGraphState state) {
        int status = state.getValue();
        String label = state.getLabel();
        if (status == Integer.MIN_VALUE) {
            if (label == null) {
                return new NullTimeEvent((ITimeGraphEntry)entry, state.getStartTime(), state.getDuration());
            }
            int value = this.getStringIndex(label);
            return new TimeEvent((ITimeGraphEntry)entry, state.getStartTime(), state.getDuration(), value, state.getActiveProperties());
        }
        XmlPresentationProvider pres = this.getPresentationProvider();
        if (label != null && !pres.hasIndex(status)) {
            status = this.getStringIndex(label);
        }
        return new TimeEvent((ITimeGraphEntry)entry, state.getStartTime(), state.getDuration(), status, state.getActiveProperties());
    }

    private int getStringIndex(String state) {
        return this.fStringValueMap.computeIfAbsent(state, s -> this.getPresentationProvider().addState((String)s));
    }

    protected @NonNull Iterable<ITmfTrace> getTracesToBuild(@Nullable ITmfTrace trace) {
        return Collections.singleton(trace);
    }

    private /* synthetic */ void lambda$7() {
        TimeGraphViewer timeGraphViewer = this.getTimeGraphViewer();
        if (timeGraphViewer.getTimeGraphControl().isDisposed()) {
            return;
        }
        timeGraphViewer.getTimeGraphControl().colorSettingsChanged(timeGraphViewer.getTimeGraphProvider().getStateTable());
    }

    private static class XmlTreeLabelProvider
    extends AbstractTimeGraphView.TreeLabelProvider {
        private XmlTreeLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof TimeGraphEntry) {
                TimeGraphEntry entry = (TimeGraphEntry)element;
                if (DEFAULT_COLUMN_NAMES[columnIndex].equals(Messages.XmlTimeGraphView_ColumnName)) {
                    return entry.getName();
                }
                ITimeGraphEntryModel model = entry.getModel();
                if (model instanceof XmlTimeGraphEntryModel) {
                    XmlTimeGraphEntryModel xmlModel = (XmlTimeGraphEntryModel)model;
                    if (DEFAULT_COLUMN_NAMES[columnIndex].equals(Messages.XmlTimeGraphView_ColumnId)) {
                        return xmlModel.getXmlId();
                    }
                    if (DEFAULT_COLUMN_NAMES[columnIndex].equals(Messages.XmlTimeGraphView_ColumnParentId)) {
                        return xmlModel.getXmlParentId();
                    }
                }
            }
            return XmlTimeGraphView.EMPTY_STRING;
        }
    }
}

