/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.profiling.ui.callgraph;

import com.google.common.collect.Iterables;
import java.util.Objects;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.tracecompass.analysis.profiling.core.callgraph.ICallGraphProvider;
import org.eclipse.tracecompass.analysis.profiling.core.callstack.CallStackAnalysis;
import org.eclipse.tracecompass.analysis.timing.core.segmentstore.ISegmentStoreProvider;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.table.AbstractSegmentStoreTableViewer;
import org.eclipse.tracecompass.internal.analysis.profiling.core.callgraph.CallGraphAnalysis;
import org.eclipse.tracecompass.internal.analysis.profiling.ui.callgraph.Messages;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class CallGraphTableViewer
extends AbstractSegmentStoreTableViewer {
    public CallGraphTableViewer(@NonNull TableViewer tableViewer) {
        super(tableViewer);
    }

    protected @Nullable ISegmentStoreProvider getSegmentStoreProvider(@NonNull ITmfTrace trace) {
        Iterable csModules = TmfTraceUtils.getAnalysisModulesOfClass((ITmfTrace)trace, CallStackAnalysis.class);
        @Nullable CallStackAnalysis csModule = (CallStackAnalysis)Iterables.getFirst((Iterable)csModules, null);
        if (csModule == null) {
            return null;
        }
        csModule.schedule();
        ICallGraphProvider cgModule = csModule.getCallGraph();
        if (!(cgModule instanceof CallGraphAnalysis)) {
            return null;
        }
        final CallGraphAnalysis module = (CallGraphAnalysis)cgModule;
        Job job = new Job(Messages.CallGraphAnalysis){

            protected IStatus run(IProgressMonitor monitor) {
                module.waitForCompletion(Objects.requireNonNull(monitor));
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        return csModule;
    }
}

