/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.model.plan;

import java.sql.ResultSet;
import java.sql.Timestamp;
import org.jkiss.dbeaver.ext.db2.model.plan.DB2PlanNode;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;

public class DB2PlanObject
extends DB2PlanNode {
    private String displayName;
    private String nodeName;
    private String objectSchema;
    private String objectName;
    private String objectType;
    private Timestamp createTime;
    private Timestamp statsTime;
    private Integer columnsCount;
    private Integer rowCount;
    private Integer width;
    private Long pages;
    private String distinct;
    private String tablespaceName;
    private Double overHead;
    private Double transferRate;
    private Integer prefetchSize;
    private Integer extentSize;
    private Double cluster;
    private Long nLeaf;
    private Integer nLevels;
    private Long fullKeyCard;
    private Long overFlow;
    private Long firstKeyCard;
    private Long first2KeyCard;
    private Long first3KeyCard;
    private Long first4KeyCard;
    private Long sequentialPages;
    private Integer density;
    private String statsSrc;
    private Double avgSequenceGap;
    private Double avgSequenceFetchGap;
    private Double avgSequencePages;
    private Double avgSequenceFetchPages;
    private Double avgRandomPages;
    private Double avgRandomFetchPages;
    private Long numRIDs;
    private Long numRIDsDeleted;
    private Long numEmptyLeafs;
    private Long activeBlocks;
    private Integer numDataParts;
    private String nullKeys;

    public DB2PlanObject(JDBCResultSet dbResult) {
        this.objectSchema = JDBCUtils.safeGetStringTrimmed((ResultSet)dbResult, (String)"OBJECT_SCHEMA");
        this.objectName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OBJECT_NAME");
        this.objectType = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"OBJECT_TYPE");
        this.createTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"CREATE_TIME");
        this.statsTime = JDBCUtils.safeGetTimestamp((ResultSet)dbResult, (String)"STATISTICS_TIME");
        this.columnsCount = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"COLUMN_COUNT");
        this.rowCount = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"ROW_COUNT");
        this.width = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"WIDTH");
        this.pages = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"PAGES");
        this.distinct = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"DISTINCT");
        this.tablespaceName = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"TABLESPACE_NAME");
        this.overHead = JDBCUtils.safeGetDouble((ResultSet)dbResult, (String)"OVERHEAD");
        this.transferRate = JDBCUtils.safeGetDouble((ResultSet)dbResult, (String)"TRANSFER_RATE");
        this.prefetchSize = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"PREFETCHSIZE");
        this.extentSize = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"EXTENTSIZE");
        this.cluster = JDBCUtils.safeGetDouble((ResultSet)dbResult, (String)"CLUSTER");
        this.nLeaf = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"NLEAF");
        this.nLevels = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"NLEVELS");
        this.fullKeyCard = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"FULLKEYCARD");
        this.overFlow = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"OVERFLOW");
        this.firstKeyCard = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"FIRSTKEYCARD");
        this.first2KeyCard = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"FIRST2KEYCARD");
        this.first3KeyCard = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"FIRST3KEYCARD");
        this.first4KeyCard = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"FIRST4KEYCARD");
        this.sequentialPages = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"SEQUENTIAL_PAGES");
        this.density = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"DENSITY");
        this.statsSrc = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"STATS_SRC");
        this.avgSequenceGap = JDBCUtils.safeGetDouble((ResultSet)dbResult, (String)"AVERAGE_SEQUENCE_GAP");
        this.avgSequenceFetchGap = JDBCUtils.safeGetDouble((ResultSet)dbResult, (String)"AVERAGE_SEQUENCE_FETCH_GAP");
        this.avgSequencePages = JDBCUtils.safeGetDouble((ResultSet)dbResult, (String)"AVERAGE_SEQUENCE_PAGES");
        this.avgSequenceFetchPages = JDBCUtils.safeGetDouble((ResultSet)dbResult, (String)"AVERAGE_SEQUENCE_FETCH_PAGES");
        this.avgRandomFetchPages = JDBCUtils.safeGetDouble((ResultSet)dbResult, (String)"AVERAGE_RANDOM_FETCH_PAGES");
        this.numRIDs = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"NUMRIDS");
        this.numRIDsDeleted = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"NUMRIDS_DELETED");
        this.numEmptyLeafs = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"NUM_EMPTY_LEAFS");
        this.activeBlocks = JDBCUtils.safeGetLong((ResultSet)dbResult, (String)"ACTIVE_BLOCKS");
        this.numDataParts = JDBCUtils.safeGetInteger((ResultSet)dbResult, (String)"NUM_DATA_PARTS");
        this.nullKeys = JDBCUtils.safeGetString((ResultSet)dbResult, (String)"NULLKEYS");
        this.nodeName = DB2PlanObject.buildName(this.objectSchema, this.objectName);
        this.displayName = String.valueOf(this.objectType) + ": " + this.nodeName;
    }

    DB2PlanObject(DB2PlanObject copy) {
        this.displayName = copy.getDisplayName();
        this.nodeName = copy.getNodeName();
        this.objectType = copy.getObjectType();
        this.createTime = copy.getCreateTime();
        this.statsTime = copy.getStatsTime();
        this.columnsCount = copy.getColumnsCount();
        this.rowCount = copy.getRowCount();
        this.width = copy.getWidth();
        this.pages = copy.getPages();
        this.distinct = copy.getDistinct();
        this.tablespaceName = copy.getDisplayName();
        this.overHead = copy.getOverHead();
        this.transferRate = copy.getTransferRate();
        this.prefetchSize = copy.getPrefetchSize();
        this.extentSize = copy.getExtentSize();
        this.cluster = copy.getCluster();
        this.nLeaf = copy.getnLeaf();
        this.nLevels = copy.getnLevels();
        this.fullKeyCard = copy.getFullKeyCard();
        this.overFlow = copy.getOverFlow();
        this.firstKeyCard = copy.getFirstKeyCard();
        this.first2KeyCard = copy.getFirst2KeyCard();
        this.first3KeyCard = copy.getFirst3KeyCard();
        this.first4KeyCard = copy.getFirst4KeyCard();
        this.sequentialPages = copy.getSequentialPages();
        this.density = copy.getDensity();
        this.statsSrc = copy.getStatsSrc();
        this.avgSequenceGap = copy.getAvgSequenceGap();
        this.avgSequenceFetchGap = copy.getAvgSequenceFetchGap();
        this.avgSequencePages = copy.getAvgSequencePages();
        this.avgSequenceFetchPages = copy.getAvgSequenceFetchPages();
        this.avgRandomPages = copy.getAvgRandomPages();
        this.avgRandomFetchPages = copy.getAvgRandomFetchPages();
        this.numRIDs = copy.getNumRIDs();
        this.numRIDsDeleted = copy.getNumRIDsDeleted();
        this.numEmptyLeafs = copy.getNumEmptyLeafs();
        this.activeBlocks = copy.getActiveBlocks();
        this.numDataParts = copy.getNumDataParts();
        this.nullKeys = copy.getNullKeys();
    }

    public String toString() {
        return this.displayName;
    }

    @Override
    public String getNodeName() {
        return this.nodeName;
    }

    public static String buildName(String objectSchema, String objectName) {
        return String.valueOf(objectSchema) + "." + objectName;
    }

    @Property(editable=false, viewable=true, order=1)
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    @Property(editable=false, viewable=true, order=2, category="Performance", format="###,###,###,##0.000")
    public Double getEstimatedCardinality() {
        return (double)this.rowCount;
    }

    @Property(editable=false, viewable=false, order=3)
    public String getObjectType() {
        return this.objectType;
    }

    @Property(editable=false, viewable=false, category="Performance")
    public Integer getRowCount() {
        return this.rowCount;
    }

    @Property(editable=false, viewable=false, category="Date & Time")
    public Timestamp getCreateTime() {
        return this.createTime;
    }

    @Property(editable=false, viewable=false, category="Statistics")
    public Timestamp getStatsTime() {
        return this.statsTime;
    }

    @Property(editable=false, viewable=false)
    public Integer getColumnsCount() {
        return this.columnsCount;
    }

    @Property(editable=false, viewable=false)
    public Integer getWidth() {
        return this.width;
    }

    @Property(editable=false, viewable=false)
    public String getDistinct() {
        return this.distinct;
    }

    @Property(editable=false, viewable=false)
    public String getTablespaceName() {
        return this.tablespaceName;
    }

    @Property(editable=false, viewable=false)
    public Integer getPrefetchSize() {
        return this.prefetchSize;
    }

    @Property(editable=false, viewable=false)
    public Integer getExtentSize() {
        return this.extentSize;
    }

    @Property(editable=false, viewable=false, category="Statistics")
    public Long getPages() {
        return this.pages;
    }

    @Property(editable=false, viewable=false, category="Statistics")
    public Double getOverHead() {
        return this.overHead;
    }

    @Property(editable=false, viewable=false, category="Statistics")
    public Double getTransferRate() {
        return this.transferRate;
    }

    @Property(editable=false, viewable=false, category="Statistics")
    public Double getCluster() {
        return this.cluster;
    }

    @Property(editable=false, viewable=false, category="Statistics")
    public Long getnLeaf() {
        return this.nLeaf;
    }

    @Property(editable=false, viewable=false, category="Statistics")
    public Integer getnLevels() {
        return this.nLevels;
    }

    @Property(editable=false, viewable=false, category="Statistics")
    public Long getOverFlow() {
        return this.overFlow;
    }

    @Property(editable=false, viewable=false, category="Statistics")
    public Long getFullKeyCard() {
        return this.fullKeyCard;
    }

    @Property(editable=false, viewable=false, category="Statistics")
    public Long getFirstKeyCard() {
        return this.firstKeyCard;
    }

    @Property(editable=false, viewable=false, category="Statistics")
    public Long getFirst2KeyCard() {
        return this.first2KeyCard;
    }

    @Property(editable=false, viewable=false, category="Statistics")
    public Long getFirst3KeyCard() {
        return this.first3KeyCard;
    }

    @Property(editable=false, viewable=false, category="Statistics")
    public Long getFirst4KeyCard() {
        return this.first4KeyCard;
    }

    @Property(editable=false, viewable=false, category="Statistics")
    public Long getSequentialPages() {
        return this.sequentialPages;
    }

    @Property(editable=false, viewable=false, category="Statistics")
    public Integer getDensity() {
        return this.density;
    }

    @Property(editable=false, viewable=false, category="Statistics")
    public String getStatsSrc() {
        return this.statsSrc;
    }

    @Property(editable=false, viewable=false)
    public Double getAvgSequenceGap() {
        return this.avgSequenceGap;
    }

    @Property(editable=false, viewable=false)
    public Double getAvgSequenceFetchGap() {
        return this.avgSequenceFetchGap;
    }

    @Property(editable=false, viewable=false)
    public Double getAvgSequencePages() {
        return this.avgSequencePages;
    }

    @Property(editable=false, viewable=false)
    public Double getAvgSequenceFetchPages() {
        return this.avgSequenceFetchPages;
    }

    @Property(editable=false, viewable=false)
    public Double getAvgRandomPages() {
        return this.avgRandomPages;
    }

    @Property(editable=false, viewable=false)
    public Double getAvgRandomFetchPages() {
        return this.avgRandomFetchPages;
    }

    @Property(editable=false, viewable=false)
    public Long getNumRIDs() {
        return this.numRIDs;
    }

    @Property(editable=false, viewable=false)
    public Long getNumRIDsDeleted() {
        return this.numRIDsDeleted;
    }

    @Property(editable=false, viewable=false)
    public Long getNumEmptyLeafs() {
        return this.numEmptyLeafs;
    }

    @Property(editable=false, viewable=false)
    public Long getActiveBlocks() {
        return this.activeBlocks;
    }

    @Property(editable=false, viewable=false)
    public Integer getNumDataParts() {
        return this.numDataParts;
    }

    @Property(editable=false, viewable=false)
    public String getNullKeys() {
        return this.nullKeys;
    }
}

