/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.firebird.model.plan;

import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.firebird.FireBirdUtils;
import org.jkiss.dbeaver.ext.firebird.model.FireBirdDataSource;
import org.jkiss.dbeaver.ext.firebird.model.plan.FireBirdPlanBuilder;
import org.jkiss.dbeaver.ext.firebird.model.plan.FireBirdPlanNode;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.plan.DBCPlan;
import org.jkiss.dbeaver.model.exec.plan.DBCPlanNode;

public class FireBirdPlanAnalyser
implements DBCPlan {
    private FireBirdDataSource dataSource;
    private JDBCSession session;
    private String query;
    private List<FireBirdPlanNode> rootNodes;

    public FireBirdPlanAnalyser(FireBirdDataSource dataSource, JDBCSession session, String query) {
        this.dataSource = dataSource;
        this.session = session;
        this.query = query;
    }

    public void explain() throws DBException {
        try (JDBCPreparedStatement dbStat = this.session.prepareStatement(this.getQueryString());){
            String plan = FireBirdUtils.getPlan(dbStat);
            FireBirdPlanBuilder builder = new FireBirdPlanBuilder(plan);
            this.rootNodes = builder.Build(this.session);
        }
        catch (SQLException e) {
            throw new DBCException(e, (DBPDataSource)this.session.getDataSource());
        }
    }

    public String getQueryString() {
        return this.query;
    }

    public String getPlanQueryString() throws DBException {
        return null;
    }

    public Collection<? extends DBCPlanNode> getPlanNodes() {
        return this.rootNodes;
    }
}

