/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.navigator.meta;

import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPTermProvider;
import org.jkiss.dbeaver.model.impl.AbstractDescriptor;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeFolder;
import org.jkiss.dbeaver.model.navigator.meta.DBXTreeNode;
import org.jkiss.utils.CommonUtils;

public class DBXTreeItem
extends DBXTreeNode {
    private String label;
    private String itemLabel;
    private String path;
    private String propertyName;
    private boolean optional;

    public DBXTreeItem(AbstractDescriptor source, DBXTreeNode parent, String id, String label, String itemLabel, String path, String propertyName, boolean optional, boolean navigable, boolean inline, boolean virtual, boolean standalone, String visibleIf, String recursiveLink) {
        super(source, parent, id, navigable, inline, virtual, standalone, visibleIf, recursiveLink);
        this.label = label;
        this.itemLabel = itemLabel == null ? label : itemLabel;
        this.path = path;
        this.propertyName = propertyName;
        this.optional = optional;
    }

    public DBXTreeItem(AbstractDescriptor source, DBXTreeNode parent, DBXTreeItem item) {
        super(source, parent, item);
        this.label = item.label;
        this.itemLabel = item.itemLabel;
        this.path = item.path;
        this.propertyName = item.propertyName;
        this.optional = item.optional;
    }

    public String getPath() {
        return this.path;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public String getChildrenType(DBPDataSource dataSource) {
        String term = this.getNodeTerm(dataSource, this.label, true);
        if (term != null) {
            return term;
        }
        return this.label;
    }

    @Override
    public String toString() {
        return "Item " + this.label;
    }

    @Override
    public String getNodeType(DBPDataSource dataSource) {
        String term = this.getNodeTerm(dataSource, this.itemLabel, false);
        if (term != null) {
            return term;
        }
        return this.itemLabel;
    }

    private String getNodeTerm(DBPDataSource dataSource, String termId, boolean multiple) {
        String term;
        if (termId.startsWith("#") && dataSource instanceof DBPTermProvider && (term = ((DBPTermProvider)((Object)dataSource)).getObjectTypeTerm(this.getPath(), termId.substring(1), multiple)) != null) {
            return term;
        }
        return null;
    }

    public DBXTreeItem findChildItemByPath(String path) {
        for (DBXTreeNode node : this.getChildren()) {
            DBXTreeItem subItem = this.findChildItemByPath(node, path);
            if (subItem == null) continue;
            return subItem;
        }
        return null;
    }

    private DBXTreeItem findChildItemByPath(DBXTreeNode node, String path) {
        if (node instanceof DBXTreeItem && CommonUtils.equalObjects((Object)((DBXTreeItem)node).getPath(), (Object)path)) {
            return (DBXTreeItem)node;
        }
        if (node instanceof DBXTreeFolder) {
            for (DBXTreeNode subFolder : node.getChildren()) {
                DBXTreeItem subItem = this.findChildItemByPath(subFolder, path);
                if (subItem == null) continue;
                return subItem;
            }
        }
        return null;
    }
}

