/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.sql.edit.struct;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.edit.DBERegistry;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistActionComment;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTable;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLObjectEditor;
import org.jkiss.dbeaver.model.impl.sql.edit.SQLStructEditor;
import org.jkiss.dbeaver.model.impl.struct.AbstractTable;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDataSource;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableConstraint;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableForeignKey;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public abstract class SQLTableManager<OBJECT_TYPE extends JDBCTable, CONTAINER_TYPE extends DBSObjectContainer>
extends SQLStructEditor<OBJECT_TYPE, CONTAINER_TYPE> {
    private static final String BASE_TABLE_NAME = "NewTable";

    @Override
    public long getMakerOptions(DBPDataSource dataSource) {
        long options = 4L;
        if (dataSource instanceof SQLDataSource && ((SQLDataSource)dataSource).getSQLDialect().supportsTableDropCascade()) {
            options |= 8L;
        }
        return options;
    }

    @Override
    protected final void addObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLObjectEditor.ObjectCreateCommand objectChangeCommand, Map<String, Object> options) {
        throw new IllegalStateException("addObjectCreateActions should never be called in struct editor");
    }

    @Override
    protected void addStructObjectCreateActions(DBRProgressMonitor monitor, List<DBEPersistAction> actions, SQLStructEditor.StructCreateCommand command, Map<String, Object> options) throws DBException {
        JDBCTable table = (JDBCTable)command.getObject();
        SQLObjectEditor.NestedObjectCommand tableProps = command.getObjectCommands().get(table);
        if (tableProps == null) {
            log.warn("Object change command not found");
            return;
        }
        String tableName = CommonUtils.getOption(options, (String)"useFQN", (boolean)true) ? table.getFullyQualifiedName(DBPEvaluationContext.DDL) : DBUtils.getQuotedIdentifier(table);
        String slComment = SQLUtils.getDialectFromObject(table).getSingleLineComments()[0];
        String lineSeparator = GeneralUtils.getDefaultLineSeparator();
        StringBuilder createQuery = new StringBuilder(100);
        createQuery.append("CREATE ").append(this.getCreateTableType(table)).append(" ").append(tableName).append(" (").append(lineSeparator);
        boolean hasNestedDeclarations = false;
        Collection<SQLObjectEditor.NestedObjectCommand> orderedCommands = this.getNestedOrderedCommands(command);
        for (SQLObjectEditor.NestedObjectCommand nestedCommand : orderedCommands) {
            if (nestedCommand.getObject() == table || this.excludeFromDDL(nestedCommand, orderedCommands)) continue;
            String nestedDeclaration = nestedCommand.getNestedDeclaration(monitor, table, options);
            if (!CommonUtils.isEmpty((String)nestedDeclaration)) {
                if (hasNestedDeclarations) {
                    int lastLFPos = createQuery.lastIndexOf(lineSeparator);
                    int lastCommentPos = createQuery.lastIndexOf(slComment);
                    if (lastCommentPos != -1) {
                        while (lastCommentPos > 0 && Character.isWhitespace(createQuery.charAt(lastCommentPos - 1))) {
                            --lastCommentPos;
                        }
                    }
                    if (lastCommentPos < 0 || lastCommentPos < lastLFPos) {
                        createQuery.append(",");
                    } else {
                        createQuery.insert(lastCommentPos, ",");
                    }
                    createQuery.append(lineSeparator);
                }
                createQuery.append("\t").append(nestedDeclaration);
                hasNestedDeclarations = true;
                continue;
            }
            DBEPersistAction[] nestedActions = nestedCommand.getPersistActions(monitor, options);
            if (nestedActions == null) continue;
            Collections.addAll(actions, nestedActions);
        }
        createQuery.append(lineSeparator).append(")");
        this.appendTableModifiers(monitor, table, tableProps, createQuery, false);
        actions.add(0, new SQLDatabasePersistAction(ModelMessages.model_jdbc_create_new_table, createQuery.toString()));
    }

    protected String getCreateTableType(OBJECT_TYPE table) {
        return "TABLE";
    }

    protected boolean excludeFromDDL(SQLObjectEditor.NestedObjectCommand command, Collection<SQLObjectEditor.NestedObjectCommand> orderedCommands) {
        return false;
    }

    @Override
    protected void addObjectDeleteActions(List<DBEPersistAction> actions, SQLObjectEditor.ObjectDeleteCommand command, Map<String, Object> options) {
        JDBCTable object = (JDBCTable)command.getObject();
        actions.add(new SQLDatabasePersistAction(ModelMessages.model_jdbc_drop_table, "DROP " + (object.isView() ? "VIEW" : "TABLE") + " " + object.getFullyQualifiedName(DBPEvaluationContext.DDL) + (!object.isView() && CommonUtils.getOption(options, (String)"deleteCascade") ? " CASCADE" : "")));
    }

    protected void appendTableModifiers(DBRProgressMonitor monitor, OBJECT_TYPE table, SQLObjectEditor.NestedObjectCommand tableProps, StringBuilder ddl, boolean alter) {
    }

    protected void setTableName(DBRProgressMonitor monitor, CONTAINER_TYPE container, OBJECT_TYPE table) throws DBException {
        ((AbstractTable)table).setName(this.getNewChildName(monitor, container));
    }

    protected String getNewChildName(DBRProgressMonitor monitor, CONTAINER_TYPE container) throws DBException {
        return this.getNewChildName(monitor, container, BASE_TABLE_NAME);
    }

    protected String getNewChildName(DBRProgressMonitor monitor, CONTAINER_TYPE container, String baseName) throws DBException {
        int i = 0;
        String tableName;
        DBSObject child;
        while ((child = container.getChild(monitor, tableName = DBObjectNameCaseTransformer.transformName(container.getDataSource(), i == 0 ? baseName : String.valueOf(baseName) + "_" + i))) != null) {
            ++i;
        }
        return tableName;
    }

    public DBEPersistAction[] getTableDDL(DBRProgressMonitor monitor, OBJECT_TYPE table, Map<String, Object> options) throws DBException {
        ArrayList<SQLDatabasePersistActionComment> actions = new ArrayList<SQLDatabasePersistActionComment>();
        DBERegistry editorsRegistry = ((AbstractTable)table).getDataSource().getContainer().getPlatform().getEditorsRegistry();
        SQLObjectEditor<DBSEntityAttribute, DBSEntityAttribute> tcm = this.getObjectEditor(editorsRegistry, DBSEntityAttribute.class);
        SQLObjectEditor<DBSTableConstraint, DBSTableConstraint> pkm = this.getObjectEditor(editorsRegistry, DBSTableConstraint.class);
        SQLObjectEditor<DBSTableForeignKey, DBSTableForeignKey> fkm = this.getObjectEditor(editorsRegistry, DBSTableForeignKey.class);
        SQLObjectEditor<DBSTableIndex, DBSTableIndex> im = this.getObjectEditor(editorsRegistry, DBSTableIndex.class);
        if (this.isIncludeDropInDDL()) {
            actions.add(new SQLDatabasePersistActionComment((DBPDataSource)((AbstractTable)table).getDataSource(), "Drop table"));
            DBEPersistAction[] dBEPersistActionArray = new SQLObjectEditor.ObjectDeleteCommand((SQLObjectEditor)this, table, ModelMessages.model_jdbc_delete_object).getPersistActions(monitor, options);
            int n = dBEPersistActionArray.length;
            int n2 = 0;
            while (n2 < n) {
                DBEPersistAction delAction = dBEPersistActionArray[n2];
                actions.add(new SQLDatabasePersistActionComment((DBPDataSource)((AbstractTable)table).getDataSource(), delAction.getScript()));
                ++n2;
            }
        }
        SQLObjectEditor.ObjectCreateCommand command = this.makeCreateCommand((DBSObject)table);
        if (tcm != null) {
            for (DBSEntityAttribute column : CommonUtils.safeCollection(table.getAttributes(monitor))) {
                if (DBUtils.isHiddenObject(column) || DBUtils.isInheritedObject(column)) continue;
                ((SQLStructEditor.StructCreateCommand)command).aggregateCommand(tcm.makeCreateCommand(column));
            }
        }
        if (pkm != null) {
            try {
                for (DBSTableConstraint constraint : CommonUtils.safeCollection(table.getConstraints(monitor))) {
                    if (DBUtils.isHiddenObject(constraint) || DBUtils.isInheritedObject(constraint)) continue;
                    ((SQLStructEditor.StructCreateCommand)command).aggregateCommand(pkm.makeCreateCommand(constraint));
                }
            }
            catch (DBException e) {
                log.debug(e);
            }
        }
        if (fkm != null) {
            try {
                for (DBSEntityAssociation foreignKey : CommonUtils.safeCollection(table.getAssociations(monitor))) {
                    if (!(foreignKey instanceof DBSTableForeignKey) || DBUtils.isHiddenObject(foreignKey) || DBUtils.isInheritedObject(foreignKey)) continue;
                    ((SQLStructEditor.StructCreateCommand)command).aggregateCommand(fkm.makeCreateCommand((DBSTableForeignKey)foreignKey));
                }
            }
            catch (DBException e) {
                log.debug(e);
            }
        }
        if (im != null) {
            try {
                for (DBSTableIndex index : CommonUtils.safeCollection(table.getIndexes(monitor))) {
                    if (!this.isIncludeIndexInDDL(index)) continue;
                    ((SQLStructEditor.StructCreateCommand)command).aggregateCommand(im.makeCreateCommand(index));
                }
            }
            catch (DBException e) {
                log.debug(e);
            }
        }
        this.addExtraDDLCommands(monitor, table, options, (SQLStructEditor.StructCreateCommand)command);
        Collections.addAll(actions, ((SQLStructEditor.StructCreateCommand)command).getPersistActions(monitor, options));
        return actions.toArray(new DBEPersistAction[actions.size()]);
    }

    protected void addExtraDDLCommands(DBRProgressMonitor monitor, OBJECT_TYPE table, Map<String, Object> options, SQLStructEditor.StructCreateCommand createCommand) {
    }

    protected boolean isIncludeIndexInDDL(DBSTableIndex index) {
        return !DBUtils.isHiddenObject(index) && !DBUtils.isInheritedObject(index);
    }

    protected boolean isIncludeDropInDDL() {
        return true;
    }
}

