/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.jdbc.cache;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.AbstractObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public abstract class JDBCCompositeCache<OWNER extends DBSObject, PARENT extends DBSObject, OBJECT extends DBSObject, ROW_REF extends DBSObject>
extends AbstractObjectCache<OWNER, OBJECT> {
    protected static final Log log = Log.getLog(JDBCCompositeCache.class);
    public static final String DEFAULT_OBJECT_NAME = "#DBOBJ";
    private final JDBCStructCache<OWNER, ?, ?> parentCache;
    private final Class<PARENT> parentType;
    private final Object parentColumnName;
    private final Object objectColumnName;
    private final Map<PARENT, List<OBJECT>> objectCache = new IdentityHashMap<PARENT, List<OBJECT>>();

    protected JDBCCompositeCache(JDBCStructCache<OWNER, ?, ?> parentCache, Class<PARENT> parentType, Object parentColumnName, Object objectColumnName) {
        this.parentCache = parentCache;
        this.parentType = parentType;
        this.parentColumnName = parentColumnName;
        this.objectColumnName = objectColumnName;
    }

    @NotNull
    protected abstract JDBCStatement prepareObjectsStatement(JDBCSession var1, OWNER var2, PARENT var3) throws SQLException;

    @Nullable
    protected abstract OBJECT fetchObject(JDBCSession var1, OWNER var2, PARENT var3, String var4, JDBCResultSet var5) throws SQLException, DBException;

    @Nullable
    protected abstract ROW_REF[] fetchObjectRow(JDBCSession var1, PARENT var2, OBJECT var3, JDBCResultSet var4) throws SQLException, DBException;

    protected PARENT getParent(OBJECT object) {
        return (PARENT)object.getParentObject();
    }

    protected abstract void cacheChildren(DBRProgressMonitor var1, OBJECT var2, List<ROW_REF> var3);

    protected void cacheChildren2(DBRProgressMonitor monitor, OBJECT object, List<ROW_REF> children) {
    }

    @Override
    @NotNull
    public List<OBJECT> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable OWNER owner) throws DBException {
        return this.getObjects(monitor, owner, null);
    }

    public List<OBJECT> getObjects(DBRProgressMonitor monitor, OWNER owner, PARENT forParent) throws DBException {
        this.loadObjects(monitor, owner, forParent);
        return this.getCachedObjects(forParent);
    }

    public <TYPE extends OBJECT> List<TYPE> getTypedObjects(DBRProgressMonitor monitor, OWNER owner, PARENT forParent, Class<TYPE> type) throws DBException {
        ArrayList<DBSObject> result = new ArrayList<DBSObject>();
        List<OBJECT> objects = this.getObjects(monitor, owner, forParent);
        if (objects != null) {
            for (DBSObject object : objects) {
                if (!type.isInstance(object)) continue;
                result.add((DBSObject)type.cast(object));
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OBJECT> getCachedObjects(PARENT forParent) {
        if (forParent == null) {
            return this.getCachedObjects();
        }
        Map<PARENT, List<OBJECT>> map = this.objectCache;
        synchronized (map) {
            return this.objectCache.get(forParent);
        }
    }

    @Override
    public OBJECT getObject(@NotNull DBRProgressMonitor monitor, @Nullable OWNER owner, @NotNull String objectName) throws DBException {
        this.loadObjects(monitor, owner, null);
        return this.getCachedObject(objectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OBJECT getObject(DBRProgressMonitor monitor, OWNER owner, PARENT forParent, String objectName) throws DBException {
        this.loadObjects(monitor, owner, forParent);
        if (forParent == null) {
            return this.getCachedObject(objectName);
        }
        Map<PARENT, List<OBJECT>> map = this.objectCache;
        synchronized (map) {
            return (OBJECT)((DBSObject)DBUtils.findObject(this.objectCache.get(forParent), objectName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheObject(@NotNull OBJECT object) {
        super.cacheObject(object);
        Map<PARENT, List<OBJECT>> map = this.objectCache;
        synchronized (map) {
            PARENT parent = this.getParent(object);
            List<OBJECT> objects = this.objectCache.get(parent);
            if (objects == null) {
                objects = new ArrayList<OBJECT>();
                this.objectCache.put(parent, objects);
            }
            objects.add(object);
        }
    }

    @Override
    public void removeObject(@NotNull OBJECT object, boolean resetFullCache) {
        super.removeObject(object, resetFullCache);
        this.objectCache.remove(this.getParent(object));
    }

    public void clearObjectCache(PARENT forParent) {
        if (forParent == null) {
            super.clearCache();
        } else {
            this.objectCache.remove(forParent);
        }
    }

    public void setObjectCache(PARENT forParent, List<OBJECT> objects) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearCache() {
        Map<PARENT, List<OBJECT>> map = this.objectCache;
        synchronized (map) {
            this.objectCache.clear();
            super.clearCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCache(List<OBJECT> objects) {
        super.setCache(objects);
        Map<PARENT, List<OBJECT>> map = this.objectCache;
        synchronized (map) {
            this.objectCache.clear();
            for (DBSObject object : objects) {
                PARENT parent = this.getParent(object);
                List<OBJECT> parentObjects = this.objectCache.get(parent);
                if (parentObjects == null) {
                    parentObjects = new ArrayList<OBJECT>();
                    this.objectCache.put(parent, parentObjects);
                }
                parentObjects.add(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadObjects(DBRProgressMonitor monitor, OWNER owner, PARENT forParent) throws DBException {
        block54: {
            var4_4 = this.objectCache;
            synchronized (var4_4) {
                if (forParent == null) {
                    if (this.isFullyCached() != false) return;
                }
                if (forParent != null) {
                    if (forParent.isPersisted() == false) return;
                    if (this.objectCache.containsKey(forParent)) {
                        return;
                    }
                }
            }
            if (forParent == null) {
                this.parentCache.loadObjects(monitor, owner);
                this.parentCache.loadChildren(monitor, owner, null);
            }
            parentObjectMap = new LinkedHashMap<PARENT, TreeMap<K, V>>();
            dataSource = owner.getDataSource();
            if (!JDBCCompositeCache.$assertionsDisabled && dataSource == null) {
                throw new AssertionError();
            }
            try {
                var6_6 = null;
                var7_9 = null;
                try {
                    session = (JDBCSession)DBUtils.openMetaSession(monitor, owner, "Load composite objects");
                    try {
                        var9_12 = this.prepareObjectsStatement(session, owner, forParent);
                        var9_12.setFetchSize(1000);
                        try {
                            var9_12.executeStatement();
                            dbResult = var9_12.getResultSet();
                            if (dbResult == null) break block54;
                            try {
                                while (dbResult.next() && !monitor.isCanceled()) {
                                    parentName = forParent != null ? forParent.getName() : (this.parentColumnName instanceof Number != false ? JDBCUtils.safeGetString((ResultSet)dbResult, ((Number)this.parentColumnName).intValue()) : JDBCUtils.safeGetString((ResultSet)dbResult, this.parentColumnName.toString()));
                                    v1 = objectName = this.objectColumnName instanceof Number != false ? JDBCUtils.safeGetString((ResultSet)dbResult, ((Number)this.objectColumnName).intValue()) : JDBCUtils.safeGetString((ResultSet)dbResult, this.objectColumnName.toString());
                                    if (CommonUtils.isEmpty((String)objectName)) {
                                        objectName = this.getDefaultObjectName((JDBCResultSet)dbResult, parentName);
                                    }
                                    if (forParent == null && CommonUtils.isEmpty((String)parentName)) {
                                        JDBCCompositeCache.log.debug("Empty parent name in " + this);
                                        continue;
                                    }
                                    parent /* !! */  = forParent;
                                    if (parent /* !! */  == null && (parent /* !! */  = (DBSObject)this.parentCache.getObject(monitor, owner, parentName, this.parentType)) == null) {
                                        JDBCCompositeCache.log.debug("Object '" + (String)objectName + "' owner '" + parentName + "' not found");
                                        continue;
                                    }
                                    var14_28 = this.objectCache;
                                    synchronized (var14_28) {
                                        if (this.objectCache.containsKey(parent /* !! */ )) {
                                            continue;
                                        }
                                    }
                                    objectMap = (TreeMap<Object, ObjectInfo>)parentObjectMap.get(parent /* !! */ );
                                    if (objectMap == null) {
                                        objectMap = new TreeMap<Object, ObjectInfo>();
                                        parentObjectMap.put(parent /* !! */ , objectMap);
                                    }
                                    if ((objectInfo = (ObjectInfo)objectMap.get(objectName)) == null) {
                                        object = this.fetchObject(session, owner, parent /* !! */ , (String)objectName, (JDBCResultSet)dbResult);
                                        if (object == null) continue;
                                        objectName = object.getName();
                                        objectInfo = new ObjectInfo(this, object);
                                        objectMap.put(objectName, objectInfo);
                                    }
                                    if ((rowRef = this.fetchObjectRow(session, (DBSObject)parent /* !! */ , (DBSObject)objectInfo.object, (JDBCResultSet)dbResult)) == null || rowRef.length == 0) {
                                        objectInfo.broken = true;
                                        continue;
                                    }
                                    var20_34 = rowRef;
                                    var19_33 = rowRef.length;
                                    var18_32 = 0;
                                    while (var18_32 < var19_33) {
                                        row = var20_34[var18_32];
                                        if (row != null) {
                                            objectInfo.rows.add(row);
                                        }
                                        ++var18_32;
                                    }
                                }
                            }
                            finally {
                                dbResult.close();
                            }
                        }
                        finally {
                            var9_12.close();
                        }
                    }
                    finally {
                        if (session != null) {
                            session.close();
                        }
                    }
                }
                catch (Throwable var7_10) {
                    if (var6_6 == null) {
                        var6_6 = var7_10;
                        throw var6_6;
                    }
                    if (var6_6 == var7_10) throw var6_6;
                    var6_6.addSuppressed(var7_10);
                    throw var6_6;
                }
            }
            catch (SQLException ex) {
                throw new DBException(ex, dataSource);
            }
        }
        if (monitor.isCanceled()) {
            return;
        }
        var6_6 = this;
        synchronized (var6_6) {
            block58: {
                var7_9 = this.objectCache;
                synchronized (var7_9) {
                    if (forParent == null && parentObjectMap.isEmpty() || forParent != null) break block55;
                    globalCache = new ArrayList<OBJECT>();
                    dbResult = parentObjectMap.values().iterator();
                    block27: while (true) {
                        block56: {
                            if (dbResult.hasNext()) break block56;
                            dbResult = this.objectCache.values().iterator();
                            if (true) ** GOTO lbl136
                        }
                        var9_14 = (Map)dbResult.next();
                        if (var9_14 == null) continue;
                        objectName = var9_14.values().iterator();
                        while (true) {
                            if (objectName.hasNext()) ** break;
                            continue block27;
                            info = (ObjectInfo)objectName.next();
                            if (info.broken) continue;
                            globalCache.add(info.object);
                        }
                        break;
                    }
                }
                {
                    block57: {
                        block55: {
                            do {
                                var9_16 = dbResult.next();
                                globalCache.addAll(var9_16);
lbl136:
                                // 2 sources

                            } while (dbResult.hasNext());
                            super.setCache(globalCache);
                            this.invalidateObjects(monitor, owner, new AbstractObjectCache.CacheIterator(this));
                        }
                        for (Map.Entry<K, V> colEntry : parentObjectMap.entrySet()) {
                            if (colEntry.getValue() == null || this.objectCache.containsKey(colEntry.getKey())) continue;
                            objectInfos = ((Map)colEntry.getValue()).values();
                            objects = new ArrayList<OBJECT>(objectInfos.size());
                            for (ObjectInfo objectInfo : objectInfos) {
                                objectInfo.needsCaching = true;
                                objects.add(objectInfo.object);
                            }
                            this.objectCache.put((DBSObject)colEntry.getKey(), objects);
                        }
                        if (forParent != null) break block57;
                        var9_18 = this.parentCache.getTypedObjects(monitor, owner, this.parentType).iterator();
                        if (true) ** GOTO lbl164
                    }
                    if (!parentObjectMap.containsKey(forParent) && !this.objectCache.containsKey(forParent)) {
                        this.objectCache.put(forParent, new ArrayList<E>());
                    }
                    break block58;
                    do {
                        if (parentObjectMap.containsKey(tmpParent = (DBSObject)var9_18.next()) || this.objectCache.containsKey(tmpParent)) continue;
                        this.objectCache.put(tmpParent, new ArrayList<E>());
lbl164:
                        // 3 sources

                    } while (var9_18.hasNext());
                }
            }
            for (Map.Entry<K, V> colEntry : parentObjectMap.entrySet()) {
                for (ObjectInfo var9_21 : ((Map)colEntry.getValue()).values()) {
                    if (!var9_21.needsCaching) continue;
                    this.cacheChildren(monitor, var9_21.object, var9_21.rows);
                }
            }
            for (Map.Entry<K, V> colEntry : parentObjectMap.entrySet()) {
                for (ObjectInfo var9_23 : ((Map)colEntry.getValue()).values()) {
                    if (!var9_23.needsCaching) continue;
                    this.cacheChildren2(monitor, var9_23.object, var9_23.rows);
                }
            }
            return;
        }
    }

    protected String getDefaultObjectName(JDBCResultSet dbResult, String parentName) {
        return parentName == null ? DEFAULT_OBJECT_NAME : String.valueOf(parentName.toUpperCase()) + "_" + DEFAULT_OBJECT_NAME;
    }

    private static class ObjectInfo {
        final OBJECT object;
        final List<ROW_REF> rows = new ArrayList();
        public boolean broken;
        public boolean needsCaching;
        final /* synthetic */ JDBCCompositeCache this$0;

        public ObjectInfo(OBJECT object) {
            this.this$0 = var1_1;
            this.object = object;
        }
    }
}

