/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.data.formatters;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.Map;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.data.DBDDataFormatter;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.utils.CommonUtils;

public class NumberDataFormatter
implements DBDDataFormatter {
    public static final int MAX_DEFAULT_FRACTIONS_DIGITS = 4;
    private DecimalFormat numberFormat;
    private StringBuffer buffer;
    private FieldPosition position;

    @Override
    public void init(DBSTypedObject type, Locale locale, Map<Object, Object> properties) {
        String roundingMode;
        Object minFractDigits;
        Object maxFractDigits;
        Object minIntDigits;
        Object maxIntDigits;
        this.numberFormat = (DecimalFormat)NumberFormat.getNumberInstance(locale);
        Object useGrouping = properties.get("useGrouping");
        if (useGrouping != null) {
            this.numberFormat.setGroupingUsed(CommonUtils.toBoolean((Object)useGrouping));
        }
        if ((maxIntDigits = properties.get("maxIntegerDigits")) != null) {
            this.numberFormat.setMaximumIntegerDigits(CommonUtils.toInt((Object)maxIntDigits));
        }
        if ((minIntDigits = properties.get("minIntegerDigits")) != null) {
            this.numberFormat.setMinimumIntegerDigits(CommonUtils.toInt((Object)minIntDigits));
        }
        if ((maxFractDigits = properties.get("maxFractionDigits")) != null) {
            this.numberFormat.setMaximumFractionDigits(CommonUtils.toInt((Object)maxFractDigits));
        }
        if ((minFractDigits = properties.get("minFractionDigits")) != null) {
            this.numberFormat.setMinimumFractionDigits(CommonUtils.toInt((Object)minFractDigits));
        }
        if (!CommonUtils.isEmpty((String)(roundingMode = CommonUtils.toString((Object)properties.get("roundingMode"))))) {
            try {
                this.numberFormat.setRoundingMode(RoundingMode.valueOf(roundingMode));
            }
            catch (Exception exception) {}
        }
        String useTypeScale = CommonUtils.toString((Object)properties.get("useTypeScale"));
        if (type != null && CommonUtils.toBoolean((Object)useTypeScale) && type.getScale() != null && type.getScale() > 0) {
            int fractionDigits = type.getScale();
            if (fractionDigits > 4) {
                fractionDigits = 4;
            }
            this.numberFormat.setMinimumFractionDigits(fractionDigits);
        }
        this.buffer = new StringBuffer();
        this.position = new FieldPosition(0);
    }

    @Override
    @Nullable
    public String getPattern() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public String formatValue(Object value) {
        if (value == null) {
            return null;
        }
        try {
            NumberDataFormatter numberDataFormatter = this;
            synchronized (numberDataFormatter) {
                this.buffer.setLength(0);
                return this.numberFormat.format(value, this.buffer, this.position).toString();
            }
        }
        catch (Exception exception) {
            return value.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object parseValue(String value, @Nullable Class<?> typeHint) throws ParseException {
        NumberDataFormatter numberDataFormatter = this;
        synchronized (numberDataFormatter) {
            this.numberFormat.setParseBigDecimal(typeHint == BigDecimal.class || typeHint == BigInteger.class);
            Number number = this.numberFormat.parse(value);
            if (number != null && typeHint != null) {
                if (typeHint == Byte.class) {
                    return number.byteValue();
                }
                if (typeHint == Short.class) {
                    return number.shortValue();
                }
                if (typeHint == Integer.class) {
                    return number.intValue();
                }
                if (typeHint == Long.class) {
                    return number.longValue();
                }
                if (typeHint == Float.class) {
                    return Float.valueOf(number.floatValue());
                }
                if (typeHint == Double.class) {
                    return number.doubleValue();
                }
            }
            return number;
        }
    }
}

