/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset.panel.grouping;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetContainer;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetDecorator;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetPresentation;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.panel.grouping.GroupingDataContainer;
import org.jkiss.dbeaver.ui.controls.resultset.panel.grouping.GroupingResultsDecorator;
import org.jkiss.dbeaver.ui.controls.resultset.view.EmptyPresentation;
import org.jkiss.utils.CommonUtils;

public class GroupingResultsContainer
implements IResultSetContainer {
    public static final String FUNCTION_COUNT = "COUNT";
    public static final String DEFAULT_FUNCTION = "COUNT(*)";
    private final IResultSetPresentation presentation;
    private GroupingDataContainer dataContainer;
    private ResultSetViewer groupingViewer;
    private List<String> groupAttributes = new ArrayList<String>();
    private List<String> groupFunctions = new ArrayList<String>();

    public GroupingResultsContainer(Composite parent, IResultSetPresentation presentation) {
        this.presentation = presentation;
        this.dataContainer = new GroupingDataContainer(presentation.getController());
        this.groupingViewer = new ResultSetViewer(parent, presentation.getController().getSite(), this);
        this.initDefaultSettings();
    }

    private void initDefaultSettings() {
        this.groupAttributes.clear();
        this.groupFunctions.clear();
        this.addGroupingFunctions(Collections.singletonList(DEFAULT_FUNCTION));
    }

    public IResultSetPresentation getOwnerPresentation() {
        return this.presentation;
    }

    public List<String> getGroupAttributes() {
        return this.groupAttributes;
    }

    public List<String> getGroupFunctions() {
        return this.groupFunctions;
    }

    @Override
    public DBCExecutionContext getExecutionContext() {
        return this.presentation.getController().getExecutionContext();
    }

    @Override
    public IResultSetController getResultSetController() {
        return this.groupingViewer;
    }

    @Override
    public DBSDataContainer getDataContainer() {
        return this.dataContainer;
    }

    @Override
    public boolean isReadyToRun() {
        return true;
    }

    @Override
    public void openNewContainer(DBRProgressMonitor monitor, DBSDataContainer dataContainer, DBDDataFilter newFilter) {
    }

    @Override
    public IResultSetDecorator createResultSetDecorator() {
        return new GroupingResultsDecorator(this);
    }

    public void addGroupingAttributes(List<String> attributes) {
        for (String attrName : attributes) {
            if (this.groupAttributes.contains(attrName = this.cleanupObjectName(attrName))) continue;
            this.groupAttributes.add(attrName);
        }
    }

    public boolean removeGroupingAttribute(List<String> attributes) {
        boolean changed = false;
        for (String attrName : attributes) {
            if (!this.groupAttributes.contains(attrName = this.cleanupObjectName(attrName))) continue;
            this.groupAttributes.remove(attrName);
            changed = true;
        }
        if (changed) {
            this.resetDataFilters();
        }
        return changed;
    }

    private String cleanupObjectName(String attrName) {
        DBPDataSource dataSource = this.getDataContainer().getDataSource();
        attrName = DBUtils.isQuotedIdentifier((DBPDataSource)dataSource, (String)attrName) ? DBUtils.getUnQuotedIdentifier((DBPDataSource)dataSource, (String)attrName) : DBObjectNameCaseTransformer.transformName((DBPDataSource)dataSource, (String)attrName);
        return attrName;
    }

    public void addGroupingFunctions(List<String> functions) {
        for (String func : functions) {
            func = DBUtils.getUnQuotedIdentifier((DBPDataSource)this.getDataContainer().getDataSource(), (String)func);
            if (this.groupFunctions.contains(func)) continue;
            this.groupFunctions.add(func);
        }
    }

    public boolean removeGroupingFunction(List<String> attributes) {
        boolean changed = false;
        for (String func : attributes) {
            func = DBUtils.getUnQuotedIdentifier((DBPDataSource)this.getDataContainer().getDataSource(), (String)func);
            if (!this.groupFunctions.contains(func)) continue;
            this.groupFunctions.remove(func);
            changed = true;
        }
        return changed;
    }

    public void clearGrouping() {
        this.initDefaultSettings();
        this.groupingViewer.resetDataFilter(false);
        this.groupingViewer.resetHistory();
        this.dataContainer.setGroupingQuery(null);
        if (!(this.groupingViewer.getActivePresentation() instanceof EmptyPresentation)) {
            this.groupingViewer.setEmptyPresentation();
        }
    }

    public void rebuildGrouping() throws DBException {
        if (this.groupAttributes.isEmpty() || this.groupFunctions.isEmpty()) {
            this.getResultSetController().setEmptyPresentation();
            return;
        }
        DBCStatistics statistics = this.presentation.getController().getModel().getStatistics();
        if (statistics == null) {
            throw new DBException("No main query - can't perform grouping");
        }
        String queryText = statistics.getQueryText();
        if (queryText == null || queryText.isEmpty()) {
            DBSDataContainer dataContainer = this.presentation.getController().getDataContainer();
            if (dataContainer != null) {
                queryText = dataContainer.getName();
            } else {
                throw new DBException("Empty data container");
            }
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        int i = 0;
        while (i < this.groupAttributes.size()) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append(this.groupAttributes.get(i));
            ++i;
        }
        for (String func : this.groupFunctions) {
            sql.append(", ").append(func);
        }
        sql.append(" FROM (\n");
        sql.append(queryText);
        sql.append(") src");
        sql.append("\nGROUP BY ");
        i = 0;
        while (i < this.groupAttributes.size()) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append(this.groupAttributes.get(i));
            ++i;
        }
        boolean isDefaultGrouping = this.groupFunctions.size() == 1 && this.groupFunctions.get(0).equals(DEFAULT_FUNCTION);
        DBPDataSource dataSource = this.dataContainer.getDataSource();
        boolean isShowDuplicatesOnly = dataSource.getContainer().getPreferenceStore().getBoolean("resultset.grouping.showDuplicatesOnly");
        if (isDefaultGrouping && isShowDuplicatesOnly) {
            sql.append("\nHAVING ").append(DEFAULT_FUNCTION).append(" > 1");
        }
        this.dataContainer.setGroupingQuery(sql.toString());
        DBDDataFilter dataFilter = new DBDDataFilter();
        String defaultSorting = dataSource.getContainer().getPreferenceStore().getString("resultset.grouping.defaultSorting");
        if (!CommonUtils.isEmpty((String)defaultSorting) && isDefaultGrouping) {
            SQLDialect dialecy = SQLUtils.getDialectFromDataSource((DBPDataSource)dataSource);
            if (dialecy.supportsOrderByIndex()) {
                int countPosition = this.groupAttributes.size() + 1;
                dataFilter.setOrder(String.valueOf(String.valueOf(countPosition)) + " " + defaultSorting);
            } else {
                dataFilter.setOrder(this.groupFunctions.get(this.groupFunctions.size() - 1));
            }
        }
        this.groupingViewer.setDataFilter(dataFilter, true);
    }

    public void setGrouping(List<String> attributes, List<String> functions) {
        this.groupAttributes.clear();
        this.addGroupingAttributes(attributes);
        this.groupFunctions.clear();
        this.addGroupingFunctions(functions);
        this.resetDataFilters();
    }

    private void resetDataFilters() {
        this.groupingViewer.getModel().createDataFilter();
    }
}

