/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.IDataSourceContainerProvider;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDRowIdentifier;
import org.jkiss.dbeaver.model.data.DBDValueHandler;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetContainer;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.data.IAttributeController;
import org.jkiss.dbeaver.ui.data.IRowController;
import org.jkiss.dbeaver.ui.data.IValueController;
import org.jkiss.dbeaver.ui.data.IValueManager;
import org.jkiss.dbeaver.ui.data.registry.ValueManagerRegistry;

public class ResultSetValueController
implements IAttributeController,
IRowController {
    protected final ResultSetViewer controller;
    protected final IValueController.EditType editType;
    protected final Composite inlinePlaceholder;
    protected ResultSetRow curRow;
    protected DBDAttributeBinding binding;

    public ResultSetValueController(@NotNull IResultSetController controller, @NotNull DBDAttributeBinding binding, @NotNull ResultSetRow row, @NotNull IValueController.EditType editType, @Nullable Composite inlinePlaceholder) {
        this.controller = (ResultSetViewer)controller;
        this.binding = binding;
        this.curRow = row;
        this.editType = editType;
        this.inlinePlaceholder = inlinePlaceholder;
    }

    public ResultSetRow getCurRow() {
        return this.curRow;
    }

    public void setCurRow(ResultSetRow curRow) {
        this.curRow = curRow;
    }

    @Override
    @Nullable
    public DBCExecutionContext getExecutionContext() {
        return this.controller.getExecutionContext();
    }

    @Override
    public String getValueName() {
        return this.binding.getName();
    }

    @Override
    public DBSTypedObject getValueType() {
        return this.binding.getAttribute();
    }

    @Override
    @NotNull
    public IRowController getRowController() {
        return this;
    }

    @Override
    @NotNull
    public DBDAttributeBinding getBinding() {
        return this.binding;
    }

    public void setBinding(DBDAttributeBinding binding) {
        this.binding = binding;
    }

    @Override
    @NotNull
    public String getColumnId() {
        DBCExecutionContext context = this.getExecutionContext();
        DBCAttributeMetaData metaAttribute = this.binding.getMetaAttribute();
        return DBUtils.getSimpleQualifiedName((Object[])new Object[]{context == null ? null : context.getDataSource().getContainer().getName(), metaAttribute.getEntityName(), metaAttribute.getName()});
    }

    @Override
    public Object getValue() {
        return this.controller.getModel().getCellValue(this.binding, this.curRow);
    }

    @Override
    public void updateValue(@Nullable Object value, boolean updatePresentation) {
        boolean updated = this.controller.getModel().updateCellValue(this.binding, this.curRow, value);
        if (updated && updatePresentation) {
            UIUtils.syncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    ResultSetValueController.this.controller.updatePanelsContent(false);
                }
            });
            this.controller.fireResultSetChange();
        }
    }

    @Override
    public void updateSelectionValue(Object value) {
        this.updateValue(value, true);
    }

    @Override
    @Nullable
    public DBDRowIdentifier getRowIdentifier() {
        return this.binding.getRowIdentifier();
    }

    @Override
    public DBDValueHandler getValueHandler() {
        return this.binding.getValueHandler();
    }

    private DBPDataSourceContainer getDataSourceContainer() {
        IResultSetContainer rsContainer = this.controller.getContainer();
        if (rsContainer instanceof IDataSourceContainerProvider) {
            return ((IDataSourceContainerProvider)rsContainer).getDataSourceContainer();
        }
        DBCExecutionContext executionContext = this.getExecutionContext();
        return executionContext == null ? null : executionContext.getDataSource().getContainer();
    }

    @Override
    public IValueManager getValueManager() {
        Object value;
        DBSAttributeBase valueType = this.binding.getPresentationAttribute();
        DBCExecutionContext executionContext = this.getExecutionContext();
        Class<?> valueObjectType = this.getValueHandler().getValueObjectType((DBSTypedObject)valueType);
        if (valueObjectType == Object.class && (value = this.getValue()) != null) {
            valueObjectType = value.getClass();
        }
        return ValueManagerRegistry.findValueManager(executionContext == null ? null : executionContext.getDataSource(), (DBSTypedObject)valueType, valueObjectType);
    }

    @Override
    public IValueController.EditType getEditType() {
        return this.editType;
    }

    @Override
    public boolean isReadOnly() {
        return this.controller.isAttributeReadOnly(this.binding);
    }

    @Override
    public IWorkbenchPartSite getValueSite() {
        return this.controller.getSite();
    }

    @Override
    @Nullable
    public Composite getEditPlaceholder() {
        return this.inlinePlaceholder;
    }

    @Override
    public void refreshEditor() {
        this.controller.updatePanelsContent(true);
    }

    @Override
    public void showMessage(String message, DBPMessageType messageType) {
        UIUtils.asyncExec(() -> this.controller.setStatus(message, messageType));
    }

    @Override
    @NotNull
    public List<DBDAttributeBinding> getRowAttributes() {
        return Arrays.asList(this.controller.getModel().getAttributes());
    }

    @Override
    @Nullable
    public Object getAttributeValue(DBDAttributeBinding attribute) {
        return this.controller.getModel().getCellValue(attribute, this.curRow);
    }
}

