/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.controls.resultset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.Color;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDAttributeConstraint;
import org.jkiss.dbeaver.model.data.DBDComposite;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDRowIdentifier;
import org.jkiss.dbeaver.model.data.DBDValue;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCLogicalOperator;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetTrace;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.exec.trace.DBCTrace;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.virtual.DBVColorOverride;
import org.jkiss.dbeaver.model.virtual.DBVEntity;
import org.jkiss.dbeaver.model.virtual.DBVUtils;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetRow;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetUtils;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class ResultSetModel {
    private static final Log log = Log.getLog(ResultSetModel.class);
    private DBDAttributeBinding[] attributes = new DBDAttributeBinding[0];
    private List<DBDAttributeBinding> visibleAttributes = new ArrayList<DBDAttributeBinding>();
    private DBDAttributeBinding documentAttribute = null;
    private DBDDataFilter dataFilter;
    private DBSEntity singleSourceEntity;
    private DBCExecutionSource executionSource;
    private List<ResultSetRow> curRows = new ArrayList<ResultSetRow>();
    private Long totalRowCount = null;
    private int changesCount = 0;
    private volatile boolean hasData = false;
    private volatile boolean updateInProgress = false;
    private Map<DBDAttributeBinding, List<AttributeColorSettings>> colorMapping = new HashMap<DBDAttributeBinding, List<AttributeColorSettings>>();
    private DBCStatistics statistics;
    private DBCTrace trace;
    private transient boolean metadataChanged;
    private transient boolean metadataDynamic;
    private final Comparator<DBDAttributeBinding> POSITION_SORTER = new Comparator<DBDAttributeBinding>(){

        @Override
        public int compare(DBDAttributeBinding o1, DBDAttributeBinding o2) {
            DBDAttributeConstraint c1 = ResultSetModel.this.dataFilter.getConstraint(o1);
            DBDAttributeConstraint c2 = ResultSetModel.this.dataFilter.getConstraint(o2);
            if (c1 == null) {
                log.debug((Object)("Missing constraint for " + o1));
                return -1;
            }
            if (c2 == null) {
                log.debug((Object)("Missing constraint for " + o2));
                return 1;
            }
            return c1.getVisualPosition() - c2.getVisualPosition();
        }
    };

    public ResultSetModel() {
        this.dataFilter = this.createDataFilter();
    }

    @NotNull
    public DBDDataFilter createDataFilter() {
        this.fillVisibleAttributes();
        ArrayList<DBDAttributeConstraint> constraints = new ArrayList<DBDAttributeConstraint>(this.attributes.length);
        DBDAttributeBinding[] dBDAttributeBindingArray = this.attributes;
        int n = this.attributes.length;
        int n2 = 0;
        while (n2 < n) {
            DBDAttributeBinding binding = dBDAttributeBindingArray[n2];
            this.addConstraints(constraints, binding);
            ++n2;
        }
        return new DBDDataFilter(constraints);
    }

    private void addConstraints(List<DBDAttributeConstraint> constraints, DBDAttributeBinding binding) {
        DBDAttributeConstraint constraint = new DBDAttributeConstraint(binding);
        constraint.setVisible(this.visibleAttributes.contains(binding) || binding.getParentObject() != null);
        constraints.add(constraint);
        List nestedBindings = binding.getNestedBindings();
        if (nestedBindings != null) {
            for (DBDAttributeBinding nested : nestedBindings) {
                this.addConstraints(constraints, nested);
            }
        }
    }

    public boolean isSingleSource() {
        return this.singleSourceEntity != null;
    }

    @Nullable
    public DBSEntity getSingleSource() {
        return this.singleSourceEntity;
    }

    public void resetCellValue(DBDAttributeBinding attr, ResultSetRow row) {
        if (row.getState() == 3) {
            row.setState((byte)1);
        } else if (row.changes != null && row.changes.containsKey(attr)) {
            DBUtils.resetValue((Object)this.getCellValue(attr, row));
            this.updateCellValue(attr, row, row.changes.get(attr), false);
            row.resetChange(attr);
            if (row.getState() == 1) {
                --this.changesCount;
            }
        }
    }

    public void refreshChangeCount() {
        this.changesCount = 0;
        for (ResultSetRow row : this.curRows) {
            if (row.getState() != 1) {
                ++this.changesCount;
                continue;
            }
            if (row.changes == null) continue;
            this.changesCount += row.changes.size();
        }
    }

    public DBDAttributeBinding getDocumentAttribute() {
        return this.documentAttribute;
    }

    @NotNull
    public DBDAttributeBinding[] getAttributes() {
        return this.attributes;
    }

    @NotNull
    public DBDAttributeBinding getAttribute(int index) {
        return this.attributes[index];
    }

    @NotNull
    public List<DBDAttributeBinding> getVisibleAttributes() {
        return this.visibleAttributes;
    }

    public int getVisibleAttributeCount() {
        return this.visibleAttributes.size();
    }

    @Nullable
    public List<DBDAttributeBinding> getVisibleAttributes(DBDAttributeBinding parent) {
        List nestedBindings = parent.getNestedBindings();
        if (nestedBindings == null || nestedBindings.isEmpty()) {
            return null;
        }
        ArrayList<DBDAttributeBinding> result = new ArrayList<DBDAttributeBinding>(nestedBindings);
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            DBDAttributeConstraint constraint = this.dataFilter.getConstraint((DBDAttributeBinding)iter.next());
            if (constraint == null || constraint.isVisible()) continue;
            iter.remove();
        }
        return result;
    }

    @NotNull
    public DBDAttributeBinding getVisibleAttribute(int index) {
        return this.visibleAttributes.get(index);
    }

    public void setAttributeVisibility(@NotNull DBDAttributeBinding attribute, boolean visible) {
        DBDAttributeConstraint constraint = this.dataFilter.getConstraint(attribute);
        if (constraint != null && constraint.isVisible() != visible) {
            constraint.setVisible(visible);
            if (attribute.getParentObject() == null) {
                if (visible) {
                    this.visibleAttributes.add(attribute);
                } else {
                    this.visibleAttributes.remove(attribute);
                }
            }
        }
    }

    @Nullable
    public DBDAttributeBinding getAttributeBinding(@Nullable DBSAttributeBase attribute) {
        return DBUtils.findBinding((DBDAttributeBinding[])this.attributes, (DBSAttributeBase)attribute);
    }

    @Nullable
    DBDAttributeBinding getAttributeBinding(@Nullable DBSEntity entity, @NotNull String attrName) {
        for (DBDAttributeBinding attribute : this.visibleAttributes) {
            DBDRowIdentifier rowIdentifier = attribute.getRowIdentifier();
            if (entity != null && (rowIdentifier == null || rowIdentifier.getEntity() != entity) || !attribute.getName().equals(attrName)) continue;
            return attribute;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.getRowCount() <= 0 || this.visibleAttributes.size() <= 0;
    }

    public int getRowCount() {
        return this.curRows.size();
    }

    @NotNull
    public List<ResultSetRow> getAllRows() {
        return this.curRows;
    }

    @NotNull
    public Object[] getRowData(int index) {
        return this.curRows.get((int)index).values;
    }

    @NotNull
    public ResultSetRow getRow(int index) {
        return this.curRows.get(index);
    }

    public Long getTotalRowCount() {
        return this.totalRowCount;
    }

    void setTotalRowCount(Long totalRowCount) {
        this.totalRowCount = totalRowCount;
    }

    @Nullable
    public Object getCellValue(@NotNull DBDAttributeBinding attribute, @NotNull ResultSetRow row) {
        int depth = attribute.getLevel();
        if (depth == 0) {
            int index = attribute.getOrdinalPosition();
            if (index >= row.values.length) {
                log.debug((Object)"Bad attribute - index out of row values' bounds");
                return null;
            }
            return row.values[index];
        }
        Object curValue = row.values[attribute.getTopParent().getOrdinalPosition()];
        int i = 0;
        while (i < depth) {
            if (curValue == null) break;
            DBDAttributeBinding attr = attribute.getParent(depth - i - 1);
            assert (attr != null);
            try {
                curValue = attr.extractNestedValue(curValue);
            }
            catch (DBCException e) {
                log.debug((Object)("Error reading nested value of [" + attr.getName() + "]"), (Throwable)e);
                curValue = null;
                break;
            }
            ++i;
        }
        return curValue;
    }

    public boolean updateCellValue(@NotNull DBDAttributeBinding attr, @NotNull ResultSetRow row, @Nullable Object value) {
        return this.updateCellValue(attr, row, value, true);
    }

    public boolean updateCellValue(@NotNull DBDAttributeBinding attr, @NotNull ResultSetRow row, @Nullable Object value, boolean updateChanges) {
        int depth = attr.getLevel();
        int rootIndex = depth == 0 ? attr.getOrdinalPosition() : attr.getTopParent().getOrdinalPosition();
        Object rootValue = row.values[rootIndex];
        Object ownerValue = depth > 0 ? rootValue : null;
        int i = 0;
        while (i < depth) {
            if (ownerValue == null) {
                log.warn((Object)"Null owner value");
                return false;
            }
            if (i == depth - 1) break;
            DBDAttributeBinding ownerAttr = attr.getParent(depth - i - 1);
            assert (ownerAttr != null);
            try {
                ownerValue = ownerAttr.extractNestedValue(ownerValue);
            }
            catch (DBCException e) {
                log.warn((Object)("Error getting field [" + ownerAttr.getName() + "] value"), (Throwable)e);
                return false;
            }
            ++i;
        }
        Object oldValue = rootValue;
        if (ownerValue != null) {
            try {
                oldValue = attr.extractNestedValue(ownerValue);
            }
            catch (DBCException e) {
                log.error((Object)("Error getting [" + attr.getName() + "] value"), (Throwable)e);
            }
        }
        if (value instanceof DBDValue && value == oldValue && ((DBDValue)value).isModified() || !CommonUtils.equalObjects((Object)oldValue, (Object)value)) {
            if (ownerValue == null && DBUtils.isNullValue((Object)oldValue) && DBUtils.isNullValue((Object)value)) {
                return false;
            }
            if (ownerValue != null && !(ownerValue instanceof DBDComposite)) {
                log.warn((Object)("Value [" + ownerValue + "] edit is not supported"));
                return false;
            }
            if (row.getState() == 1) {
                Object oldOldValue;
                boolean cellWasEdited = row.changes != null && row.changes.containsKey(attr);
                Object object = oldOldValue = !cellWasEdited ? null : row.changes.get(attr);
                if (cellWasEdited && !CommonUtils.equalObjects((Object)oldValue, (Object)oldOldValue) && !CommonUtils.equalObjects((Object)oldValue, (Object)value)) {
                    DBUtils.releaseValue((Object)oldValue);
                } else if (updateChanges) {
                    if (value instanceof DBDValue || !CommonUtils.equalObjects((Object)value, (Object)oldValue)) {
                        row.addChange(attr, oldValue);
                    } else {
                        updateChanges = false;
                    }
                }
                if (updateChanges && row.getState() == 1 && !cellWasEdited) {
                    ++this.changesCount;
                }
            }
            if (ownerValue != null) {
                ((DBDComposite)ownerValue).setAttributeValue(attr.getAttribute(), value);
            } else {
                row.values[rootIndex] = value;
            }
            return true;
        }
        return false;
    }

    boolean isDynamicMetadata() {
        return this.metadataDynamic;
    }

    boolean isMetadataChanged() {
        return this.metadataChanged;
    }

    public void setMetaData(@NotNull DBCResultSet resultSet, @NotNull DBDAttributeBinding[] newAttributes) {
        boolean update = false;
        DBCStatement sourceStatement = resultSet.getSourceStatement();
        this.executionSource = sourceStatement != null ? sourceStatement.getStatementSource() : null;
        this.trace = resultSet instanceof DBCResultSetTrace ? ((DBCResultSetTrace)resultSet).getExecutionTrace() : null;
        if (this.attributes == null || this.attributes.length == 0 || this.attributes.length != newAttributes.length || this.isDynamicMetadata()) {
            update = true;
        } else {
            int i = 0;
            while (i < this.attributes.length) {
                if (!ResultSetUtils.equalAttributes(this.attributes[i].getMetaAttribute(), newAttributes[i].getMetaAttribute())) {
                    update = true;
                    break;
                }
                ++i;
            }
        }
        this.metadataChanged = update;
        if (update) {
            this.metadataChanged = ArrayUtils.isEmpty((Object[])this.attributes) || ArrayUtils.isEmpty((Object[])newAttributes) || !this.isDynamicMetadata() || this.attributes[0].getTopParent().getMetaAttribute().getSource() != newAttributes[0].getTopParent().getMetaAttribute().getSource();
        }
        this.clearData();
        this.attributes = newAttributes;
        this.documentAttribute = null;
        this.metadataDynamic = this.attributes.length > 0 && this.attributes[0].getTopParent().getDataSource().getInfo().isDynamicMetadata();
        DBDAttributeBinding realAttr = null;
        if (this.attributes.length == 1) {
            realAttr = this.attributes[0];
        } else {
            DBDAttributeBinding[] dBDAttributeBindingArray = this.attributes;
            int n = this.attributes.length;
            int n2 = 0;
            while (n2 < n) {
                DBDAttributeBinding attr = dBDAttributeBindingArray[n2];
                if (!attr.isPseudoAttribute()) {
                    if (realAttr != null) {
                        realAttr = null;
                        break;
                    }
                    realAttr = attr;
                }
                ++n2;
            }
        }
        if (realAttr != null && (realAttr.getDataKind() == DBPDataKind.DOCUMENT || realAttr.getDataKind() == DBPDataKind.CONTENT)) {
            this.documentAttribute = realAttr;
        }
        this.updateColorMapping();
    }

    public void setData(@NotNull List<Object[]> rows) {
        List nested;
        DBDAttributeBinding topAttr;
        this.clearData();
        if (!(this.attributes.length != 1 || (topAttr = this.attributes[0]).getDataKind() != DBPDataKind.DOCUMENT && topAttr.getDataKind() != DBPDataKind.STRUCT || (nested = topAttr.getNestedBindings()) == null || nested.isEmpty())) {
            this.attributes = nested.toArray(new DBDAttributeBinding[nested.size()]);
            this.fillVisibleAttributes();
        }
        this.appendData(rows);
        if (this.metadataChanged) {
            this.dataFilter = this.createDataFilter();
        } else {
            DBDDataFilter prevFilter = this.dataFilter;
            this.dataFilter = this.createDataFilter();
            this.updateDataFilter(prevFilter);
        }
        this.visibleAttributes.sort(this.POSITION_SORTER);
        DBSEntity sourceTable = null;
        for (DBDAttributeBinding attribute : this.visibleAttributes) {
            DBDRowIdentifier rowIdentifier;
            if (attribute.isPseudoAttribute() || (rowIdentifier = attribute.getRowIdentifier()) == null) continue;
            if (sourceTable == null) {
                sourceTable = rowIdentifier.getEntity();
                continue;
            }
            if (sourceTable == rowIdentifier.getEntity()) continue;
            sourceTable = null;
            break;
        }
        this.singleSourceEntity = sourceTable;
        this.updateColorMapping();
        this.hasData = true;
    }

    boolean hasColorMapping(DBDAttributeBinding binding) {
        return this.colorMapping.containsKey(binding);
    }

    boolean hasColorMapping(DBSEntity entity) {
        DBVEntity virtualEntity = DBVUtils.findVirtualEntity((DBSEntity)entity, (boolean)false);
        return virtualEntity != null && !CommonUtils.isEmpty((Collection)virtualEntity.getColorOverrides());
    }

    void updateColorMapping() {
        List coList;
        this.colorMapping.clear();
        DBSEntity entity = this.getSingleSource();
        if (entity == null) {
            return;
        }
        DBVEntity virtualEntity = DBVUtils.findVirtualEntity((DBSEntity)entity, (boolean)false);
        if (virtualEntity != null && !CommonUtils.isEmpty((Collection)(coList = virtualEntity.getColorOverrides()))) {
            for (DBVColorOverride co : coList) {
                DBDAttributeBinding binding = this.getAttributeBinding(entity, co.getAttributeName());
                if (binding == null) continue;
                List cmList = this.colorMapping.computeIfAbsent(binding, k -> new ArrayList());
                cmList.add(new AttributeColorSettings(co));
            }
        }
        this.updateRowColors(this.curRows);
    }

    private void updateRowColors(List<ResultSetRow> rows) {
        if (this.colorMapping.isEmpty()) {
            for (ResultSetRow row : rows) {
                row.foreground = null;
                row.background = null;
            }
        } else {
            for (Map.Entry<DBDAttributeBinding, List<AttributeColorSettings>> entry : this.colorMapping.entrySet()) {
                block2: for (ResultSetRow row : rows) {
                    DBDAttributeBinding binding = entry.getKey();
                    Object cellValue = this.getCellValue(binding, row);
                    for (AttributeColorSettings acs : entry.getValue()) {
                        if (!acs.evaluate(cellValue)) continue;
                        row.foreground = acs.colorForeground;
                        row.background = acs.colorBackground;
                        continue block2;
                    }
                }
            }
        }
    }

    public void appendData(@NotNull List<Object[]> rows) {
        int rowCount = rows.size();
        int firstRowNum = this.curRows.size();
        ArrayList<ResultSetRow> newRows = new ArrayList<ResultSetRow>(rowCount);
        int i = 0;
        while (i < rowCount) {
            newRows.add(new ResultSetRow(firstRowNum + i, rows.get(i)));
            ++i;
        }
        this.curRows.addAll(newRows);
        this.updateRowColors(newRows);
    }

    void clearData() {
        this.releaseAll();
        this.hasData = false;
    }

    public boolean hasData() {
        return this.hasData;
    }

    public boolean isDirty() {
        return this.changesCount != 0;
    }

    public boolean isAttributeReadOnly(@NotNull DBDAttributeBinding attribute) {
        if (attribute.getMetaAttribute().isReadOnly()) {
            return true;
        }
        DBDRowIdentifier rowIdentifier = attribute.getRowIdentifier();
        if (rowIdentifier == null || !(rowIdentifier.getEntity() instanceof DBSDataManipulator)) {
            return true;
        }
        DBSDataManipulator dataContainer = (DBSDataManipulator)rowIdentifier.getEntity();
        return (dataContainer.getSupportedFeatures() & 0x20000) == 0;
    }

    public boolean isUpdateInProgress() {
        return this.updateInProgress;
    }

    void setUpdateInProgress(boolean updateInProgress) {
        this.updateInProgress = updateInProgress;
    }

    @NotNull
    ResultSetRow addNewRow(int rowNum, @NotNull Object[] data) {
        ResultSetRow newRow = new ResultSetRow(this.curRows.size(), data);
        newRow.setVisualNumber(rowNum);
        newRow.setState((byte)2);
        this.shiftRows(newRow, 1);
        this.curRows.add(rowNum, newRow);
        ++this.changesCount;
        return newRow;
    }

    boolean deleteRow(@NotNull ResultSetRow row) {
        if (row.getState() == 2) {
            this.cleanupRow(row);
            return true;
        }
        row.setState((byte)3);
        ++this.changesCount;
        return false;
    }

    void cleanupRow(@NotNull ResultSetRow row) {
        row.release();
        this.curRows.remove(row.getVisualNumber());
        this.shiftRows(row, -1);
    }

    boolean cleanupRows(Collection<ResultSetRow> rows) {
        if (rows != null && !rows.isEmpty()) {
            ArrayList<ResultSetRow> rowsToRemove = new ArrayList<ResultSetRow>(rows);
            rowsToRemove.sort(Comparator.comparingInt(ResultSetRow::getVisualNumber));
            for (ResultSetRow row : rowsToRemove) {
                this.cleanupRow(row);
            }
            return true;
        }
        return false;
    }

    private void shiftRows(@NotNull ResultSetRow relative, int delta) {
        for (ResultSetRow row : this.curRows) {
            if (row.getVisualNumber() >= relative.getVisualNumber()) {
                row.setVisualNumber(row.getVisualNumber() + delta);
            }
            if (row.getRowNumber() < relative.getRowNumber()) continue;
            row.setRowNumber(row.getRowNumber() + delta);
        }
    }

    private void releaseAll() {
        final List<ResultSetRow> oldRows = this.curRows;
        this.curRows = new ArrayList<ResultSetRow>();
        this.totalRowCount = null;
        new AbstractJob("Cleanup model"){
            {
                super($anonymous0);
                this.setSystem(true);
            }

            protected IStatus run(DBRProgressMonitor monitor) {
                for (ResultSetRow row : oldRows) {
                    row.release();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public DBDDataFilter getDataFilter() {
        return this.dataFilter;
    }

    boolean setDataFilter(DBDDataFilter dataFilter) {
        this.dataFilter = dataFilter;
        ArrayList<DBDAttributeConstraint> newConstraints = new ArrayList<DBDAttributeConstraint>();
        DBDAttributeBinding[] dBDAttributeBindingArray = this.attributes;
        int n = this.attributes.length;
        int n2 = 0;
        while (n2 < n) {
            DBDAttributeBinding binding = dBDAttributeBindingArray[n2];
            if (dataFilter.getConstraint(binding) == null) {
                this.addConstraints(newConstraints, binding);
            }
            ++n2;
        }
        if (!newConstraints.isEmpty()) {
            dataFilter.addConstraints(newConstraints);
        }
        ArrayList<DBDAttributeBinding> newBindings = new ArrayList<DBDAttributeBinding>();
        for (DBSAttributeBase attr : this.dataFilter.getOrderedVisibleAttributes()) {
            DBDAttributeBinding binding = this.getAttributeBinding(attr);
            if (binding == null) continue;
            newBindings.add(binding);
        }
        if (!newBindings.equals(this.visibleAttributes)) {
            this.visibleAttributes = newBindings;
            return true;
        }
        return false;
    }

    void updateDataFilter(DBDDataFilter filter) {
        this.visibleAttributes.clear();
        Collections.addAll(this.visibleAttributes, this.attributes);
        for (DBDAttributeConstraint constraint : filter.getConstraints()) {
            DBDAttributeBinding attribute;
            DBDAttributeConstraint filterConstraint = this.dataFilter.getConstraint(constraint.getAttribute(), true);
            if (filterConstraint == null) continue;
            if (constraint.getOperator() != null) {
                filterConstraint.setOperator(constraint.getOperator());
                filterConstraint.setReverseOperator(constraint.isReverseOperator());
                filterConstraint.setValue(constraint.getValue());
            } else {
                filterConstraint.setCriteria(constraint.getCriteria());
            }
            filterConstraint.setOrderPosition(constraint.getOrderPosition());
            filterConstraint.setOrderDescending(constraint.isOrderDescending());
            filterConstraint.setVisible(constraint.isVisible());
            filterConstraint.setVisualPosition(constraint.getVisualPosition());
            if (!(filterConstraint.getAttribute() instanceof DBDAttributeBinding)) continue;
            if (!constraint.isVisible()) {
                this.visibleAttributes.remove(filterConstraint.getAttribute());
                continue;
            }
            if (this.visibleAttributes.contains(filterConstraint.getAttribute()) || (attribute = (DBDAttributeBinding)filterConstraint.getAttribute()).getParentObject() != null) continue;
            this.visibleAttributes.add(attribute);
        }
        if (filter.getConstraints().size() != this.attributes.length) {
            Iterator<DBDAttributeBinding> iter = this.visibleAttributes.iterator();
            while (iter.hasNext()) {
                DBDAttributeBinding attr = iter.next();
                if (filter.getConstraint((DBSAttributeBase)attr, true) != null || ResultSetModel.isVisibleByDefault(attr)) continue;
                iter.remove();
            }
        }
        this.visibleAttributes.sort(this.POSITION_SORTER);
        this.dataFilter.setWhere(filter.getWhere());
        this.dataFilter.setOrder(filter.getOrder());
        this.dataFilter.setAnyConstraint(filter.isAnyConstraint());
    }

    public void resetOrdering() {
        boolean hasOrdering = this.dataFilter.hasOrdering();
        List orderConstraints = this.dataFilter.getOrderConstraints();
        this.curRows.sort((row1, row2) -> {
            if (!hasOrdering) {
                return row1.getRowNumber() - row2.getRowNumber();
            }
            int result = 0;
            for (DBDAttributeConstraint co : orderConstraints) {
                Object cell2;
                DBDAttributeBinding binding = this.getAttributeBinding(co.getAttribute());
                if (binding == null) continue;
                Object cell1 = this.getCellValue(binding, (ResultSetRow)row1);
                if (cell1 == (cell2 = this.getCellValue(binding, (ResultSetRow)row2))) {
                    result = 0;
                } else if (DBUtils.isNullValue((Object)cell1)) {
                    result = 1;
                } else if (DBUtils.isNullValue((Object)cell2)) {
                    result = -1;
                } else if (cell1 instanceof Comparable) {
                    result = ((Comparable)cell1).compareTo(cell2);
                } else {
                    String str1 = String.valueOf(cell1);
                    String str2 = String.valueOf(cell2);
                    result = str1.compareTo(str2);
                }
                if (co.isOrderDescending()) {
                    result = -result;
                }
                if (result != 0) break;
            }
            return result;
        });
        int i = 0;
        while (i < this.curRows.size()) {
            this.curRows.get(i).setVisualNumber(i);
            ++i;
        }
    }

    private void fillVisibleAttributes() {
        DBSEntityAttribute entityAttribute;
        DBSEntity entity;
        DBPDataSourceContainer container;
        this.visibleAttributes.clear();
        boolean entityDataView = this.executionSource != null && this.executionSource.getDataContainer() instanceof DBSEntity;
        DBSObjectFilter columnFilter = null;
        if (entityDataView && (container = (entity = (DBSEntity)this.executionSource.getDataContainer()).getDataSource().getContainer()).getPreferenceStore().getBoolean("resultset.filter.use.navigator") && this.attributes.length > 0 && (entityAttribute = this.attributes[0].getEntityAttribute()) != null) {
            columnFilter = container.getObjectFilter(entityAttribute.getClass(), (DBSObject)entity, false);
        }
        DBDAttributeBinding[] dBDAttributeBindingArray = this.attributes;
        int n = this.attributes.length;
        int n2 = 0;
        while (n2 < n) {
            DBDAttributeBinding binding = dBDAttributeBindingArray[n2];
            if (!(entityDataView && !ResultSetModel.isVisibleByDefault(binding) || columnFilter != null && !columnFilter.matches(binding.getName()))) {
                this.visibleAttributes.add(binding);
            }
            ++n2;
        }
    }

    private static boolean isVisibleByDefault(DBDAttributeBinding binding) {
        return !binding.isPseudoAttribute();
    }

    public DBCStatistics getStatistics() {
        return this.statistics;
    }

    public void setStatistics(DBCStatistics statistics) {
        this.statistics = statistics;
    }

    public DBCTrace getTrace() {
        return this.trace;
    }

    public static class AttributeColorSettings {
        private DBCLogicalOperator operator;
        private Object[] attributeValues;
        private Color colorForeground;
        private Color colorBackground;

        public AttributeColorSettings(DBVColorOverride co) {
            this.operator = co.getOperator();
            this.colorForeground = UIUtils.getSharedColor((String)co.getColorForeground());
            this.colorBackground = UIUtils.getSharedColor((String)co.getColorBackground());
            this.attributeValues = co.getAttributeValues();
        }

        public DBCLogicalOperator getOperator() {
            return this.operator;
        }

        public Object[] getAttributeValues() {
            return this.attributeValues;
        }

        public Color getColorForeground() {
            return this.colorForeground;
        }

        public Color getColorBackground() {
            return this.colorBackground;
        }

        public boolean evaluate(Object cellValue) {
            return this.operator.evaluate(cellValue, this.attributeValues);
        }
    }
}

