/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.tools;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Date;
import java.util.List;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.tools.AbstractToolWizard;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class DatabaseWizardPageLog
extends WizardPage {
    private StyledText dumpLogText;
    private String task;

    public DatabaseWizardPageLog(String task) {
        super(NLS.bind((String)CoreMessages.tools_wizard_page_log_task_progress, (Object)task));
        this.task = task;
        this.setTitle(NLS.bind((String)CoreMessages.tools_wizard_page_log_task_progress, (Object)task));
        this.setDescription(NLS.bind((String)CoreMessages.tools_wizard_page_log_task_progress_log, (Object)task));
    }

    public boolean isPageComplete() {
        return true;
    }

    public void createControl(Composite parent) {
        Composite composite = UIUtils.createPlaceholder((Composite)parent, (int)1);
        this.dumpLogText = new StyledText(composite, 2826);
        GridData gd = new GridData(1808);
        this.dumpLogText.setLayoutData((Object)gd);
        this.setControl((Control)composite);
    }

    public void appendLog(String line) {
        this.appendLog(line, false);
    }

    public void appendLog(final String line, final boolean error) {
        if (this.getShell().isDisposed()) {
            return;
        }
        UIUtils.syncExec((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DatabaseWizardPageLog databaseWizardPageLog = DatabaseWizardPageLog.this;
                synchronized (databaseWizardPageLog) {
                    if (!DatabaseWizardPageLog.this.dumpLogText.isDisposed()) {
                        int caretOffset = DatabaseWizardPageLog.this.dumpLogText.getCaretOffset();
                        DatabaseWizardPageLog.this.dumpLogText.append(line);
                        DatabaseWizardPageLog.this.dumpLogText.setCaretOffset(DatabaseWizardPageLog.this.dumpLogText.getCharCount());
                        DatabaseWizardPageLog.this.dumpLogText.showSelection();
                        if (error) {
                            StyleRange style1Range = new StyleRange();
                            style1Range.start = caretOffset;
                            style1Range.length = line.length();
                            style1Range.foreground = DatabaseWizardPageLog.this.dumpLogText.getDisplay().getSystemColor(3);
                            DatabaseWizardPageLog.this.dumpLogText.setStyleRange(style1Range);
                        }
                    }
                }
            }
        });
    }

    public void clearLog() {
        if (this.getShell().isDisposed()) {
            return;
        }
        UIUtils.syncExec((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DatabaseWizardPageLog databaseWizardPageLog = DatabaseWizardPageLog.this;
                synchronized (databaseWizardPageLog) {
                    if (!DatabaseWizardPageLog.this.dumpLogText.isDisposed()) {
                        DatabaseWizardPageLog.this.dumpLogText.setText("");
                    }
                }
            }
        });
    }

    public void startLogReader(ProcessBuilder processBuilder, InputStream stream) {
        new LogReaderJob(processBuilder, stream).start();
    }

    public void startNullReader(InputStream stream) {
        new NullReaderJob(stream).start();
    }

    private class LogReaderJob
    extends Thread {
        private ProcessBuilder processBuilder;
        private InputStream input;

        protected LogReaderJob(ProcessBuilder processBuilder, InputStream stream) {
            super(NLS.bind((String)CoreMessages.tools_wizard_page_log_task_log_reader, (Object)DatabaseWizardPageLog.this.task));
            this.processBuilder = processBuilder;
            this.input = stream;
        }

        @Override
        public void run() {
            AbstractToolWizard wizard = (AbstractToolWizard)DatabaseWizardPageLog.this.getWizard();
            String lf = GeneralUtils.getDefaultLineSeparator();
            List<String> command = this.processBuilder.command();
            StringBuilder cmdString = new StringBuilder();
            for (String cmd : command) {
                if (wizard.isSecureString(cmd)) {
                    cmd = "******";
                }
                if (cmdString.length() > 0) {
                    cmdString.append(' ');
                }
                cmdString.append(cmd);
            }
            cmdString.append(lf);
            DatabaseWizardPageLog.this.appendLog(cmdString.toString());
            DatabaseWizardPageLog.this.appendLog(String.valueOf(NLS.bind((String)CoreMessages.tools_wizard_page_log_task_started_at, (Object)DatabaseWizardPageLog.this.task, (Object)new Date())) + lf);
            try {
                try {
                    InputStream in = this.input;
                    Object object = null;
                    Object var7_9 = null;
                    try (InputStreamReader reader = new InputStreamReader(in, GeneralUtils.getDefaultConsoleEncoding());){
                        int b;
                        StringBuilder buf = new StringBuilder();
                        while ((b = ((Reader)reader).read()) != -1) {
                            buf.append((char)b);
                            if (b != 10) continue;
                            DatabaseWizardPageLog.this.appendLog(buf.toString());
                            buf.setLength(0);
                        }
                    }
                    catch (Throwable throwable) {
                        if (object == null) {
                            object = throwable;
                        } else if (object != throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                        throw object;
                    }
                }
                catch (IOException e) {
                    DatabaseWizardPageLog.this.appendLog(String.valueOf(e.getMessage()) + lf);
                    DatabaseWizardPageLog.this.appendLog(String.valueOf(NLS.bind((String)CoreMessages.tools_wizard_page_log_task_finished, (Object)DatabaseWizardPageLog.this.task, (Object)new Date())) + lf);
                }
            }
            finally {
                DatabaseWizardPageLog.this.appendLog(String.valueOf(NLS.bind((String)CoreMessages.tools_wizard_page_log_task_finished, (Object)DatabaseWizardPageLog.this.task, (Object)new Date())) + lf);
            }
        }
    }

    private class NullReaderJob
    extends Thread {
        private InputStream input;

        protected NullReaderJob(InputStream stream) {
            super(NLS.bind((String)CoreMessages.tools_wizard_page_log_task_log_reader, (Object)DatabaseWizardPageLog.this.task));
            this.input = stream;
        }

        @Override
        public void run() {
            try {
                int count;
                byte[] buffer = new byte[1000];
                while ((count = this.input.read(buffer)) > 0) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

