/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dialogs.connection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.core.CoreMessages;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.properties.PropertySourceCustom;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.dbeaver.ui.properties.PropertyTreeViewer;
import org.jkiss.utils.CommonUtils;

public class ConnectionPropertiesControl
extends PropertyTreeViewer {
    private static final Log log = Log.getLog(ConnectionPropertiesControl.class);
    public static final String USER_PROPERTIES_CATEGORY = CoreMessages.controls_connection_properties_category_user_properties;
    private List<DBPPropertyDescriptor> driverProvidedProperties;
    private List<DBPPropertyDescriptor> customProperties;
    private static Comparator<DBPPropertyDescriptor> PROPERTIES_COMPARATOR = new Comparator<DBPPropertyDescriptor>(){

        @Override
        public int compare(DBPPropertyDescriptor o1, DBPPropertyDescriptor o2) {
            return o1.getDisplayName().compareTo(o2.getDisplayName());
        }
    };

    public ConnectionPropertiesControl(Composite parent, int style) {
        super(parent, style);
        this.setExpandSingleRoot(false);
    }

    public PropertySourceCustom makeProperties(DBRProgressMonitor monitor, DBPDriver driver, DBPConnectionConfiguration connectionInfo) {
        HashMap<Object, Object> connectionProps = new HashMap<Object, Object>();
        connectionProps.putAll(driver.getConnectionProperties());
        connectionProps.putAll(connectionInfo.getProperties());
        this.driverProvidedProperties = null;
        this.customProperties = null;
        this.loadDriverProperties(monitor, driver, connectionInfo);
        this.loadCustomProperties(driver, connectionProps);
        return new PropertySourceCustom(this.getAllProperties(driver, true), connectionProps);
    }

    public PropertySourceCustom makeProperties(DBPDriver driver, Map<Object, Object> properties) {
        this.driverProvidedProperties = null;
        this.customProperties = null;
        this.loadCustomProperties(driver, properties);
        return new PropertySourceCustom(this.getAllProperties(driver, true), properties);
    }

    protected String[] getCustomCategories() {
        return new String[]{USER_PROPERTIES_CATEGORY};
    }

    protected void contributeContextMenu(IMenuManager manager, final Object node, final String category, DBPPropertyDescriptor property) {
        boolean isCustom = USER_PROPERTIES_CATEGORY.equals(category);
        if (isCustom) {
            manager.add((IAction)new Action(CoreMessages.controls_connection_properties_action_add_property){

                public void run() {
                    ConnectionPropertiesControl.this.createNewProperty(node, category);
                }
            });
            if (property != null) {
                manager.add((IAction)new Action(CoreMessages.controls_connection_properties_action_remove_property){

                    public void run() {
                        ConnectionPropertiesControl.this.removeProperty(node);
                    }
                });
            }
        }
    }

    protected boolean isHidePropertyValue(DBPPropertyDescriptor property) {
        return CommonUtils.toString((Object)property.getId()).toLowerCase(Locale.ENGLISH).contains("password");
    }

    private void createNewProperty(Object node, String category) {
        String propName = EnterNameDialog.chooseName((Shell)this.getControl().getShell(), (String)CoreMessages.controls_connection_properties_dialog_new_property_title);
        if (propName != null) {
            this.addProperty(node, (DBPPropertyDescriptor)new PropertyDescriptor(category, (Object)propName, propName, null, null, false, null, null, true));
        }
    }

    private List<DBPPropertyDescriptor> getAllProperties(DBPDriver driver, boolean includeCustom) {
        ArrayList<DBPPropertyDescriptor> propertyDescriptors = new ArrayList<DBPPropertyDescriptor>();
        propertyDescriptors.addAll(driver.getConnectionPropertyDescriptors());
        if (this.driverProvidedProperties != null) {
            propertyDescriptors.addAll(this.driverProvidedProperties);
        }
        if (includeCustom && this.customProperties != null) {
            propertyDescriptors.addAll(this.customProperties);
        }
        propertyDescriptors.sort(PROPERTIES_COMPARATOR);
        return propertyDescriptors;
    }

    private void loadDriverProperties(DBRProgressMonitor monitor, DBPDriver driver, DBPConnectionConfiguration connectionInfo) {
        try {
            DBPPropertyDescriptor[] connectionsProps = driver.getDataSourceProvider().getConnectionProperties(monitor, driver, connectionInfo);
            this.driverProvidedProperties = new ArrayList<DBPPropertyDescriptor>();
            if (connectionsProps != null) {
                Collections.addAll(this.driverProvidedProperties, connectionsProps);
            }
        }
        catch (DBException e) {
            log.warn((Object)"Can't load driver properties", (Throwable)e);
        }
    }

    private void loadCustomProperties(DBPDriver driver, Map<Object, Object> properties) {
        TreeSet<String> propNames = new TreeSet<String>();
        List<DBPPropertyDescriptor> allProperties = this.getAllProperties(driver, false);
        for (DBPPropertyDescriptor prop : allProperties) {
            propNames.add(CommonUtils.toString((Object)prop.getId()));
        }
        this.customProperties = new ArrayList<DBPPropertyDescriptor>();
        for (Object propId : properties.keySet()) {
            String propName = propId.toString();
            if (propNames.contains(propName)) continue;
            this.customProperties.add((DBPPropertyDescriptor)new PropertyDescriptor(USER_PROPERTIES_CATEGORY, (Object)propName, propName, null, String.class, false, null, null, true));
        }
        this.customProperties.sort(PROPERTIES_COMPARATOR);
    }
}

