/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.mysql.edit;

import java.util.Arrays;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.mysql.MySQLConstants;
import org.jkiss.dbeaver.ext.mysql.MySQLMessages;
import org.jkiss.dbeaver.ext.mysql.model.MySQLCatalog;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTable;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableColumn;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableIndex;
import org.jkiss.dbeaver.ext.mysql.model.MySQLTableIndexColumn;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.struct.JDBCTableIndex;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLIndexManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSIndexType;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndexColumn;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.object.struct.AttributesSelectorPage;
import org.jkiss.dbeaver.ui.editors.object.struct.EditIndexPage;
import org.jkiss.utils.CommonUtils;

public class MySQLIndexManager
extends SQLIndexManager<MySQLTableIndex, MySQLTable> {
    @Nullable
    public DBSObjectCache<MySQLCatalog, MySQLTableIndex> getObjectsCache(MySQLTableIndex object) {
        return ((MySQLCatalog)((MySQLTable)object.getTable()).getContainer()).getIndexCache();
    }

    protected MySQLTableIndex createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, final MySQLTable parent, Object from) {
        return (MySQLTableIndex)((Object)new UITask<MySQLTableIndex>(){

            protected MySQLTableIndex runTask() {
                MyEditIndexPage editPage = new MyEditIndexPage(parent);
                if (!editPage.edit()) {
                    return null;
                }
                MySQLTableIndex index = new MySQLTableIndex(parent, !editPage.isUnique(), null, editPage.getIndexType(), null, false);
                StringBuilder idxName = new StringBuilder(64);
                idxName.append(CommonUtils.escapeIdentifier((String)parent.getName()));
                int colIndex = 1;
                for (DBSEntityAttribute tableColumn : editPage.getSelectedAttributes()) {
                    if (colIndex == 1) {
                        idxName.append("_").append(CommonUtils.escapeIdentifier((String)tableColumn.getName()));
                    }
                    Integer length = (Integer)editPage.getAttributeProperty(tableColumn, "length");
                    index.addColumn(new MySQLTableIndexColumn(index, (MySQLTableColumn)tableColumn, colIndex++, !Boolean.TRUE.equals(editPage.getAttributeProperty(tableColumn, "desc")), false, length == null ? null : String.valueOf(length)));
                }
                idxName.append("_IDX");
                index.setName(DBObjectNameCaseTransformer.transformObjectName((DBSObject)index, (String)idxName.toString()));
                return index;
            }
        }.execute());
    }

    protected String getDropIndexPattern(MySQLTableIndex index) {
        return "ALTER TABLE %TABLE% DROP INDEX %INDEX_SHORT%";
    }

    protected void appendIndexType(MySQLTableIndex index, StringBuilder decl) {
        DBSIndexType indexType = index.getIndexType();
        if (indexType != MySQLConstants.INDEX_TYPE_FULLTEXT) {
            decl.append(" USING ").append(indexType.getId());
        }
    }

    protected void appendIndexModifiers(MySQLTableIndex index, StringBuilder decl) {
        if (index.getIndexType() == MySQLConstants.INDEX_TYPE_FULLTEXT) {
            decl.append(" FULLTEXT");
        } else {
            super.appendIndexModifiers((JDBCTableIndex)index, decl);
        }
    }

    protected void appendIndexColumnModifiers(DBRProgressMonitor monitor, StringBuilder decl, DBSTableIndexColumn indexColumn) {
        String subPart = ((MySQLTableIndexColumn)indexColumn).getSubPart();
        if (!CommonUtils.isEmpty((String)subPart)) {
            decl.append(" (").append(subPart).append(")");
        }
        if (!indexColumn.isAscending()) {
            decl.append(" DESC");
        }
    }

    private static class MyEditIndexPage
    extends EditIndexPage {
        public static final String PROP_LENGTH = "length";
        private int lengthColumnIndex;

        public MyEditIndexPage(MySQLTable parent) {
            super(MySQLMessages.edit_index_manager_title, (DBSTable)parent, Arrays.asList(MySQLConstants.INDEX_TYPE_BTREE, MySQLConstants.INDEX_TYPE_FULLTEXT, MySQLConstants.INDEX_TYPE_HASH, MySQLConstants.INDEX_TYPE_RTREE));
        }

        protected void createAttributeColumns(Table columnsTable) {
            super.createAttributeColumns(columnsTable);
            TableColumn colDesc = UIUtils.createTableColumn((Table)columnsTable, (int)0, (String)"Length");
            colDesc.setToolTipText("Index length (for varchar columns)");
        }

        protected int fillAttributeColumns(DBSEntityAttribute attribute, AttributesSelectorPage.AttributeInfo attributeInfo, TableItem columnItem) {
            this.lengthColumnIndex = super.fillAttributeColumns(attribute, attributeInfo, columnItem) + 1;
            Integer length = (Integer)attributeInfo.getProperty(PROP_LENGTH);
            columnItem.setText(this.lengthColumnIndex, length == null ? "" : length.toString());
            return this.lengthColumnIndex;
        }

        protected Control createCellEditor(Table table, int index, TableItem item, AttributesSelectorPage.AttributeInfo attributeInfo) {
            if (index == this.lengthColumnIndex && attributeInfo.getAttribute().getDataKind() == DBPDataKind.STRING) {
                Integer length = (Integer)attributeInfo.getProperty(PROP_LENGTH);
                Spinner spinner = new Spinner((Composite)table, 2048);
                spinner.setMinimum(0);
                spinner.setMaximum((int)attributeInfo.getAttribute().getMaxLength());
                if (length != null) {
                    spinner.setSelection(length.intValue());
                }
                return spinner;
            }
            return super.createCellEditor(table, index, item, attributeInfo);
        }

        protected void saveCellValue(Control control, int index, TableItem item, AttributesSelectorPage.AttributeInfo attributeInfo) {
            if (index == this.lengthColumnIndex) {
                Spinner spinner = (Spinner)control;
                int length = spinner.getSelection();
                item.setText(index, length <= 0 ? "" : String.valueOf(length));
                if (length <= 0) {
                    attributeInfo.setProperty(PROP_LENGTH, null);
                } else {
                    attributeInfo.setProperty(PROP_LENGTH, (Object)length);
                }
            } else {
                super.saveCellValue(control, index, item, attributeInfo);
            }
        }
    }
}

