/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.postgresql.PostgreUtils;
import org.jkiss.dbeaver.ext.postgresql.edit.PostgreTableColumnManager;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreSchema;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableColumn;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreTableReal;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.DBObjectNameCaseTransformer;
import org.jkiss.dbeaver.model.impl.edit.SQLDatabasePersistAction;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableIndex;
import org.jkiss.utils.CommonUtils;

public abstract class PostgreViewBase
extends PostgreTableReal {
    private String source;

    public PostgreViewBase(PostgreSchema catalog) {
        super(catalog);
    }

    public PostgreViewBase(PostgreSchema catalog, ResultSet dbResult) {
        super(catalog, dbResult);
    }

    @Property(viewable=true, editable=true, valueTransformer=DBObjectNameCaseTransformer.class, order=1)
    @NotNull
    public String getName() {
        return super.getName();
    }

    public boolean isView() {
        return true;
    }

    public Collection<? extends DBSTableIndex> getIndexes(DBRProgressMonitor monitor) throws DBException {
        return null;
    }

    public String getSource() {
        return this.source;
    }

    @Property(hidden=true, editable=true, updatable=true, order=-1)
    public String getObjectDefinitionText(DBRProgressMonitor monitor, Map<String, Object> options) throws DBException {
        block19: {
            if (this.source == null) {
                if (this.isPersisted()) {
                    try {
                        Throwable throwable = null;
                        Object var4_6 = null;
                        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBSObject)this, (String)"Read view definition");){
                            String definition = JDBCUtils.queryString((JDBCSession)session, (String)("SELECT pg_get_viewdef(" + this.getObjectId() + ", true)"), (Object[])new Object[0]);
                            this.source = PostgreUtils.getViewDDL(monitor, this, definition);
                            String extDefinition = this.readExtraDefinition(session, options);
                            if (extDefinition != null) {
                                this.source = String.valueOf(this.source) + "\n" + extDefinition;
                            }
                            break block19;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (SQLException e) {
                        throw new DBException("Error reading view definition: " + e.getMessage(), (Throwable)e);
                    }
                }
                this.source = "";
            }
        }
        ArrayList<DBEPersistAction> actions = new ArrayList<DBEPersistAction>();
        if (CommonUtils.getOption(options, (String)"pg.ddl.show.column.comments")) {
            if (this.getDescription() != null) {
                actions.add((DBEPersistAction)new SQLDatabasePersistAction("Comment", "COMMENT ON " + this.getViewType() + " " + this.getFullyQualifiedName(DBPEvaluationContext.DDL) + " IS " + SQLUtils.quoteString((DBSObject)this, (String)this.getDescription())));
            }
            for (PostgreTableColumn column : CommonUtils.safeCollection((Collection)this.getAttributes(monitor))) {
                if (CommonUtils.isEmpty((String)column.getDescription())) continue;
                PostgreTableColumnManager.addColumnCommentAction(actions, column);
            }
        }
        if (this.isPersisted() && CommonUtils.getOption(options, (String)"pg.ddl.show.permissions")) {
            PostgreUtils.getObjectGrantPermissionActions(monitor, this, actions, options);
        }
        StringBuilder ddl = new StringBuilder(this.source);
        if (!actions.isEmpty()) {
            ddl.append("\n\n").append(SQLUtils.generateScript((DBPDataSource)this.getDataSource(), (DBEPersistAction[])actions.toArray(new DBEPersistAction[actions.size()]), (boolean)false));
        }
        return ddl.toString();
    }

    protected String readExtraDefinition(JDBCSession session, Map<String, Object> options) throws DBException {
        return null;
    }

    @Override
    public void setObjectDefinitionText(String sourceText) throws DBException {
        this.source = sourceText;
    }

    public abstract String getViewType();

    @Override
    public DBSObject refreshObject(DBRProgressMonitor monitor) throws DBException {
        this.source = null;
        return super.refreshObject(monitor);
    }
}

