/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.stream.exporter;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.List;
import javax.imageio.ImageIO;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.data.DBDAttributeBinding;
import org.jkiss.dbeaver.model.data.DBDContent;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.tools.transfer.stream.IStreamDataExporterSite;
import org.jkiss.dbeaver.tools.transfer.stream.exporter.StreamExporterAbstract;
import org.jkiss.dbeaver.utils.ContentUtils;
import org.jkiss.utils.CommonUtils;

public class DataExporterXML
extends StreamExporterAbstract {
    private PrintWriter out;
    private List<DBDAttributeBinding> columns;
    private String tableName;

    @Override
    public void init(IStreamDataExporterSite site) throws DBException {
        super.init(site);
        this.out = site.getWriter();
    }

    @Override
    public void dispose() {
        this.out = null;
        super.dispose();
    }

    @Override
    public void exportHeader(DBCSession session) throws DBException, IOException {
        this.columns = this.getSite().getAttributes();
        this.printHeader();
    }

    private void printHeader() {
        this.out.write("<?xml version=\"1.0\" ?>\n");
        this.tableName = this.escapeXmlElementName(this.getSite().getSource().getName());
        this.out.write("<!DOCTYPE " + this.tableName + " [\n");
        this.out.write("  <!ELEMENT " + this.tableName + " (DATA_RECORD*)>\n");
        this.out.write("  <!ELEMENT DATA_RECORD (");
        int columnsSize = this.columns.size();
        int i = 0;
        while (i < columnsSize) {
            String colName = this.columns.get(i).getLabel();
            if (CommonUtils.isEmpty((String)colName)) {
                colName = this.columns.get(i).getName();
            }
            this.out.write(String.valueOf(this.escapeXmlElementName(colName)) + "?");
            if (i < columnsSize - 1) {
                this.out.write(",");
            }
            ++i;
        }
        this.out.write(")+>\n");
        i = 0;
        while (i < columnsSize) {
            this.out.write("  <!ELEMENT " + this.escapeXmlElementName(this.columns.get(i).getName()) + " (#PCDATA)>\n");
            ++i;
        }
        this.out.write("]>\n");
        this.out.write("<" + this.tableName + ">\n");
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void exportRow(DBCSession session, DBCResultSet resultSet, Object[] row) throws DBException, IOException {
        this.out.write("  <DATA_RECORD>\n");
        i = 0;
        while (i < row.length) {
            column = this.columns.get(i);
            columnName = this.escapeXmlElementName(column.getName());
            this.out.write("    <" + columnName + ">");
            if (DBUtils.isNullValue((Object)row[i])) {
                this.writeTextCell(null);
            } else if (row[i] instanceof DBDContent) {
                content = (DBDContent)row[i];
                try {
                    cs = content.getContents(session.getProgressMonitor());
                    if (cs == null) ** GOTO lbl40
                    if (ContentUtils.isTextContent((DBDContent)content)) {
                        var9_9 = null;
                        var10_11 = null;
                        try {
                            reader = cs.getContentReader();
                            try {
                                this.writeCellValue(reader);
                            }
                            finally {
                                if (reader != null) {
                                    reader.close();
                                }
                            }
                        }
                        catch (Throwable var10_12) {
                            if (var9_9 == null) {
                                var9_9 = var10_12;
                            } else if (var9_9 != var10_12) {
                                var9_9.addSuppressed(var10_12);
                            }
                            throw var9_9;
                        }
                    }
                    this.getSite().writeBinaryData(cs);
                }
                finally {
                    content.release();
                }
            } else {
                this.writeTextCell(super.getValueDisplayString(column, row[i]));
            }
lbl40:
            // 5 sources

            this.out.write("</" + columnName + ">\n");
            ++i;
        }
        this.out.write("  </DATA_RECORD>\n");
    }

    @Override
    public void exportFooter(DBRProgressMonitor monitor) throws IOException {
        this.out.write("</" + this.tableName + ">\n");
    }

    private void writeTextCell(@Nullable String value) {
        if (value != null) {
            value = value.replace("<", "&lt;").replace(">", "&gt;").replace("&", "&amp;");
            this.out.write(value);
        }
    }

    private void writeImageCell(File file) throws DBException {
        if (file != null && file.exists()) {
            BufferedImage image = null;
            try {
                image = ImageIO.read(file);
            }
            catch (IOException e) {
                throw new DBException("Can't read an exported image " + image, (Throwable)e);
            }
            if (image != null) {
                String imagePath = file.getAbsolutePath();
                imagePath = "files/" + imagePath.substring(imagePath.lastIndexOf(File.separator));
                this.out.write(imagePath);
            }
        }
    }

    private void writeCellValue(Reader reader) throws IOException {
        int count;
        char[] buffer = new char[2000];
        while ((count = reader.read(buffer)) > 0) {
            int i = 0;
            while (i < count) {
                if (buffer[i] == '<') {
                    this.out.write("&lt;");
                } else if (buffer[i] == '>') {
                    this.out.write("&gt;");
                } else if (buffer[i] == '&') {
                    this.out.write("&amp;");
                } else {
                    this.out.write(buffer[i]);
                }
                ++i;
            }
        }
    }

    private String escapeXmlElementName(String name) {
        return name.replaceAll("[^\\p{Alpha}\\p{Digit}]+", "_");
    }
}

