/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.generic.edit;

import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.generic.model.GenericPrimaryKey;
import org.jkiss.dbeaver.ext.generic.model.GenericStructContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.generic.model.GenericTableColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericTableConstraintColumn;
import org.jkiss.dbeaver.ext.generic.model.GenericUtils;
import org.jkiss.dbeaver.model.edit.DBECommandContext;
import org.jkiss.dbeaver.model.impl.DBSObjectCache;
import org.jkiss.dbeaver.model.impl.sql.edit.struct.SQLConstraintManager;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityAttribute;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.editors.object.struct.EditConstraintPage;

public class GenericPrimaryKeyManager
extends SQLConstraintManager<GenericPrimaryKey, GenericTable> {
    @Nullable
    public DBSObjectCache<? extends DBSObject, GenericPrimaryKey> getObjectsCache(GenericPrimaryKey object) {
        return ((GenericStructContainer)((GenericTable)object.getParentObject()).getContainer()).getPrimaryKeysCache();
    }

    protected GenericPrimaryKey createDatabaseObject(DBRProgressMonitor monitor, DBECommandContext context, final GenericTable parent, Object from) {
        return (GenericPrimaryKey)((Object)new UITask<GenericPrimaryKey>(){

            protected GenericPrimaryKey runTask() {
                EditConstraintPage editPage = new EditConstraintPage("Create constraint", (DBSEntity)parent, new DBSEntityConstraintType[]{DBSEntityConstraintType.PRIMARY_KEY, DBSEntityConstraintType.UNIQUE_KEY});
                if (!editPage.edit()) {
                    return null;
                }
                GenericPrimaryKey primaryKey = new GenericPrimaryKey(parent, null, null, editPage.getConstraintType(), false);
                primaryKey.setName(editPage.getConstraintName());
                int colIndex = 1;
                for (DBSEntityAttribute tableColumn : editPage.getSelectedAttributes()) {
                    primaryKey.addColumn(new GenericTableConstraintColumn(primaryKey, (GenericTableColumn)tableColumn, colIndex++));
                }
                return primaryKey;
            }
        }.execute());
    }

    protected boolean isLegacyConstraintsSyntax(GenericTable owner) {
        return GenericUtils.isLegacySQLDialect((DBSObject)owner);
    }
}

