/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.javafx.collections.TrackableObservableList;
import com.sun.javafx.tk.quantum.PrismEvent;
import com.sun.javafx.tk.quantum.ViewScene;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.input.InputMethodHighlight;
import javafx.scene.input.InputMethodTextRun;

public class GlassPrismInputMethodEvent
implements PrismEvent {
    ViewScene view;
    String text;
    int[] clauseBoundary;
    int[] attrBoundary;
    byte[] attrValue;
    int commitCount;
    int cursorPos;
    private static final byte ATTR_INPUT = 0;
    private static final byte ATTR_TARGET_CONVERTED = 1;
    private static final byte ATTR_CONVERTED = 2;
    private static final byte ATTR_TARGET_NOTCONVERTED = 3;
    private static final byte ATTR_INPUT_ERROR = 4;

    public void handleInputMethodEvent(long l, String string, int[] nArray, int[] nArray2, byte[] byArray, int n, int n2) {
    }

    protected GlassPrismInputMethodEvent(ViewScene viewScene, String string, int[] nArray, int[] nArray2, byte[] byArray, int n, int n2) {
        this.view = viewScene;
        this.text = string == null ? "" : string;
        this.clauseBoundary = nArray;
        this.attrBoundary = nArray2;
        this.attrValue = byArray;
        this.commitCount = n;
        this.cursorPos = n2;
    }

    protected ViewScene view() {
        return this.view;
    }

    protected ObservableList<InputMethodTextRun> getComposed() {
        TrackableObservableList<InputMethodTextRun> trackableObservableList = new TrackableObservableList<InputMethodTextRun>(){

            @Override
            protected void onChanged(ListChangeListener.Change<InputMethodTextRun> change) {
            }
        };
        if (this.commitCount < this.text.length()) {
            if (this.clauseBoundary == null) {
                trackableObservableList.add(InputMethodTextRun.impl_inputMethodTextRun(this.text.substring(this.commitCount), InputMethodHighlight.UNSELECTED_RAW));
            } else {
                for (int i = 0; i < this.clauseBoundary.length - 1; ++i) {
                    InputMethodHighlight inputMethodHighlight;
                    if (this.clauseBoundary[i] < this.commitCount) continue;
                    switch (this.getAttrValue(this.clauseBoundary[i])) {
                        case 1: {
                            inputMethodHighlight = InputMethodHighlight.SELECTED_CONVERTED;
                            break;
                        }
                        case 2: {
                            inputMethodHighlight = InputMethodHighlight.UNSELECTED_CONVERTED;
                            break;
                        }
                        case 3: {
                            inputMethodHighlight = InputMethodHighlight.SELECTED_RAW;
                            break;
                        }
                        default: {
                            inputMethodHighlight = InputMethodHighlight.UNSELECTED_RAW;
                        }
                    }
                    trackableObservableList.add(InputMethodTextRun.impl_inputMethodTextRun(this.text.substring(this.clauseBoundary[i], this.clauseBoundary[i + 1]), inputMethodHighlight));
                }
            }
        }
        return trackableObservableList;
    }

    protected String getCommitted() {
        return this.text.substring(0, this.commitCount);
    }

    protected int getCursorPos() {
        return this.cursorPos;
    }

    private byte getAttrValue(int n) {
        byte by = 4;
        if (this.attrBoundary != null) {
            for (int i = 0; i < this.attrBoundary.length - 1; ++i) {
                if (n < this.attrBoundary[i] || n >= this.attrBoundary[i + 1]) continue;
                by = this.attrValue[i];
                break;
            }
        }
        return by;
    }
}

