/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.sessions;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.model.Session;
import org.zaproxy.zap.extension.sessions.ContextSessionManagementPanel;
import org.zaproxy.zap.extension.sessions.SessionManagementAPI;
import org.zaproxy.zap.model.Context;
import org.zaproxy.zap.model.ContextDataFactory;
import org.zaproxy.zap.session.CookieBasedSessionManagementMethodType;
import org.zaproxy.zap.session.HttpAuthSessionManagementMethodType;
import org.zaproxy.zap.session.SessionManagementMethod;
import org.zaproxy.zap.session.SessionManagementMethodType;
import org.zaproxy.zap.view.AbstractContextPropertiesPanel;
import org.zaproxy.zap.view.ContextPanelFactory;

public class ExtensionSessionManagement
extends ExtensionAdaptor
implements ContextPanelFactory,
ContextDataFactory {
    public static final String NAME = "ExtensionSessionManagement";
    public static final String CONTEXT_CONFIG_SESSION = "context.session";
    public static final String CONTEXT_CONFIG_SESSION_TYPE = "context.session.type";
    private static final Logger log = Logger.getLogger(ExtensionSessionManagement.class);
    List<SessionManagementMethodType> sessionManagementMethodTypes;
    private Map<Integer, ContextSessionManagementPanel> contextPanelsMap = new HashMap<Integer, ContextSessionManagementPanel>();
    private SessionManagementAPI api;

    public ExtensionSessionManagement() {
        this.initialize();
    }

    private void initialize() {
        this.setName(NAME);
        this.setOrder(103);
    }

    @Override
    public String getUIName() {
        return Constant.messages.getString("sessionmanagement.name");
    }

    @Override
    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        extensionHook.addContextDataFactory(this);
        if (this.getView() != null) {
            extensionHook.getHookView().addContextPanelFactory(this);
        }
        this.loadSesssionManagementMethodTypes(extensionHook);
        this.api = new SessionManagementAPI(this);
        extensionHook.addApiImplementor(this.api);
    }

    @Override
    public AbstractContextPropertiesPanel getContextPanel(Context context) {
        ContextSessionManagementPanel panel = this.contextPanelsMap.get(context.getIndex());
        if (panel == null) {
            panel = new ContextSessionManagementPanel(this, context);
            this.contextPanelsMap.put(context.getIndex(), panel);
        }
        return panel;
    }

    @Override
    public URL getURL() {
        try {
            return new URL("http://www.owasp.org/index.php/ZAP");
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public String getAuthor() {
        return "ZAP Dev Team";
    }

    public List<SessionManagementMethodType> getSessionManagementMethodTypes() {
        return this.sessionManagementMethodTypes;
    }

    private void loadSesssionManagementMethodTypes(ExtensionHook extensionHook) {
        this.sessionManagementMethodTypes = new ArrayList<SessionManagementMethodType>();
        this.sessionManagementMethodTypes.add(new CookieBasedSessionManagementMethodType());
        this.sessionManagementMethodTypes.add(new HttpAuthSessionManagementMethodType());
        for (SessionManagementMethodType t : this.sessionManagementMethodTypes) {
            t.hook(extensionHook);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Loaded session management method types: " + this.sessionManagementMethodTypes));
        }
    }

    @Override
    public void discardContexts() {
        this.contextPanelsMap.clear();
    }

    @Override
    public void discardContext(Context c) {
        this.contextPanelsMap.remove(c.getIndex());
    }

    public SessionManagementMethodType getSessionManagementMethodTypeForIdentifier(int id) {
        for (SessionManagementMethodType t : this.getSessionManagementMethodTypes()) {
            if (t.getUniqueIdentifier() != id) continue;
            return t;
        }
        return null;
    }

    @Override
    public void loadContextData(Session session, Context context) {
        try {
            SessionManagementMethodType t;
            List<String> typeL = session.getContextDataStrings(context.getIndex(), 220);
            if (typeL != null && typeL.size() > 0 && (t = this.getSessionManagementMethodTypeForIdentifier(Integer.parseInt(typeL.get(0)))) != null) {
                context.setSessionManagementMethod(t.loadMethodFromSession(session, context.getIndex()));
            }
        }
        catch (DatabaseException e) {
            log.error((Object)"Unable to load Session Management method.", (Throwable)e);
        }
    }

    @Override
    public void persistContextData(Session session, Context context) {
        try {
            SessionManagementMethodType t = context.getSessionManagementMethod().getType();
            session.setContextData(context.getIndex(), 220, Integer.toString(t.getUniqueIdentifier()));
            t.persistMethodToSession(session, context.getIndex(), context.getSessionManagementMethod());
        }
        catch (DatabaseException e) {
            log.error((Object)"Unable to persist Session Management method.", (Throwable)e);
        }
    }

    @Override
    public void exportContextData(Context ctx, Configuration config) {
        SessionManagementMethodType type = ctx.getSessionManagementMethod().getType();
        config.setProperty(CONTEXT_CONFIG_SESSION_TYPE, (Object)type.getUniqueIdentifier());
        type.exportData(config, ctx.getSessionManagementMethod());
    }

    @Override
    public void importContextData(Context ctx, Configuration config) throws ConfigurationException {
        SessionManagementMethodType t = this.getSessionManagementMethodTypeForIdentifier(config.getInt(CONTEXT_CONFIG_SESSION_TYPE));
        if (t != null) {
            SessionManagementMethod method = t.createSessionManagementMethod(ctx.getIndex());
            t.importData(config, method);
            ctx.setSessionManagementMethod(method);
        }
    }
}

