/**
 * Makes all properties of a type recursively optional
 * @see https://stackoverflow.com/questions/41980195/recursive-partialt-in-typescript-2-1
 * @since TypeScript 2.8
 */
export declare type RecursivePartial<T> = {
    [P in keyof T]?: T[P] extends (infer U)[] ? RecursivePartial<U>[] : T[P] extends object ? RecursivePartial<T[P]> : T[P];
};
/**
 * Creates a type from a given interface but excludes the selected keys
 * ```
 * interface AB {a: string, b: string};
 * type ABwithoutA = Omit<AB, "a">;
 * ```
 * @see https://stackoverflow.com/questions/48215950/exclude-property-from-type
 * @since TypeScript 2.8
 */
export declare type Omit<T, U> = Pick<T, Exclude<keyof T, U>>;
