"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var electron_1 = require("electron");
var eventType_1 = require("../lib/eventType");
var locale = require("../locale/locale");
var getLogger_1 = require("../logging/getLogger");
var EnvironmentUtil = require("../runtime/EnvironmentUtil");
var AutomatedSingleSignOn_1 = require("../sso/AutomatedSingleSignOn");
var logger = getLogger_1.getLogger('preload');
electron_1.webFrame.setZoomFactor(1.0);
electron_1.webFrame.setVisualZoomLevelLimits(1, 1);
window.locStrings = locale.LANGUAGES[locale.getCurrent()];
window.locStringsDefault = locale.LANGUAGES.en;
window.isMac = EnvironmentUtil.platform.IS_MAC_OS;
var getSelectedWebview = function () { return document.querySelector('.Webview:not(.hide)'); };
var getWebviewById = function (id) {
    return document.querySelector(".Webview[data-accountid=\"" + id + "\"]");
};
var subscribeToMainProcessEvents = function () {
    electron_1.ipcRenderer.on(eventType_1.EVENT_TYPE.ACCOUNT.SSO_LOGIN, function (event, code) {
        return new AutomatedSingleSignOn_1.AutomatedSingleSignOn().start(code);
    });
    electron_1.ipcRenderer.on(eventType_1.EVENT_TYPE.UI.SYSTEM_MENU, function (event, action) {
        var selectedWebview = getSelectedWebview();
        if (selectedWebview) {
            selectedWebview.send(action);
        }
    });
    electron_1.ipcRenderer.on(eventType_1.EVENT_TYPE.WEBAPP.CHANGE_LOCATION_HASH, function (event, hash) {
        var selectedWebview = getSelectedWebview();
        if (selectedWebview) {
            selectedWebview.send(eventType_1.EVENT_TYPE.WEBAPP.CHANGE_LOCATION_HASH, hash);
        }
    });
    electron_1.ipcRenderer.on(eventType_1.EVENT_TYPE.WRAPPER.RELOAD, function () {
        var webviews = document.querySelectorAll('webview');
        webviews.forEach(function (webview) { return webview.reload(); });
    });
};
var setupIpcInterface = function () {
    window.sendBadgeCount = function (count) {
        electron_1.ipcRenderer.send(eventType_1.EVENT_TYPE.UI.BADGE_COUNT, count);
    };
    window.sendDeleteAccount = function (accountID, sessionID) {
        return new Promise(function (resolve, reject) {
            var accountWebview = getWebviewById(accountID);
            if (!accountWebview) {
                return reject("Webview for account \"" + accountID + "\" does not exist");
            }
            console.log("Processing deletion of \"" + accountID + "\"");
            var viewInstanceId = accountWebview.getWebContents().id;
            electron_1.ipcRenderer.on(eventType_1.EVENT_TYPE.ACCOUNT.DATA_DELETED, function () { return resolve(); });
            electron_1.ipcRenderer.send(eventType_1.EVENT_TYPE.ACCOUNT.DELETE_DATA, viewInstanceId, accountID, sessionID);
        });
    };
    window.sendLogoutAccount = function (accountId) {
        var accountWebview = getWebviewById(accountId);
        if (accountWebview) {
            logger.log("Sending logout signal to webview for account \"" + accountId + "\".");
            accountWebview.send(eventType_1.EVENT_TYPE.ACTION.SIGN_OUT);
        }
    };
};
var addDragRegion = function () {
    if (EnvironmentUtil.platform.IS_MAC_OS) {
        var titleBar = document.createElement('div');
        titleBar.className = 'drag-region';
        document.body.appendChild(titleBar);
    }
};
setupIpcInterface();
subscribeToMainProcessEvents();
electron_1.ipcRenderer.on(eventType_1.EVENT_TYPE.ACTION.SWITCH_ACCOUNT, function (event, accountIndex) {
    window.dispatchEvent(new CustomEvent(eventType_1.EVENT_TYPE.ACTION.SWITCH_ACCOUNT, { detail: { accountIndex: accountIndex } }));
});
window.addEventListener('DOMContentLoaded', addDragRegion);
window.addEventListener('focus', function () {
    var selectedWebview = getSelectedWebview();
    if (selectedWebview) {
        selectedWebview.focus();
    }
});
//# sourceMappingURL=preload.js.map