/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.ui.Graphics2DDelegate;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.text.AttributedCharacterIterator;
import org.jetbrains.annotations.NotNull;

public final class Grayer
extends Graphics2DDelegate {
    private final Color myBackground;
    private Color originalColor;

    public Grayer(Graphics2D g2d, Color background) {
        super(g2d);
        this.myBackground = background;
    }

    public void setColor(Color color) {
        this.originalColor = color;
        if (color != null && !this.myBackground.equals(color)) {
            color = new Color(UIUtil.getGrayFilter().filterRGB(0, 0, color.getRGB()));
        }
        super.setColor(color);
    }

    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        this.setTextColor();
        super.drawString(iterator, x, y);
    }

    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
        this.setTextColor();
        super.drawString(iterator, x, y);
    }

    public void drawString(String s, float x, float y) {
        this.setTextColor();
        super.drawString(s, x, y);
    }

    public void drawString(String str, int x, int y) {
        this.setTextColor();
        super.drawString(str, x, y);
    }

    public void drawChars(char[] data, int offset, int length, int x, int y) {
        this.setTextColor();
        super.drawChars(data, offset, length, x, y);
    }

    private void setTextColor() {
        if (this.originalColor != null && !this.myBackground.equals(this.originalColor)) {
            super.setColor(new Color(UIUtil.getTextGrayFilter().filterRGB(0, 0, this.originalColor.getRGB())));
        }
    }

    @NotNull
    public Graphics create() {
        Grayer grayer = new Grayer((Graphics2D)super.create(), this.myBackground);
        if (grayer == null) {
            Grayer.$$$reportNull$$$0(0);
        }
        return grayer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ui/Grayer", "create"));
    }
}

