/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.vcs.log.impl.VcsFileStatusInfo;
import git4idea.GitFormatException;
import git4idea.config.GitVersionSpecialty;
import git4idea.history.GitChangeType;
import git4idea.history.GitChangesParser;
import git4idea.history.GitLogRecord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitLogParser {
    private static final Logger LOG = Logger.getInstance(GitLogParser.class);
    static final String RECORD_START = "\u0001\u0001";
    static final String ITEMS_SEPARATOR = "\u0002\u0002";
    static final String RECORD_END = "\u0003\u0003";
    private static final int MAX_SEPARATOR_LENGTH = 10;
    private static final char[] CONTROL_CHARS = new char[]{'\u0001', '\u0002', '\u0003'};
    private static final int INPUT_ERROR_MESSAGE_HEAD_LIMIT = 1000000;
    private static final int INPUT_ERROR_MESSAGE_TAIL_LIMIT = 100;
    private static final AtomicInteger ERROR_COUNT = new AtomicInteger();
    private final boolean mySupportsRawBody;
    @NotNull
    private final String myPretty;
    @NotNull
    private final OptionsParser myOptionsParser;
    @NotNull
    private final PathsParser myPathsParser;
    private final String myRecordStart;
    private final String myRecordEnd;
    private final String myItemsSeparator;
    private boolean myIsInBody;

    private GitLogParser(boolean supportsRawBody, @NotNull NameStatus nameStatusOption, GitLogOption ... options) {
        if (nameStatusOption == null) {
            GitLogParser.$$$reportNull$$$0(0);
        }
        if (options == null) {
            GitLogParser.$$$reportNull$$$0(1);
        }
        this.myIsInBody = true;
        this.mySupportsRawBody = supportsRawBody;
        this.myRecordStart = RECORD_START + GitLogParser.generateRandomSequence();
        this.myRecordEnd = RECORD_END + GitLogParser.generateRandomSequence();
        this.myItemsSeparator = ITEMS_SEPARATOR + GitLogParser.generateRandomSequence();
        this.myPretty = "--pretty=format:" + this.makeFormatFromOptions(options);
        this.myOptionsParser = new OptionsParser(options);
        this.myPathsParser = new PathsParser(nameStatusOption);
    }

    public GitLogParser(@NotNull Project project, @NotNull NameStatus nameStatus, GitLogOption ... options) {
        if (project == null) {
            GitLogParser.$$$reportNull$$$0(2);
        }
        if (nameStatus == null) {
            GitLogParser.$$$reportNull$$$0(3);
        }
        if (options == null) {
            GitLogParser.$$$reportNull$$$0(4);
        }
        this(GitVersionSpecialty.STARTED_USING_RAW_BODY_IN_FORMAT.existsIn(project), nameStatus, options);
    }

    public GitLogParser(@NotNull Project project, GitLogOption ... options) {
        if (project == null) {
            GitLogParser.$$$reportNull$$$0(5);
        }
        if (options == null) {
            GitLogParser.$$$reportNull$$$0(6);
        }
        this(project, NameStatus.NONE, options);
    }

    @NotNull
    public List<GitLogRecord> parse(@NotNull CharSequence output) {
        if (output == null) {
            GitLogParser.$$$reportNull$$$0(7);
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        List lines = StringUtil.split((CharSequence)output, (CharSequence)"\n", (boolean)true, (boolean)false);
        for (CharSequence line : lines) {
            try {
                GitLogRecord record = this.parseLine(line);
                if (record == null) continue;
                result2.add(record);
            }
            catch (GitFormatException e) {
                this.clear();
                LOG.error((Throwable)e);
            }
        }
        GitLogRecord record = this.finish();
        if (record != null) {
            result2.add(record);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            GitLogParser.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @Nullable
    public GitLogRecord parseOneRecord(@NotNull CharSequence output) {
        if (output == null) {
            GitLogParser.$$$reportNull$$$0(9);
        }
        List<GitLogRecord> records = this.parse(output);
        this.clear();
        if (records.isEmpty()) {
            return null;
        }
        return (GitLogRecord)ContainerUtil.getFirstItem(records);
    }

    @Nullable
    public GitLogRecord parseLine(@NotNull CharSequence line) {
        if (line == null) {
            GitLogParser.$$$reportNull$$$0(10);
        }
        if (this.myPathsParser.expectsPaths()) {
            return this.parseLineWithPaths(line);
        }
        return this.parseLineWithoutPaths(line);
    }

    @Nullable
    private GitLogRecord parseLineWithPaths(@NotNull CharSequence line) {
        if (line == null) {
            GitLogParser.$$$reportNull$$$0(11);
        }
        if (this.myIsInBody) {
            this.myIsInBody = !this.myOptionsParser.parseLine(line);
        } else {
            if (CharArrayUtil.regionMatches((CharSequence)line, (int)0, (CharSequence)this.myRecordStart)) {
                GitLogRecord record = this.createRecord();
                this.myIsInBody = !this.myOptionsParser.parseLine(line);
                return record;
            }
            this.myPathsParser.parseLine(line);
        }
        return null;
    }

    @Nullable
    private GitLogRecord parseLineWithoutPaths(@NotNull CharSequence line) {
        if (line == null) {
            GitLogParser.$$$reportNull$$$0(12);
        }
        if (this.myOptionsParser.parseLine(line)) {
            return this.createRecord();
        }
        return null;
    }

    @Nullable
    public GitLogRecord finish() {
        if (this.myOptionsParser.isEmpty()) {
            return null;
        }
        return this.createRecord();
    }

    @NotNull
    private GitLogRecord createRecord() {
        Map<GitLogOption, String> options = this.myOptionsParser.getResult();
        this.myOptionsParser.clear();
        List<VcsFileStatusInfo> result2 = this.myPathsParser.getResult();
        this.myPathsParser.clear();
        this.myIsInBody = true;
        GitLogRecord gitLogRecord = new GitLogRecord(options, result2, this.mySupportsRawBody);
        if (gitLogRecord == null) {
            GitLogParser.$$$reportNull$$$0(13);
        }
        return gitLogRecord;
    }

    public void clear() {
        this.myOptionsParser.clear();
        this.myPathsParser.clear();
        this.myIsInBody = true;
    }

    @NotNull
    public String getPretty() {
        String string = this.myPretty;
        if (string == null) {
            GitLogParser.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    private String makeFormatFromOptions(@NotNull GitLogOption[] options) {
        if (options == null) {
            GitLogParser.$$$reportNull$$$0(15);
        }
        Function function = option -> "%" + ((GitLogOption)option).getPlaceholder();
        String string = GitLogParser.encodeForGit(this.myRecordStart) + StringUtil.join((Object[])options, (Function)function, (String)GitLogParser.encodeForGit(this.myItemsSeparator)) + GitLogParser.encodeForGit(this.myRecordEnd);
        if (string == null) {
            GitLogParser.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private static String encodeForGit(@NotNull String line) {
        if (line == null) {
            GitLogParser.$$$reportNull$$$0(17);
        }
        StringBuilder encoded = new StringBuilder();
        line.chars().forEachOrdered(c -> encoded.append("%x").append(String.format("%02x", c)));
        String string = encoded.toString();
        if (string == null) {
            GitLogParser.$$$reportNull$$$0(18);
        }
        return string;
    }

    @NotNull
    private static String generateRandomSequence() {
        int length = ERROR_COUNT.get() % (10 - RECORD_START.length());
        StringBuilder tail = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int randomIndex = ThreadLocalRandom.current().nextInt(0, CONTROL_CHARS.length);
            tail.append(CONTROL_CHARS[randomIndex]);
        }
        String string = tail.toString();
        if (string == null) {
            GitLogParser.$$$reportNull$$$0(19);
        }
        return string;
    }

    private static void throwGFE(@NotNull String message, @NotNull CharSequence line) {
        if (message == null) {
            GitLogParser.$$$reportNull$$$0(20);
        }
        if (line == null) {
            GitLogParser.$$$reportNull$$$0(21);
        }
        ERROR_COUNT.incrementAndGet();
        throw new GitFormatException(message + " [" + GitLogParser.getTruncatedEscapedOutput(line) + "]");
    }

    @NotNull
    private static String getTruncatedEscapedOutput(@NotNull CharSequence line) {
        if (line == null) {
            GitLogParser.$$$reportNull$$$0(22);
        }
        String formatString = "%s...(%d more characters)...%s";
        String lineString = line.length() > 1000100 + formatString.length() ? String.format(formatString, line.subSequence(0, 1000000), line.length() - 1000000 - 100, line.subSequence(line.length() - 100, line.length())) : line.toString();
        String string = StringUtil.escapeStringCharacters((String)lineString);
        if (string == null) {
            GitLogParser.$$$reportNull$$$0(23);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameStatusOption";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameStatus";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/history/GitLogParser";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/history/GitLogParser";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createRecord";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPretty";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "makeFormatFromOptions";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "encodeForGit";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "generateRandomSequence";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTruncatedEscapedOutput";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 23: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseOneRecord";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseLine";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseLineWithPaths";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parseLineWithoutPaths";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "makeFormatFromOptions";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "encodeForGit";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "throwGFE";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getTruncatedEscapedOutput";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PartialResult {
        @NotNull
        private List<String> myResult = ContainerUtil.newArrayList();
        @NotNull
        private final StringBuilder myCurrentItem = new StringBuilder();

        private PartialResult() {
        }

        public void append(char c) {
            this.myCurrentItem.append(c);
        }

        public void finishItem() {
            this.myResult.add(this.myCurrentItem.toString());
            this.myCurrentItem.setLength(0);
        }

        @NotNull
        public List<String> getResult() {
            List<String> list = this.myResult;
            if (list == null) {
                PartialResult.$$$reportNull$$$0(0);
            }
            return list;
        }

        public void clear() {
            this.myCurrentItem.setLength(0);
            this.myResult = ContainerUtil.newArrayList();
        }

        public boolean isEmpty() {
            return this.myResult.isEmpty() && this.myCurrentItem.length() == 0;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitLogParser$PartialResult", "getResult"));
        }
    }

    private class PathsParser {
        @NotNull
        private final NameStatus myNameStatusOption;
        @NotNull
        private List<VcsFileStatusInfo> myStatuses;

        PathsParser(NameStatus nameStatusOption) {
            if (nameStatusOption == null) {
                PathsParser.$$$reportNull$$$0(0);
            }
            this.myStatuses = ContainerUtil.newArrayList();
            this.myNameStatusOption = nameStatusOption;
        }

        public void parseLine(@NotNull CharSequence line) {
            if (line == null) {
                PathsParser.$$$reportNull$$$0(1);
            }
            if (line.length() == 0) {
                return;
            }
            List<String> match = this.parsePathsLine(line);
            if (!match.isEmpty()) {
                if (this.myNameStatusOption != NameStatus.STATUS) {
                    GitLogParser.throwGFE("Status list not expected", line);
                }
                if (match.size() == 2) {
                    this.myStatuses.add(new VcsFileStatusInfo(GitChangesParser.getChangeType(GitChangeType.fromString(match.get(0))), match.get(1), null));
                } else if (match.size() >= 3) {
                    this.myStatuses.add(new VcsFileStatusInfo(GitChangesParser.getChangeType(GitChangeType.fromString(match.get(0))), match.get(1), match.get(2)));
                } else {
                    LOG.error("Could not parse status line [" + line + "] for record " + GitLogParser.this.myOptionsParser.myResult.getResult());
                }
            }
        }

        @NotNull
        private List<String> parsePathsLine(@NotNull CharSequence line) {
            if (line == null) {
                PathsParser.$$$reportNull$$$0(2);
            }
            PartialResult result2 = new PartialResult();
            for (int offset = 0; offset < line.length() && !this.atLineEnd(line, offset); ++offset) {
                char charAt = line.charAt(offset);
                if (charAt == '\t') {
                    result2.finishItem();
                    continue;
                }
                result2.append(charAt);
            }
            result2.finishItem();
            List<String> list = result2.getResult();
            if (list == null) {
                PathsParser.$$$reportNull$$$0(3);
            }
            return list;
        }

        private boolean atLineEnd(@NotNull CharSequence line, int offset) {
            if (line == null) {
                PathsParser.$$$reportNull$$$0(4);
            }
            while (offset < line.length() && line.charAt(offset) == '\t') {
                ++offset;
            }
            return offset == line.length() || line.charAt(offset) == '\n' || line.charAt(offset) == '\r';
        }

        @NotNull
        public List<VcsFileStatusInfo> getResult() {
            List<VcsFileStatusInfo> list = this.myStatuses;
            if (list == null) {
                PathsParser.$$$reportNull$$$0(5);
            }
            return list;
        }

        public void clear() {
            this.myStatuses = ContainerUtil.newArrayList();
        }

        public boolean expectsPaths() {
            return this.myNameStatusOption == NameStatus.STATUS;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameStatusOption";
                    break;
                }
                case 1: 
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/history/GitLogParser$PathsParser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/history/GitLogParser$PathsParser";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "parsePathsLine";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "parseLine";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "parsePathsLine";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "atLineEnd";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class OptionsParser {
        @NotNull
        private final GitLogOption[] myOptions;
        @NotNull
        private final PartialResult myResult;

        OptionsParser(GitLogOption[] options) {
            if (options == null) {
                OptionsParser.$$$reportNull$$$0(0);
            }
            this.myResult = new PartialResult();
            this.myOptions = options;
        }

        public boolean parseLine(@NotNull CharSequence line) {
            if (line == null) {
                OptionsParser.$$$reportNull$$$0(1);
            }
            int offset = 0;
            if (this.myResult.isEmpty()) {
                if (!CharArrayUtil.regionMatches((CharSequence)line, (int)offset, (CharSequence)GitLogParser.this.myRecordStart)) {
                    return false;
                }
                offset += GitLogParser.this.myRecordStart.length();
            }
            while (offset < line.length()) {
                if (this.atRecordEnd(line, offset)) {
                    this.myResult.finishItem();
                    if (this.myResult.getResult().size() != this.myOptions.length) {
                        GitLogParser.throwGFE("Parsed incorrect options " + this.myResult.getResult() + " for " + Arrays.toString((Object[])this.myOptions), line);
                    }
                    return true;
                }
                if (CharArrayUtil.regionMatches((CharSequence)line, (int)offset, (CharSequence)GitLogParser.this.myItemsSeparator)) {
                    this.myResult.finishItem();
                    offset += GitLogParser.this.myItemsSeparator.length();
                    continue;
                }
                char c = line.charAt(offset);
                this.myResult.append(c);
                ++offset;
            }
            this.myResult.append('\n');
            return false;
        }

        private boolean atRecordEnd(@NotNull CharSequence line, int offset) {
            if (line == null) {
                OptionsParser.$$$reportNull$$$0(2);
            }
            return offset == line.length() - GitLogParser.this.myRecordEnd.length() && CharArrayUtil.regionMatches((CharSequence)line, (int)offset, (CharSequence)GitLogParser.this.myRecordEnd);
        }

        @NotNull
        public Map<GitLogOption, String> getResult() {
            Map<GitLogOption, String> map2 = this.createOptions(this.myResult.getResult());
            if (map2 == null) {
                OptionsParser.$$$reportNull$$$0(3);
            }
            return map2;
        }

        @NotNull
        private Map<GitLogOption, String> createOptions(@NotNull List<String> options) {
            if (options == null) {
                OptionsParser.$$$reportNull$$$0(4);
            }
            HashMap<GitLogOption, String> optionsMap = new HashMap<GitLogOption, String>(options.size());
            for (int index = 0; index < options.size(); ++index) {
                optionsMap.put(this.myOptions[index], options.get(index));
            }
            HashMap<GitLogOption, String> hashMap = optionsMap;
            if (hashMap == null) {
                OptionsParser.$$$reportNull$$$0(5);
            }
            return hashMap;
        }

        public void clear() {
            this.myResult.clear();
        }

        public boolean isEmpty() {
            return this.myResult.isEmpty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "options";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 3: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/history/GitLogParser$OptionsParser";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/history/GitLogParser$OptionsParser";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResult";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createOptions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "parseLine";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "atRecordEnd";
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createOptions";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static enum GitLogOption {
        HASH("H"),
        TREE("T"),
        COMMIT_TIME("ct"),
        AUTHOR_NAME("an"),
        AUTHOR_TIME("at"),
        AUTHOR_EMAIL("ae"),
        COMMITTER_NAME("cn"),
        COMMITTER_EMAIL("ce"),
        SUBJECT("s"),
        BODY("b"),
        PARENTS("P"),
        REF_NAMES("d"),
        SHORT_REF_LOG_SELECTOR("gd"),
        RAW_BODY("B");

        private final String myPlaceholder;

        private GitLogOption(String placeholder) {
            this.myPlaceholder = placeholder;
        }

        private String getPlaceholder() {
            return this.myPlaceholder;
        }
    }

    static enum NameStatus {
        NONE,
        STATUS;

    }
}

