/*
 * Decompiled with CFR 0.152.
 */
package processing.opengl;

import java.nio.IntBuffer;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.opengl.PGL;
import processing.opengl.PGraphicsOpenGL;
import processing.opengl.Texture;

public class FrameBuffer
implements PConstants {
    protected PGraphicsOpenGL pg;
    protected PGL pgl;
    protected int context;
    public int glFbo;
    public int glDepth;
    public int glStencil;
    public int glDepthStencil;
    public int glMultisample;
    public int width;
    public int height;
    private PGraphicsOpenGL.GLResourceFrameBuffer glres;
    protected int depthBits;
    protected int stencilBits;
    protected boolean packedDepthStencil;
    protected boolean multisample;
    protected int nsamples;
    protected int numColorBuffers;
    protected Texture[] colorBufferTex;
    protected boolean screenFb;
    protected boolean noDepth;
    protected IntBuffer pixelBuffer;

    FrameBuffer(PGraphicsOpenGL pg) {
        this.pg = pg;
        this.pgl = pg.pgl;
        this.context = this.pgl.createEmptyContext();
    }

    FrameBuffer(PGraphicsOpenGL pg, int w, int h, int samples, int colorBuffers, int depthBits, int stencilBits, boolean packedDepthStencil, boolean screen) {
        this(pg);
        this.glFbo = 0;
        this.glDepth = 0;
        this.glStencil = 0;
        this.glDepthStencil = 0;
        this.glMultisample = 0;
        if (screen) {
            colorBuffers = 0;
            samples = 0;
            stencilBits = 0;
            depthBits = 0;
        }
        this.width = w;
        this.height = h;
        if (1 < samples) {
            this.multisample = true;
            this.nsamples = samples;
        } else {
            this.multisample = false;
            this.nsamples = 1;
        }
        this.numColorBuffers = colorBuffers;
        this.colorBufferTex = new Texture[this.numColorBuffers];
        int i = 0;
        while (i < this.numColorBuffers) {
            this.colorBufferTex[i] = null;
            ++i;
        }
        if (depthBits < 1 && stencilBits < 1) {
            this.depthBits = 0;
            this.stencilBits = 0;
            this.packedDepthStencil = false;
        } else if (packedDepthStencil) {
            this.depthBits = 24;
            this.stencilBits = 8;
            this.packedDepthStencil = true;
        } else {
            this.depthBits = depthBits;
            this.stencilBits = stencilBits;
            this.packedDepthStencil = false;
        }
        this.screenFb = screen;
        this.allocate();
        this.noDepth = false;
        this.pixelBuffer = null;
    }

    FrameBuffer(PGraphicsOpenGL pg, int w, int h) {
        this(pg, w, h, 1, 1, 0, 0, false, false);
    }

    FrameBuffer(PGraphicsOpenGL pg, int w, int h, boolean screen) {
        this(pg, w, h, 1, 1, 0, 0, false, screen);
    }

    public void clear() {
        this.pg.pushFramebuffer();
        this.pg.setFramebuffer(this);
        this.pgl.clearDepth(1.0f);
        this.pgl.clearStencil(0);
        this.pgl.clearColor(0.0f, 0.0f, 0.0f, 0.0f);
        this.pgl.clear(PGL.DEPTH_BUFFER_BIT | PGL.STENCIL_BUFFER_BIT | PGL.COLOR_BUFFER_BIT);
        this.pg.popFramebuffer();
    }

    public void copyColor(FrameBuffer dest) {
        this.copy(dest, PGL.COLOR_BUFFER_BIT);
    }

    public void copyDepth(FrameBuffer dest) {
        this.copy(dest, PGL.DEPTH_BUFFER_BIT);
    }

    public void copyStencil(FrameBuffer dest) {
        this.copy(dest, PGL.STENCIL_BUFFER_BIT);
    }

    public void copy(FrameBuffer dest, int mask) {
        this.pgl.bindFramebufferImpl(PGL.READ_FRAMEBUFFER, this.glFbo);
        this.pgl.bindFramebufferImpl(PGL.DRAW_FRAMEBUFFER, dest.glFbo);
        this.pgl.blitFramebuffer(0, 0, this.width, this.height, 0, 0, dest.width, dest.height, mask, PGL.NEAREST);
        this.pgl.bindFramebufferImpl(PGL.READ_FRAMEBUFFER, this.pg.getCurrentFB().glFbo);
        this.pgl.bindFramebufferImpl(PGL.DRAW_FRAMEBUFFER, this.pg.getCurrentFB().glFbo);
    }

    public void bind() {
        this.pgl.bindFramebufferImpl(PGL.FRAMEBUFFER, this.glFbo);
    }

    public void disableDepthTest() {
        this.noDepth = true;
    }

    public void finish() {
        if (this.noDepth) {
            if (this.pg.getHint(-2)) {
                this.pgl.enable(PGL.DEPTH_TEST);
            } else {
                this.pgl.disable(PGL.DEPTH_TEST);
            }
        }
    }

    public void readPixels() {
        if (this.pixelBuffer == null) {
            this.createPixelBuffer();
        }
        this.pixelBuffer.rewind();
        this.pgl.readPixels(0, 0, this.width, this.height, PGL.RGBA, PGL.UNSIGNED_BYTE, this.pixelBuffer);
    }

    public void getPixels(int[] pixels) {
        if (this.pixelBuffer != null) {
            this.pixelBuffer.get(pixels, 0, pixels.length);
            this.pixelBuffer.rewind();
        }
    }

    public IntBuffer getPixelBuffer() {
        return this.pixelBuffer;
    }

    public boolean hasDepthBuffer() {
        return this.depthBits > 0;
    }

    public boolean hasStencilBuffer() {
        return this.stencilBits > 0;
    }

    public void setFBO(int id) {
        if (this.screenFb) {
            this.glFbo = id;
        }
    }

    public void setColorBuffer(Texture tex) {
        this.setColorBuffers(new Texture[]{tex}, 1);
    }

    public void setColorBuffers(Texture[] textures) {
        this.setColorBuffers(textures, textures.length);
    }

    public void setColorBuffers(Texture[] textures, int n) {
        if (this.screenFb) {
            return;
        }
        if (this.numColorBuffers != PApplet.min(n, textures.length)) {
            throw new RuntimeException("Wrong number of textures to set the color buffers.");
        }
        int i = 0;
        while (i < this.numColorBuffers) {
            this.colorBufferTex[i] = textures[i];
            ++i;
        }
        this.pg.pushFramebuffer();
        this.pg.setFramebuffer(this);
        i = 0;
        while (i < this.numColorBuffers) {
            this.pgl.framebufferTexture2D(PGL.FRAMEBUFFER, PGL.COLOR_ATTACHMENT0 + i, PGL.TEXTURE_2D, 0, 0);
            ++i;
        }
        i = 0;
        while (i < this.numColorBuffers) {
            this.pgl.framebufferTexture2D(PGL.FRAMEBUFFER, PGL.COLOR_ATTACHMENT0 + i, this.colorBufferTex[i].glTarget, this.colorBufferTex[i].glName, 0);
            ++i;
        }
        this.pgl.validateFramebuffer();
        this.pg.popFramebuffer();
    }

    public void swapColorBuffers() {
        int i = 0;
        while (i < this.numColorBuffers - 1) {
            int i1 = i + 1;
            Texture tmp = this.colorBufferTex[i];
            this.colorBufferTex[i] = this.colorBufferTex[i1];
            this.colorBufferTex[i1] = tmp;
            ++i;
        }
        this.pg.pushFramebuffer();
        this.pg.setFramebuffer(this);
        i = 0;
        while (i < this.numColorBuffers) {
            this.pgl.framebufferTexture2D(PGL.FRAMEBUFFER, PGL.COLOR_ATTACHMENT0 + i, this.colorBufferTex[i].glTarget, this.colorBufferTex[i].glName, 0);
            ++i;
        }
        this.pgl.validateFramebuffer();
        this.pg.popFramebuffer();
    }

    public int getDefaultReadBuffer() {
        if (this.screenFb) {
            return this.pgl.getDefaultReadBuffer();
        }
        return PGL.COLOR_ATTACHMENT0;
    }

    public int getDefaultDrawBuffer() {
        if (this.screenFb) {
            return this.pgl.getDefaultDrawBuffer();
        }
        return PGL.COLOR_ATTACHMENT0;
    }

    protected void allocate() {
        this.dispose();
        this.context = this.pgl.getCurrentContext();
        this.glres = new PGraphicsOpenGL.GLResourceFrameBuffer(this);
        if (this.screenFb) {
            this.glFbo = 0;
        } else {
            if (this.multisample) {
                this.initColorBufferMultisample();
            }
            if (this.packedDepthStencil) {
                this.initPackedDepthStencilBuffer();
            } else {
                if (this.depthBits > 0) {
                    this.initDepthBuffer();
                }
                if (this.stencilBits > 0) {
                    this.initStencilBuffer();
                }
            }
        }
    }

    protected void dispose() {
        if (this.screenFb) {
            return;
        }
        if (this.glres != null) {
            this.glres.dispose();
            this.glFbo = 0;
            this.glDepth = 0;
            this.glStencil = 0;
            this.glMultisample = 0;
            this.glDepthStencil = 0;
            this.glres = null;
        }
    }

    protected boolean contextIsOutdated() {
        boolean outdated;
        if (this.screenFb) {
            return false;
        }
        boolean bl = outdated = !this.pgl.contextIsCurrent(this.context);
        if (outdated) {
            this.dispose();
            int i = 0;
            while (i < this.numColorBuffers) {
                this.colorBufferTex[i] = null;
                ++i;
            }
        }
        return outdated;
    }

    protected void initColorBufferMultisample() {
        if (this.screenFb) {
            return;
        }
        this.pg.pushFramebuffer();
        this.pg.setFramebuffer(this);
        this.pgl.bindRenderbuffer(PGL.RENDERBUFFER, this.glMultisample);
        this.pgl.renderbufferStorageMultisample(PGL.RENDERBUFFER, this.nsamples, PGL.RGBA8, this.width, this.height);
        this.pgl.framebufferRenderbuffer(PGL.FRAMEBUFFER, PGL.COLOR_ATTACHMENT0, PGL.RENDERBUFFER, this.glMultisample);
        this.pg.popFramebuffer();
    }

    protected void initPackedDepthStencilBuffer() {
        if (this.screenFb) {
            return;
        }
        if (this.width == 0 || this.height == 0) {
            throw new RuntimeException("PFramebuffer: size undefined.");
        }
        this.pg.pushFramebuffer();
        this.pg.setFramebuffer(this);
        this.pgl.bindRenderbuffer(PGL.RENDERBUFFER, this.glDepthStencil);
        if (this.multisample) {
            this.pgl.renderbufferStorageMultisample(PGL.RENDERBUFFER, this.nsamples, PGL.DEPTH24_STENCIL8, this.width, this.height);
        } else {
            this.pgl.renderbufferStorage(PGL.RENDERBUFFER, PGL.DEPTH24_STENCIL8, this.width, this.height);
        }
        this.pgl.framebufferRenderbuffer(PGL.FRAMEBUFFER, PGL.DEPTH_ATTACHMENT, PGL.RENDERBUFFER, this.glDepthStencil);
        this.pgl.framebufferRenderbuffer(PGL.FRAMEBUFFER, PGL.STENCIL_ATTACHMENT, PGL.RENDERBUFFER, this.glDepthStencil);
        this.pg.popFramebuffer();
    }

    protected void initDepthBuffer() {
        if (this.screenFb) {
            return;
        }
        if (this.width == 0 || this.height == 0) {
            throw new RuntimeException("PFramebuffer: size undefined.");
        }
        this.pg.pushFramebuffer();
        this.pg.setFramebuffer(this);
        this.pgl.bindRenderbuffer(PGL.RENDERBUFFER, this.glDepth);
        int glConst = PGL.DEPTH_COMPONENT16;
        if (this.depthBits == 16) {
            glConst = PGL.DEPTH_COMPONENT16;
        } else if (this.depthBits == 24) {
            glConst = PGL.DEPTH_COMPONENT24;
        } else if (this.depthBits == 32) {
            glConst = PGL.DEPTH_COMPONENT32;
        }
        if (this.multisample) {
            this.pgl.renderbufferStorageMultisample(PGL.RENDERBUFFER, this.nsamples, glConst, this.width, this.height);
        } else {
            this.pgl.renderbufferStorage(PGL.RENDERBUFFER, glConst, this.width, this.height);
        }
        this.pgl.framebufferRenderbuffer(PGL.FRAMEBUFFER, PGL.DEPTH_ATTACHMENT, PGL.RENDERBUFFER, this.glDepth);
        this.pg.popFramebuffer();
    }

    protected void initStencilBuffer() {
        if (this.screenFb) {
            return;
        }
        if (this.width == 0 || this.height == 0) {
            throw new RuntimeException("PFramebuffer: size undefined.");
        }
        this.pg.pushFramebuffer();
        this.pg.setFramebuffer(this);
        this.pgl.bindRenderbuffer(PGL.RENDERBUFFER, this.glStencil);
        int glConst = PGL.STENCIL_INDEX1;
        if (this.stencilBits == 1) {
            glConst = PGL.STENCIL_INDEX1;
        } else if (this.stencilBits == 4) {
            glConst = PGL.STENCIL_INDEX4;
        } else if (this.stencilBits == 8) {
            glConst = PGL.STENCIL_INDEX8;
        }
        if (this.multisample) {
            this.pgl.renderbufferStorageMultisample(PGL.RENDERBUFFER, this.nsamples, glConst, this.width, this.height);
        } else {
            this.pgl.renderbufferStorage(PGL.RENDERBUFFER, glConst, this.width, this.height);
        }
        this.pgl.framebufferRenderbuffer(PGL.FRAMEBUFFER, PGL.STENCIL_ATTACHMENT, PGL.RENDERBUFFER, this.glStencil);
        this.pg.popFramebuffer();
    }

    protected void createPixelBuffer() {
        this.pixelBuffer = IntBuffer.allocate(this.width * this.height);
        this.pixelBuffer.rewind();
    }
}

