/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.font;

import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import org.apache.fontbox.FontBoxFont;
import org.apache.fontbox.util.BoundingBox;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.cos.COSStream;
import org.sejda.sambox.pdmodel.PDResources;
import org.sejda.sambox.pdmodel.common.PDRectangle;
import org.sejda.sambox.pdmodel.font.PDFontDescriptor;
import org.sejda.sambox.pdmodel.font.PDSimpleFont;
import org.sejda.sambox.pdmodel.font.PDType3CharProc;
import org.sejda.sambox.pdmodel.font.encoding.DictionaryEncoding;
import org.sejda.sambox.pdmodel.font.encoding.Encoding;
import org.sejda.sambox.pdmodel.font.encoding.GlyphList;
import org.sejda.sambox.util.Matrix;
import org.sejda.sambox.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PDType3Font
extends PDSimpleFont {
    private static final Logger LOG = LoggerFactory.getLogger(PDType3Font.class);
    private PDResources resources;
    private COSDictionary charProcs;
    private Matrix fontMatrix;
    private BoundingBox fontBBox;

    public PDType3Font(COSDictionary fontDictionary) throws IOException {
        super(fontDictionary);
        this.readEncoding();
    }

    @Override
    public String getName() {
        return this.dict.getNameAsString(COSName.NAME);
    }

    @Override
    protected final void readEncoding() {
        COSBase encodingBase = this.dict.getDictionaryObject(COSName.ENCODING);
        if (encodingBase instanceof COSName) {
            COSName encodingName = (COSName)encodingBase;
            this.encoding = Encoding.getInstance(encodingName);
            if (this.encoding == null) {
                LOG.warn("Unknown encoding: {}", (Object)encodingName.getName());
            }
        } else if (encodingBase instanceof COSDictionary) {
            this.encoding = new DictionaryEncoding((COSDictionary)encodingBase);
        }
        this.glyphList = GlyphList.getAdobeGlyphList();
    }

    @Override
    protected Encoding readEncodingFromFont() {
        throw new UnsupportedOperationException("not supported for Type 3 fonts");
    }

    @Override
    protected Boolean isFontSymbolic() {
        return false;
    }

    @Override
    public GeneralPath getPath(String name) {
        throw new UnsupportedOperationException("not supported for Type 3 fonts");
    }

    @Override
    public boolean hasGlyph(String name) {
        return Objects.nonNull(this.getCharProcs().getDictionaryObject(COSName.getPDFName(name), COSStream.class));
    }

    @Override
    public FontBoxFont getFontBoxFont() {
        throw new UnsupportedOperationException("not supported for Type 3 fonts");
    }

    @Override
    public Vector getDisplacement(int code) throws IOException {
        return this.getFontMatrix().transform(new Vector(this.getWidth(code), 0.0f));
    }

    @Override
    public float getWidth(int code) throws IOException {
        int firstChar = this.dict.getInt(COSName.FIRST_CHAR, -1);
        int lastChar = this.dict.getInt(COSName.LAST_CHAR, -1);
        if (!this.getWidths().isEmpty() && code >= firstChar && code <= lastChar) {
            return Optional.ofNullable(this.getWidths().get(code - firstChar)).orElse(Float.valueOf(0.0f)).floatValue();
        }
        PDFontDescriptor fd = this.getFontDescriptor();
        if (Objects.nonNull(fd)) {
            return fd.getMissingWidth();
        }
        return this.getWidthFromFont(code);
    }

    @Override
    public float getWidthFromFont(int code) throws IOException {
        PDType3CharProc charProc = this.getCharProc(code);
        if (Objects.nonNull(charProc)) {
            return charProc.getWidth();
        }
        return 0.0f;
    }

    @Override
    public boolean isEmbedded() {
        return true;
    }

    @Override
    public float getHeight(int code) {
        PDFontDescriptor desc = this.getFontDescriptor();
        if (desc != null) {
            PDRectangle bbox = desc.getFontBoundingBox();
            float retval = 0.0f;
            if (bbox != null) {
                retval = bbox.getHeight() / 2.0f;
            }
            if (retval == 0.0f) {
                retval = desc.getCapHeight();
            }
            if (retval == 0.0f) {
                retval = desc.getAscent();
            }
            if (retval == 0.0f && (retval = desc.getXHeight()) > 0.0f) {
                retval -= desc.getDescent();
            }
            return retval;
        }
        return 0.0f;
    }

    @Override
    protected byte[] encode(int unicode) {
        throw new UnsupportedOperationException("Not implemented: Type3");
    }

    @Override
    public int readCode(InputStream in) throws IOException {
        return in.read();
    }

    @Override
    public Matrix getFontMatrix() {
        if (this.fontMatrix == null) {
            COSArray array = this.dict.getDictionaryObject(COSName.FONT_MATRIX, COSArray.class);
            if (Objects.nonNull(array)) {
                this.fontMatrix = new Matrix(array);
            } else {
                return super.getFontMatrix();
            }
        }
        return this.fontMatrix;
    }

    @Override
    public boolean isDamaged() {
        return false;
    }

    public PDResources getResources() {
        COSDictionary resourcesDict;
        if (this.resources == null && (resourcesDict = this.dict.getDictionaryObject(COSName.RESOURCES, COSDictionary.class)) != null) {
            this.resources = new PDResources(resourcesDict);
        }
        return this.resources;
    }

    public PDRectangle getFontBBox() {
        return Optional.ofNullable(this.dict.getDictionaryObject(COSName.FONT_BBOX, COSArray.class)).map(PDRectangle::new).orElse(null);
    }

    @Override
    public BoundingBox getBoundingBox() {
        if (this.fontBBox == null) {
            this.fontBBox = this.generateBoundingBox();
        }
        return this.fontBBox;
    }

    private BoundingBox generateBoundingBox() {
        PDRectangle rect = this.getFontBBox();
        if (rect.getLowerLeftX() == 0.0f && rect.getLowerLeftY() == 0.0f && rect.getUpperRightX() == 0.0f && rect.getUpperRightY() == 0.0f) {
            COSDictionary cp = this.getCharProcs();
            for (COSName name : cp.keySet()) {
                PDType3CharProc charProc;
                PDRectangle glyphBBox;
                COSBase base = cp.getDictionaryObject(name);
                if (!(base instanceof COSStream) || !Objects.nonNull(glyphBBox = (charProc = new PDType3CharProc(this, (COSStream)base)).getGlyphBBox())) continue;
                rect.setLowerLeftX(Math.min(rect.getLowerLeftX(), glyphBBox.getLowerLeftX()));
                rect.setLowerLeftY(Math.min(rect.getLowerLeftY(), glyphBBox.getLowerLeftY()));
                rect.setUpperRightX(Math.max(rect.getUpperRightX(), glyphBBox.getUpperRightX()));
                rect.setUpperRightY(Math.max(rect.getUpperRightY(), glyphBBox.getUpperRightY()));
            }
        }
        return new BoundingBox(rect.getLowerLeftX(), rect.getLowerLeftY(), rect.getUpperRightX(), rect.getUpperRightY());
    }

    public COSDictionary getCharProcs() {
        if (this.charProcs == null) {
            this.charProcs = this.dict.getDictionaryObject(COSName.CHAR_PROCS, COSDictionary.class);
        }
        return this.charProcs;
    }

    public PDType3CharProc getCharProc(int code) {
        String name = this.getEncoding().getName(code);
        return Optional.ofNullable(this.getCharProcs().getDictionaryObject(COSName.getPDFName(name), COSStream.class)).map(s -> new PDType3CharProc(this, (COSStream)s)).orElse(null);
    }
}

