/*
 * Decompiled with CFR 0.152.
 */
package org.pdfsam.extract;

import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import org.apache.commons.lang3.StringUtils;
import org.pdfsam.extract.ExtractParametersBuilder;
import org.pdfsam.i18n.DefaultI18nContext;
import org.pdfsam.support.params.ConversionUtils;
import org.pdfsam.support.params.TaskParametersBuildStep;
import org.pdfsam.ui.ResettableView;
import org.pdfsam.ui.commons.ValidableTextField;
import org.pdfsam.ui.help.HelpUtils;
import org.pdfsam.ui.support.FXValidationSupport;
import org.pdfsam.ui.support.Style;
import org.pdfsam.ui.workspace.RestorableView;
import org.sejda.conversion.exception.ConversionException;

class ExtractOptionsPane
extends HBox
implements TaskParametersBuildStep<ExtractParametersBuilder>,
RestorableView,
ResettableView {
    private final ValidableTextField field = new ValidableTextField();

    ExtractOptionsPane() {
        this.field.setOnEnterValidation(true);
        this.field.setEnableInvalidStyle(true);
        this.field.setPromptText(DefaultI18nContext.getInstance().i18n("Pages to extract (ex: 2 or 5-23 or 2,5-7,12-)"));
        this.field.setValidator(v -> {
            try {
                return !ConversionUtils.toPageRangeSet((String)this.field.getText()).isEmpty();
            }
            catch (ConversionException e) {
                return false;
            }
        });
        this.field.setErrorMessage(DefaultI18nContext.getInstance().i18n("Invalid page ranges"));
        this.field.setId("extractRanges");
        this.field.setPrefWidth(350.0);
        this.getStyleClass().addAll((Object[])Style.CONTAINER.css());
        this.getStyleClass().addAll((Object[])Style.HCONTAINER.css());
        this.getChildren().addAll((Object[])new Node[]{new Label(DefaultI18nContext.getInstance().i18n("Extract pages:")), this.field, HelpUtils.helpIcon((String)"Comma separated page numbers or ranges to extract (ex: 2 or 5-23 or 2,5-7,12-)")});
    }

    public void apply(ExtractParametersBuilder builder, Consumer<String> onError) {
        this.field.validate();
        if (this.field.getValidationState() == FXValidationSupport.ValidationState.VALID) {
            try {
                builder.ranges(ConversionUtils.toPageRangeSet((String)this.field.getText()));
            }
            catch (ConversionException e) {
                onError.accept(e.getMessage());
            }
        } else {
            onError.accept(DefaultI18nContext.getInstance().i18n("Invalid page ranges"));
        }
    }

    public void saveStateTo(Map<String, String> data) {
        data.put("pages", StringUtils.defaultString((String)this.field.getText()));
    }

    public void restoreStateFrom(Map<String, String> data) {
        this.field.setText(Optional.ofNullable(data.get("pages")).orElse(""));
    }

    public void resetView() {
        this.field.setText("");
    }
}

