/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class AutoResizingPanel
extends JPanel {
    private Dimension requestedSize;

    public AutoResizingPanel() {
    }

    public AutoResizingPanel(LayoutManager layout) {
        super(layout);
    }

    public AutoResizingPanel(boolean isDoubleBuffered) {
        super(isDoubleBuffered);
    }

    public AutoResizingPanel(LayoutManager layout, boolean isDoubleBuffered) {
        super(layout, isDoubleBuffered);
    }

    public void enlargeHorizontallyAsNecessary() {
        int currWidth = this.getWidth();
        int currHeight = this.getHeight();
        Dimension prefSize = this.getPreferredSize();
        this.enlargeAsNecessary(currWidth, currHeight, Math.max(currWidth, prefSize.width), currHeight);
    }

    public void enlargeVerticallyAsNecessary() {
        int currWidth = this.getWidth();
        int currHeight = this.getHeight();
        Dimension prefSize = this.getPreferredSize();
        this.enlargeAsNecessary(currWidth, currHeight, currWidth, Math.max(currHeight, prefSize.height));
    }

    public void enlargeAsNecessary() {
        int currWidth = this.getWidth();
        int currHeight = this.getHeight();
        Dimension prefSize = this.getPreferredSize();
        this.enlargeAsNecessary(currWidth, currHeight, Math.max(currWidth, prefSize.width), Math.max(currHeight, prefSize.height));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enlargeAsNecessary(int currentWidth, int currentHeight, int requestedWidth, int requestedHeight) {
        if (currentWidth >= requestedWidth && currentHeight >= requestedHeight) {
            return;
        }
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window == null) {
            return;
        }
        try {
            this.requestedSize = new Dimension(requestedWidth, requestedHeight);
            window.pack();
        }
        finally {
            this.requestedSize = null;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.requestedSize != null ? this.requestedSize : super.getPreferredSize();
    }
}

