/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.graph;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.netbeans.modules.java.graph.GraphNodeImplementation;
import org.netbeans.modules.maven.graph.Bundle;

public class MavenDependencyNode
implements GraphNodeImplementation {
    static final Color PROVIDED = new Color(191, 255, 255);
    static final Color COMPILE = new Color(191, 191, 255);
    static final Color RUNTIME = new Color(191, 255, 191);
    static final Color TEST = new Color(202, 151, 151);
    private final DependencyNode dependencyNode;
    private DefaultArtifactVersion version;
    private List<String> scopes;
    private MavenDependencyNode parent;
    private final HashMap<DependencyNode, MavenDependencyNode> children = new HashMap();

    public MavenDependencyNode(DependencyNode dependencyNode) {
        this(null, dependencyNode);
    }

    private MavenDependencyNode(MavenDependencyNode parent, DependencyNode dependencyNode) {
        this.dependencyNode = dependencyNode;
        this.parent = parent;
    }

    public Artifact getArtifact() {
        return this.dependencyNode.getArtifact();
    }

    private String getScope() {
        return this.dependencyNode.getArtifact().getScope();
    }

    public Color getScopeColor() {
        String scope = this.getScope();
        if (this.scopes == null || !this.scopes.contains(scope)) {
            return null;
        }
        if ("compile".equals(scope)) {
            return COMPILE;
        }
        if ("provided".equals(scope)) {
            return PROVIDED;
        }
        if ("runtime".equals(scope)) {
            return RUNTIME;
        }
        if ("test".equals(scope)) {
            return TEST;
        }
        return Color.BLACK;
    }

    void hightlightScopes(List<String> scopes) {
        this.scopes = scopes;
    }

    public String getQualifiedName() {
        return this.dependencyNode.getArtifact().getId();
    }

    public String getName() {
        return this.dependencyNode.getArtifact().getArtifactId();
    }

    public String getVersion() {
        return this.dependencyNode.getArtifact().getVersion();
    }

    int compareVersions(MavenDependencyNode dependencyNode2) {
        if (this.version == null) {
            this.version = new DefaultArtifactVersion(this.getVersion());
        }
        return this.version.compareTo((ArtifactVersion)new DefaultArtifactVersion(dependencyNode2.getVersion()));
    }

    public String getTooltipText() {
        String scope = this.getScope() != null ? this.getScope() : "";
        return Bundle.TIP_Artifact(this.dependencyNode.getArtifact().getGroupId(), this.dependencyNode.getArtifact().getArtifactId(), this.dependencyNode.getArtifact().getVersion(), scope, this.dependencyNode.getArtifact().getType());
    }

    public MavenDependencyNode getParent() {
        DependencyNode p = this.dependencyNode.getParent();
        if (this.parent == null) {
            this.parent = p != null ? new MavenDependencyNode(this.dependencyNode.getParent()) : null;
        }
        return this.parent;
    }

    public int getState() {
        return this.dependencyNode.getState();
    }

    public String getDependencyConflictId() {
        return this.dependencyNode.getArtifact().getDependencyConflictId();
    }

    public String getRelatedDependencyConflictId() {
        return this.dependencyNode.getRelatedArtifact().getDependencyConflictId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MavenDependencyNode> getChildren() {
        HashMap<DependencyNode, MavenDependencyNode> hashMap = this.children;
        synchronized (hashMap) {
            ArrayList<MavenDependencyNode> ret = new ArrayList<MavenDependencyNode>();
            for (DependencyNode n : this.dependencyNode.getChildren()) {
                MavenDependencyNode mn = this.children.get(n);
                if (mn == null) {
                    mn = new MavenDependencyNode(this, n);
                    this.children.put(n, mn);
                }
                ret.add(mn);
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild(MavenDependencyNode node) {
        HashMap<DependencyNode, MavenDependencyNode> hashMap = this.children;
        synchronized (hashMap) {
            this.children.put(node.dependencyNode, node);
            this.dependencyNode.addChild(node.dependencyNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeChild(MavenDependencyNode node) {
        HashMap<DependencyNode, MavenDependencyNode> hashMap = this.children;
        synchronized (hashMap) {
            this.children.remove(node.dependencyNode, node);
            this.dependencyNode.removeChild(node.dependencyNode);
        }
    }

    public int hashCode() {
        int hash = 3;
        hash = 23 * hash + (this.dependencyNode != null ? this.dependencyNode.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MavenDependencyNode other = (MavenDependencyNode)obj;
        return this.dependencyNode == other.dependencyNode || this.dependencyNode != null && this.dependencyNode.equals((Object)other.dependencyNode);
    }
}

