/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.multiview;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.modules.xml.api.EncodingUtil;

public class EncodingHelper {
    public static final String DEFAULT_ENCODING = "UTF-8";
    private String encoding = "UTF-8";

    public boolean isValidEncoding(String encoding) {
        try {
            new OutputStreamWriter((OutputStream)new ByteArrayOutputStream(1), encoding);
            return true;
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
    }

    public String setDefaultEncoding(String s) {
        int i;
        if (s.startsWith("<?xml") && (i = s.indexOf("?>")) > 0) {
            s = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>" + s.substring(i + 2);
        }
        return s;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void resetEncoding() {
        this.encoding = DEFAULT_ENCODING;
    }

    public String detectEncoding(StyledDocument document) throws IOException {
        return this.setEncoding(EncodingUtil.detectEncoding((Document)document));
    }

    public String detectEncoding(InputStream inputStream) throws IOException {
        return this.setEncoding(EncodingUtil.detectEncoding((InputStream)inputStream));
    }

    public String detectEncoding(byte[] data) throws IOException {
        return this.detectEncoding(new ByteArrayInputStream(data));
    }

    public String setEncoding(String encoding) {
        if (encoding == null) {
            return this.encoding;
        }
        if (this.isValidEncoding(encoding)) {
            this.encoding = encoding;
        }
        return encoding;
    }
}

