/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject.problems;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.java.j2seproject.api.J2SERuntimePlatformProvider;
import org.netbeans.modules.java.j2seproject.problems.RuntimePlatformProblemsProvider;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.modules.SpecificationVersion;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.Union2;

final class ResolveBrokenRuntimePlatform
extends JPanel {
    private final Type type;
    private final Project prj;
    private final Union2<String, RuntimePlatformProblemsProvider.InvalidPlatformData> data;
    private final ChangeSupport changeSupport;
    private ButtonGroup actions;
    private JButton create;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JComboBox platforms;
    private JRadioButton projectPlatform;
    private JRadioButton sourceLevel;
    private JLabel sourceLevelWarning;
    private JRadioButton specificPlatform;

    private ResolveBrokenRuntimePlatform(@NonNull Type type, @NonNull Project prj, @NonNull Union2<String, RuntimePlatformProblemsProvider.InvalidPlatformData> data) {
        Parameters.notNull((CharSequence)"type", (Object)((Object)type));
        Parameters.notNull((CharSequence)"prj", (Object)prj);
        Parameters.notNull((CharSequence)"data", data);
        this.type = type;
        this.prj = prj;
        this.data = data;
        this.changeSupport = new ChangeSupport((Object)this);
        this.initComponents();
        this.platforms.setRenderer(new PlatformRenderer());
        this.platforms.setModel(new DefaultComboBoxModel());
        this.updatePlatforms();
        ActionListener specificPlatformListener = new ActionListener(){

            @Override
            public void actionPerformed(@NullAllowed ActionEvent e) {
                ResolveBrokenRuntimePlatform.this.platforms.setEnabled(ResolveBrokenRuntimePlatform.this.specificPlatform.isSelected());
                ResolveBrokenRuntimePlatform.this.create.setEnabled(ResolveBrokenRuntimePlatform.this.specificPlatform.isSelected());
                ResolveBrokenRuntimePlatform.this.sourceLevelWarning.setEnabled(ResolveBrokenRuntimePlatform.this.sourceLevel.isSelected());
                ResolveBrokenRuntimePlatform.this.changeSupport.fireChange();
            }
        };
        this.specificPlatform.addActionListener(specificPlatformListener);
        this.projectPlatform.addActionListener(specificPlatformListener);
        this.sourceLevel.addActionListener(specificPlatformListener);
        specificPlatformListener.actionPerformed(null);
        this.projectPlatform.setSelected(true);
        if (type == Type.MISSING_PLATFORM) {
            this.sourceLevel.setVisible(false);
            this.sourceLevelWarning.setVisible(false);
        }
    }

    public void addChangeListener(@NonNull ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(@NonNull ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    boolean hasValidData() {
        return this.projectPlatform.isSelected() || this.sourceLevel.isSelected() || this.specificPlatform.isSelected() && this.platforms.getSelectedItem() != null;
    }

    boolean isProjectPlatform() {
        return this.projectPlatform.isSelected();
    }

    boolean isSpecificPlatform() {
        return this.specificPlatform.isSelected();
    }

    boolean isDowngradeSourceLevel() {
        return this.sourceLevel.isSelected();
    }

    @NonNull
    JavaPlatform getRuntimePlatform() {
        return (JavaPlatform)this.platforms.getSelectedItem();
    }

    private void updatePlatforms() {
        SourceLevelQuery.Result slqr = SourceLevelQuery.getSourceLevel2((FileObject)this.prj.getProjectDirectory());
        String sl = slqr.getSourceLevel();
        SourceLevelQuery.Profile profile = slqr.getProfile();
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.platforms.getModel();
        model.removeAllElements();
        for (J2SERuntimePlatformProvider pp : this.prj.getLookup().lookupAll(J2SERuntimePlatformProvider.class)) {
            for (JavaPlatform javaPlatform : pp.getPlatformType(new SpecificationVersion(sl), profile)) {
                model.addElement(javaPlatform);
            }
        }
    }

    @NonNull
    private static String getMessage(@NonNull Type type, @NonNull Project project, @NonNull Union2<String, RuntimePlatformProblemsProvider.InvalidPlatformData> data) {
        switch (type) {
            case MISSING_PLATFORM: {
                return NbBundle.getMessage(ResolveBrokenRuntimePlatform.class, (String)"LBL_ResolveMissingRuntimePlatform", (Object)data.first());
            }
            case INVALID_PLATFORM: {
                return NbBundle.getMessage(ResolveBrokenRuntimePlatform.class, (String)"LBL_ResolveInvalidRuntimePlatform", (Object)ProjectUtils.getInformation((Project)project).getDisplayName(), (Object)((RuntimePlatformProblemsProvider.InvalidPlatformData)data.second()).getTargetLevel(), (Object)((RuntimePlatformProblemsProvider.InvalidPlatformData)data.second()).getProfile().getDisplayName(), (Object)((RuntimePlatformProblemsProvider.InvalidPlatformData)data.second()).getJavaPlatform().getDisplayName(), (Object[])new Object[]{((RuntimePlatformProblemsProvider.InvalidPlatformData)data.second()).getJavaPlatform().getSpecification().getVersion(), RuntimePlatformProblemsProvider.getPlatformProfile(((RuntimePlatformProblemsProvider.InvalidPlatformData)data.second()).getJavaPlatform()).getDisplayName()});
            }
        }
        throw new IllegalArgumentException(String.valueOf((Object)type));
    }

    @NonNull
    private static String getPlatformSourceLevelMessage(@NonNull JavaPlatform jp) {
        return NbBundle.getMessage(ResolveBrokenRuntimePlatform.class, (String)"LBL_DowngradeSourceLevel", (Object)jp.getSpecification().getVersion(), (Object)RuntimePlatformProblemsProvider.getPlatformProfile(jp).getDisplayName());
    }

    static ResolveBrokenRuntimePlatform createMissingPlatform(@NonNull Project project, @NonNull String platformId) {
        return new ResolveBrokenRuntimePlatform(Type.MISSING_PLATFORM, project, (Union2<String, RuntimePlatformProblemsProvider.InvalidPlatformData>)Union2.createFirst((Object)platformId));
    }

    static ResolveBrokenRuntimePlatform createInvalidPlatform(@NonNull Project project, @NonNull RuntimePlatformProblemsProvider.InvalidPlatformData data) {
        return new ResolveBrokenRuntimePlatform(Type.INVALID_PLATFORM, project, (Union2<String, RuntimePlatformProblemsProvider.InvalidPlatformData>)Union2.createSecond((Object)data));
    }

    private void initComponents() {
        this.actions = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.projectPlatform = new JRadioButton();
        this.specificPlatform = new JRadioButton();
        this.platforms = new JComboBox();
        this.create = new JButton();
        this.jLabel2 = new JLabel();
        this.sourceLevel = new JRadioButton();
        this.sourceLevelWarning = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)ResolveBrokenRuntimePlatform.getMessage(this.type, this.prj, this.data));
        this.actions.add(this.projectPlatform);
        Mnemonics.setLocalizedText((AbstractButton)this.projectPlatform, (String)NbBundle.getMessage(ResolveBrokenRuntimePlatform.class, (String)"ResolveBrokenRuntimePlatform.projectPlatform.text"));
        this.actions.add(this.specificPlatform);
        Mnemonics.setLocalizedText((AbstractButton)this.specificPlatform, (String)NbBundle.getMessage(ResolveBrokenRuntimePlatform.class, (String)"ResolveBrokenRuntimePlatform.specificPlatform.text"));
        this.platforms.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        Mnemonics.setLocalizedText((AbstractButton)this.create, (String)NbBundle.getMessage(ResolveBrokenRuntimePlatform.class, (String)"ResolveBrokenRuntimePlatform.create.text"));
        this.create.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ResolveBrokenRuntimePlatform.this.create(evt);
            }
        });
        this.jLabel2.setLabelFor(this.platforms);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ResolveBrokenRuntimePlatform.class, (String)"ResolveBrokenRuntimePlatform.jLabel2.text"));
        this.actions.add(this.sourceLevel);
        this.sourceLevel.setMnemonic(NbBundle.getMessage(ResolveBrokenRuntimePlatform.class, (String)"MNE_DowngradeSourceLevel").charAt(0));
        this.sourceLevel.setText(this.type == Type.MISSING_PLATFORM ? "" : ResolveBrokenRuntimePlatform.getPlatformSourceLevelMessage(((RuntimePlatformProblemsProvider.InvalidPlatformData)this.data.second()).getJavaPlatform()));
        Mnemonics.setLocalizedText((JLabel)this.sourceLevelWarning, (String)NbBundle.getMessage(ResolveBrokenRuntimePlatform.class, (String)"ResolveBrokenRuntimePlatform.sourceLevelWarning.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(29, 29, 29).addComponent(this.sourceLevelWarning).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.sourceLevel, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.projectPlatform, -1, -1, Short.MAX_VALUE).addComponent(this.specificPlatform, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(29, 29, 29).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.platforms, 0, -1, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.create)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.projectPlatform).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.specificPlatform).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.platforms, -2, -1, -2).addComponent(this.create).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sourceLevel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sourceLevelWarning).addContainerGap(24, Short.MAX_VALUE)));
    }

    private void create(ActionEvent evt) {
        JavaPlatform jp = (JavaPlatform)this.platforms.getSelectedItem();
        PlatformsCustomizer.showCustomizer((JavaPlatform)jp);
        this.updatePlatforms();
    }

    private static final class PlatformRenderer
    extends DefaultListCellRenderer {
        private PlatformRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof JavaPlatform) {
                value = ((JavaPlatform)value).getDisplayName();
            }
            return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
    }

    private static enum Type {
        MISSING_PLATFORM,
        INVALID_PLATFORM;

    }
}

