/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jshell.navigation;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.modules.jshell.model.ConsoleContents;
import org.netbeans.modules.jshell.model.SnippetHandle;
import org.netbeans.modules.jshell.navigation.SnippetNavigationPanel;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.CursorMovedSchedulerEvent;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.parsing.spi.SchedulerTask;
import org.netbeans.modules.parsing.spi.TaskFactory;

public final class NavigationTask
extends ParserResultTask<ConsoleContents> {
    private AtomicBoolean cancel = new AtomicBoolean(false);

    public void run(ConsoleContents result, SchedulerEvent event) {
        if (!(event instanceof CursorMovedSchedulerEvent)) {
            return;
        }
        this.cancel.set(false);
        CursorMovedSchedulerEvent ev = (CursorMovedSchedulerEvent)event;
        int of = ev.getCaretOffset();
        Optional<SnippetHandle> handle = result.findSnippetAt(of);
        if (!handle.isPresent()) {
            return;
        }
        SnippetNavigationPanel.navigate(handle.get());
    }

    public int getPriority() {
        return 1000;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.CURSOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void cancel() {
        this.cancel.set(true);
    }

    public static final class Factory
    extends TaskFactory {
        public Collection<? extends SchedulerTask> create(Snapshot snapshot) {
            return Collections.singleton(new NavigationTask());
        }
    }
}

