/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.search;

import java.util.HashSet;
import java.util.Iterator;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openidex.search.FileObjectFilter;
import org.openidex.search.SearchInfo;
import org.openidex.search.SearchInfoFactory;

public final class Utils {
    private Utils() {
    }

    static SearchInfo getSearchInfo(Node node) {
        SearchInfo info = (SearchInfo)node.getLookup().lookup(SearchInfo.class);
        if (info != null) {
            return info;
        }
        DataFolder container = (DataFolder)node.getLookup().lookup(DataFolder.class);
        if (container == null) {
            return null;
        }
        return SearchInfoFactory.createSearchInfo(container.getPrimaryFile(), true, new FileObjectFilter[]{SearchInfoFactory.VISIBILITY_FILTER});
    }

    public static Iterator<FileObject> getFileObjectsIterator(SearchInfo si) {
        if (si instanceof SearchInfo.Files) {
            return ((SearchInfo.Files)si).filesToSearch();
        }
        HashSet<FileObject> set = new HashSet<FileObject>();
        Iterator<DataObject> iter = si.objectsToSearch();
        while (iter.hasNext()) {
            set.add(iter.next().getPrimaryFile());
        }
        return set.iterator();
    }

    static Iterator<DataObject> toDataObjectIterator(Iterator<FileObject> itFO) {
        HashSet<DataObject> set = new HashSet<DataObject>();
        while (itFO.hasNext()) {
            try {
                set.add(DataObject.find((FileObject)itFO.next()));
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {}
        }
        return set.iterator();
    }
}

