/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.entity;

import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.util.ArrayList;
import java.util.Collection;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.modules.j2ee.jpa.model.AccessType;
import org.netbeans.modules.j2ee.jpa.model.JPAAnnotations;
import org.netbeans.modules.j2ee.jpa.model.ModelUtils;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.common.Utilities;
import org.netbeans.modules.j2ee.jpa.verification.rules.entity.LegalCombinationOfAnnotations;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;
import org.openide.util.NbBundle;

public class JPAAnnotsOnlyOnAccesor {
    public static Collection<ErrorDescription> apply(HintContext hc) {
        if (hc.isCanceled() || hc.getPath().getLeaf().getKind() != Tree.Kind.IDENTIFIER || hc.getPath().getParentPath().getLeaf().getKind() != Tree.Kind.ANNOTATION) {
            return null;
        }
        JPAProblemContext ctx = ModelUtils.getOrCreateCachedContext(hc);
        if (ctx == null || hc.isCanceled()) {
            return null;
        }
        TypeElement subject = ctx.getJavaClass();
        if (ctx.getAccessType() != AccessType.PROPERTY) {
            return null;
        }
        ArrayList<ErrorDescription> problemsFound = new ArrayList<ErrorDescription>();
        block0: for (ExecutableElement method : ElementFilter.methodsIn(subject.getEnclosedElements())) {
            if (JPAAnnotsOnlyOnAccesor.isAccessor(method)) continue;
            for (String annotName : ModelUtils.extractAnnotationNames(method)) {
                if (!JPAAnnotations.MEMBER_LEVEL.contains(annotName)) continue;
                MethodTree elementTree = ctx.getCompilationInfo().getTrees().getTree(method);
                Utilities.TextSpan underlineSpan = Utilities.getUnderlineSpan(ctx.getCompilationInfo(), elementTree);
                ErrorDescription error = ErrorDescriptionFactory.forSpan((HintContext)hc, (int)underlineSpan.getStartOffset(), (int)underlineSpan.getEndOffset(), (String)NbBundle.getMessage(LegalCombinationOfAnnotations.class, (String)"MSG_JPAAnnotsOnlyOnAccesor", (Object)ModelUtils.shortAnnotationName(annotName)), (Fix[])new Fix[0]);
                problemsFound.add(error);
                continue block0;
            }
        }
        return problemsFound;
    }

    private static boolean isAccessor(ExecutableElement method) {
        if (!method.getParameters().isEmpty()) {
            return false;
        }
        String methodName = method.getSimpleName().toString();
        if (methodName.startsWith("get")) {
            return true;
        }
        return JPAAnnotsOnlyOnAccesor.isBoolean(method.getReturnType().toString()) && methodName.startsWith("is");
    }

    private static boolean isBoolean(String type) {
        return "boolean".equals(type) || "java.lang.Boolean".equals(type);
    }
}

