/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.jruby;

import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.msgpack.jruby.Buffer;
import org.msgpack.jruby.Encoder;
import org.msgpack.jruby.ExtensionRegistry;
import org.msgpack.jruby.ExtensionValue;

@JRubyClass(name={"MessagePack::Packer"})
public class Packer
extends RubyObject {
    public ExtensionRegistry registry;
    private Buffer buffer;
    private Encoder encoder;
    private boolean hasSymbolExtType;
    private Encoding binaryEncoding;

    public Packer(Ruby ruby, RubyClass rubyClass, ExtensionRegistry extensionRegistry, boolean bl) {
        super(ruby, rubyClass);
        this.registry = extensionRegistry;
        this.hasSymbolExtType = bl;
    }

    @JRubyMethod(name={"initialize"}, optional=2)
    public IRubyObject initialize(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        boolean bl = false;
        if (iRubyObjectArray.length > 0 && iRubyObjectArray[iRubyObjectArray.length - 1] instanceof RubyHash) {
            RubyHash rubyHash = (RubyHash)iRubyObjectArray[iRubyObjectArray.length - 1];
            IRubyObject iRubyObject = rubyHash.fastARef((IRubyObject)threadContext.getRuntime().newSymbol("compatibility_mode"));
            boolean bl2 = bl = iRubyObject != null && iRubyObject.isTrue();
        }
        if (this.registry == null) {
            this.registry = new ExtensionRegistry();
        }
        this.encoder = new Encoder(threadContext.getRuntime(), bl, this.registry, this.hasSymbolExtType);
        this.buffer = new Buffer(threadContext.getRuntime(), threadContext.getRuntime().getModule("MessagePack").getClass("Buffer"));
        this.buffer.initialize(threadContext, iRubyObjectArray);
        this.binaryEncoding = threadContext.getRuntime().getEncodingService().getAscii8bitEncoding();
        return this;
    }

    public static Packer newPacker(ThreadContext threadContext, ExtensionRegistry extensionRegistry, boolean bl, IRubyObject[] iRubyObjectArray) {
        Packer packer = new Packer(threadContext.getRuntime(), threadContext.getRuntime().getModule("MessagePack").getClass("Packer"), extensionRegistry, bl);
        packer.initialize(threadContext, iRubyObjectArray);
        return packer;
    }

    @JRubyMethod(name={"compatibility_mode?"})
    public IRubyObject isCompatibilityMode(ThreadContext threadContext) {
        return this.encoder.isCompatibilityMode() ? threadContext.getRuntime().getTrue() : threadContext.getRuntime().getFalse();
    }

    @JRubyMethod(name={"registered_types_internal"}, visibility=Visibility.PRIVATE)
    public IRubyObject registeredTypesInternal(ThreadContext threadContext) {
        return this.registry.toInternalPackerRegistry(threadContext);
    }

    @JRubyMethod(name={"register_type"}, required=2, optional=1)
    public IRubyObject registerType(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, Block block) {
        RubyProc rubyProc;
        RubyProc rubyProc2;
        Ruby ruby = threadContext.getRuntime();
        IRubyObject iRubyObject = iRubyObjectArray[0];
        IRubyObject iRubyObject2 = iRubyObjectArray[1];
        if (iRubyObjectArray.length == 2) {
            if (!block.isGiven()) {
                throw ruby.newLocalJumpErrorNoBlock();
            }
            rubyProc = rubyProc2 = block.getProcObject();
        } else if (iRubyObjectArray.length == 3) {
            rubyProc = iRubyObjectArray[2];
            rubyProc2 = rubyProc.callMethod(threadContext, "to_proc");
        } else {
            throw ruby.newArgumentError(String.format("wrong number of arguments (%d for 2..3)", 2 + iRubyObjectArray.length));
        }
        long l = ((RubyFixnum)iRubyObject).getLongValue();
        if (l < -128L || l > 127L) {
            throw ruby.newRangeError(String.format("integer %d too big to convert to `signed char'", l));
        }
        if (!(iRubyObject2 instanceof RubyModule)) {
            throw ruby.newArgumentError(String.format("expected Module/Class but found %s.", iRubyObject2.getType().getName()));
        }
        RubyModule rubyModule = (RubyModule)iRubyObject2;
        this.registry.put(rubyModule, (int)l, (IRubyObject)rubyProc2, (IRubyObject)rubyProc, null, null);
        if (rubyModule == ruby.getSymbol()) {
            this.encoder.hasSymbolExtType = true;
        }
        return ruby.getNil();
    }

    @JRubyMethod(name={"write"}, alias={"pack"})
    public IRubyObject write(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.buffer.write(threadContext, this.encoder.encode(iRubyObject, (IRubyObject)this));
        return this;
    }

    @JRubyMethod(name={"write_float"})
    public IRubyObject writeFloat(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.checkType(threadContext, iRubyObject, RubyFloat.class);
        return this.write(threadContext, iRubyObject);
    }

    @JRubyMethod(name={"write_array"})
    public IRubyObject writeArray(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.checkType(threadContext, iRubyObject, RubyArray.class);
        return this.write(threadContext, iRubyObject);
    }

    @JRubyMethod(name={"write_string"})
    public IRubyObject writeString(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.checkType(threadContext, iRubyObject, RubyString.class);
        return this.write(threadContext, iRubyObject);
    }

    @JRubyMethod(name={"write_bin"})
    public IRubyObject writeBin(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.checkType(threadContext, iRubyObject, RubyString.class);
        iRubyObject = ((RubyString)iRubyObject).encode(threadContext, (IRubyObject)threadContext.runtime.getEncodingService().getEncoding(this.binaryEncoding));
        return this.write(threadContext, iRubyObject);
    }

    @JRubyMethod(name={"write_hash"})
    public IRubyObject writeHash(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.checkType(threadContext, iRubyObject, RubyHash.class);
        return this.write(threadContext, iRubyObject);
    }

    @JRubyMethod(name={"write_symbol"})
    public IRubyObject writeSymbol(ThreadContext threadContext, IRubyObject iRubyObject) {
        this.checkType(threadContext, iRubyObject, RubySymbol.class);
        return this.write(threadContext, iRubyObject);
    }

    @JRubyMethod(name={"write_int"})
    public IRubyObject writeInt(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof RubyFixnum)) {
            this.checkType(threadContext, iRubyObject, RubyBignum.class);
        }
        return this.write(threadContext, iRubyObject);
    }

    @JRubyMethod(name={"write_extension"})
    public IRubyObject writeExtension(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (!(iRubyObject instanceof ExtensionValue)) {
            throw threadContext.runtime.newTypeError("Expected extension");
        }
        return this.write(threadContext, iRubyObject);
    }

    @JRubyMethod(name={"write_true"})
    public IRubyObject writeTrue(ThreadContext threadContext) {
        return this.write(threadContext, (IRubyObject)threadContext.getRuntime().getTrue());
    }

    @JRubyMethod(name={"write_false"})
    public IRubyObject writeFalse(ThreadContext threadContext) {
        return this.write(threadContext, (IRubyObject)threadContext.getRuntime().getFalse());
    }

    @JRubyMethod(name={"write_nil"})
    public IRubyObject writeNil(ThreadContext threadContext) {
        this.write(threadContext, null);
        return this;
    }

    @JRubyMethod(name={"write_float32"})
    public IRubyObject writeFloat32(ThreadContext threadContext, IRubyObject iRubyObject) {
        Ruby ruby = threadContext.runtime;
        if (!(iRubyObject instanceof RubyNumeric)) {
            throw ruby.newArgumentError("Expected numeric");
        }
        this.buffer.write(threadContext, this.encoder.encodeFloat32((RubyNumeric)iRubyObject));
        return this;
    }

    @JRubyMethod(name={"write_array_header"})
    public IRubyObject writeArrayHeader(ThreadContext threadContext, IRubyObject iRubyObject) {
        int n = (int)iRubyObject.convertToInteger().getLongValue();
        this.buffer.write(threadContext, this.encoder.encodeArrayHeader(n));
        return this;
    }

    @JRubyMethod(name={"write_map_header"})
    public IRubyObject writeMapHeader(ThreadContext threadContext, IRubyObject iRubyObject) {
        int n = (int)iRubyObject.convertToInteger().getLongValue();
        this.buffer.write(threadContext, this.encoder.encodeMapHeader(n));
        return this;
    }

    @JRubyMethod(name={"write_bin_header"})
    public IRubyObject writeBinHeader(ThreadContext threadContext, IRubyObject iRubyObject) {
        int n = (int)iRubyObject.convertToInteger().getLongValue();
        this.buffer.write(threadContext, this.encoder.encodeBinHeader(n));
        return this;
    }

    @JRubyMethod(name={"full_pack"})
    public IRubyObject fullPack(ThreadContext threadContext) {
        return this.toS(threadContext);
    }

    @JRubyMethod(name={"to_s"}, alias={"to_str"})
    public IRubyObject toS(ThreadContext threadContext) {
        return this.buffer.toS(threadContext);
    }

    @JRubyMethod(name={"buffer"})
    public IRubyObject buffer(ThreadContext threadContext) {
        return this.buffer;
    }

    @JRubyMethod(name={"flush"})
    public IRubyObject flush(ThreadContext threadContext) {
        return this.buffer.flush(threadContext);
    }

    @JRubyMethod(name={"size"})
    public IRubyObject size(ThreadContext threadContext) {
        return this.buffer.size(threadContext);
    }

    @JRubyMethod(name={"clear"})
    public IRubyObject clear(ThreadContext threadContext) {
        return this.buffer.clear(threadContext);
    }

    private void checkType(ThreadContext threadContext, IRubyObject iRubyObject, Class<? extends IRubyObject> clazz) {
        if (!clazz.isInstance(iRubyObject)) {
            String string = clazz.getName().substring("org.jruby.Ruby".length());
            throw threadContext.runtime.newTypeError(String.format("wrong argument type %s (expected %s)", iRubyObject.getMetaClass().toString(), string));
        }
    }

    static class PackerAllocator
    implements ObjectAllocator {
        PackerAllocator() {
        }

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new Packer(ruby, rubyClass, null, false);
        }
    }
}

