/*
 * Decompiled with CFR 0.152.
 */
package org.msgpack.jruby;

import java.nio.ByteBuffer;
import org.jcodings.Encoding;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyClass(name={"MessagePack::Buffer"})
public class Buffer
extends RubyObject {
    private IRubyObject io;
    private ByteBuffer buffer;
    private boolean writeMode;
    private Encoding binaryEncoding;
    private static final int CACHE_LINE_SIZE = 64;
    private static final int ARRAY_HEADER_SIZE = 24;

    public Buffer(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    @JRubyMethod(name={"initialize"}, optional=2)
    public IRubyObject initialize(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        IRubyObject iRubyObject;
        if (iRubyObjectArray.length > 0 && (iRubyObject = iRubyObjectArray[0]).respondsTo("close") && (iRubyObject.respondsTo("read") || iRubyObject.respondsTo("write") && iRubyObject.respondsTo("flush"))) {
            this.io = iRubyObject;
        }
        this.buffer = ByteBuffer.allocate(40);
        this.writeMode = true;
        this.binaryEncoding = threadContext.getRuntime().getEncodingService().getAscii8bitEncoding();
        return this;
    }

    private void ensureRemainingCapacity(int n) {
        if (!this.writeMode) {
            this.buffer.compact();
            this.writeMode = true;
        }
        if (this.buffer.remaining() < n) {
            int n2 = Math.max(this.buffer.capacity() + (this.buffer.capacity() >> 1), this.buffer.capacity() + n);
            n2 += 64 - (24 + n2) % 64;
            this.buffer = ByteBuffer.allocate(n2).put(this.buffer.array(), 0, this.buffer.position());
        }
    }

    private void ensureReadMode() {
        if (this.writeMode) {
            this.buffer.flip();
            this.writeMode = false;
        }
    }

    private int rawSize() {
        if (this.writeMode) {
            return this.buffer.position();
        }
        return this.buffer.limit() - this.buffer.position();
    }

    @JRubyMethod(name={"clear"})
    public IRubyObject clear(ThreadContext threadContext) {
        if (!this.writeMode) {
            this.buffer.compact();
            this.writeMode = true;
        }
        this.buffer.clear();
        return threadContext.getRuntime().getNil();
    }

    @JRubyMethod(name={"size"})
    public IRubyObject size(ThreadContext threadContext) {
        return threadContext.getRuntime().newFixnum(this.rawSize());
    }

    @JRubyMethod(name={"empty?"})
    public IRubyObject isEmpty(ThreadContext threadContext) {
        return this.rawSize() == 0 ? threadContext.getRuntime().getTrue() : threadContext.getRuntime().getFalse();
    }

    private IRubyObject bufferWrite(ThreadContext threadContext, IRubyObject iRubyObject) {
        ByteList byteList = iRubyObject.asString().getByteList();
        int n = byteList.length();
        this.ensureRemainingCapacity(n);
        this.buffer.put(byteList.unsafeBytes(), byteList.begin(), n);
        return threadContext.getRuntime().newFixnum(n);
    }

    @JRubyMethod(name={"write"}, alias={"<<"})
    public IRubyObject write(ThreadContext threadContext, IRubyObject iRubyObject) {
        if (this.io == null) {
            return this.bufferWrite(threadContext, iRubyObject);
        }
        return this.io.callMethod(threadContext, "write", iRubyObject);
    }

    private void feed(ThreadContext threadContext) {
        if (this.io != null) {
            this.bufferWrite(threadContext, this.io.callMethod(threadContext, "read"));
        }
    }

    private IRubyObject readCommon(ThreadContext threadContext, IRubyObject[] iRubyObjectArray, boolean bl) {
        this.feed(threadContext);
        int n = this.rawSize();
        if (iRubyObjectArray != null && iRubyObjectArray.length == 1) {
            n = (int)iRubyObjectArray[0].convertToInteger().getLongValue();
        }
        if (bl && this.rawSize() < n) {
            throw threadContext.getRuntime().newEOFError();
        }
        int n2 = Math.min(n, this.rawSize());
        if (n2 == 0 && n > 0) {
            return threadContext.getRuntime().getNil();
        }
        if (n2 == 0) {
            return threadContext.getRuntime().newString();
        }
        this.ensureReadMode();
        byte[] byArray = new byte[n2];
        this.buffer.get(byArray);
        ByteList byteList = new ByteList(byArray, this.binaryEncoding);
        return threadContext.getRuntime().newString(byteList);
    }

    @JRubyMethod(name={"read"}, optional=1)
    public IRubyObject read(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        return this.readCommon(threadContext, iRubyObjectArray, false);
    }

    @JRubyMethod(name={"read_all"}, optional=1)
    public IRubyObject readAll(ThreadContext threadContext, IRubyObject[] iRubyObjectArray) {
        return this.readCommon(threadContext, iRubyObjectArray, true);
    }

    private IRubyObject skipCommon(ThreadContext threadContext, IRubyObject iRubyObject, boolean bl) {
        this.feed(threadContext);
        int n = (int)iRubyObject.convertToInteger().getLongValue();
        if (bl && this.rawSize() < n) {
            throw threadContext.getRuntime().newEOFError();
        }
        this.ensureReadMode();
        int n2 = Math.min(n, this.rawSize());
        this.buffer.position(this.buffer.position() + n2);
        return threadContext.getRuntime().newFixnum(n2);
    }

    @JRubyMethod(name={"skip"})
    public IRubyObject skip(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.skipCommon(threadContext, iRubyObject, false);
    }

    @JRubyMethod(name={"skip_all"})
    public IRubyObject skipAll(ThreadContext threadContext, IRubyObject iRubyObject) {
        return this.skipCommon(threadContext, iRubyObject, true);
    }

    @JRubyMethod(name={"to_s"}, alias={"to_str"})
    public IRubyObject toS(ThreadContext threadContext) {
        this.ensureReadMode();
        int n = this.buffer.limit() - this.buffer.position();
        ByteList byteList = new ByteList(this.buffer.array(), this.buffer.position(), n, this.binaryEncoding, true);
        return threadContext.getRuntime().newString(byteList);
    }

    @JRubyMethod(name={"to_a"})
    public IRubyObject toA(ThreadContext threadContext) {
        return threadContext.getRuntime().newArray(this.toS(threadContext));
    }

    @JRubyMethod(name={"io"})
    public IRubyObject getIo(ThreadContext threadContext) {
        return this.io == null ? threadContext.getRuntime().getNil() : this.io;
    }

    @JRubyMethod(name={"flush"})
    public IRubyObject flush(ThreadContext threadContext) {
        if (this.io == null) {
            return threadContext.getRuntime().getNil();
        }
        return this.io.callMethod(threadContext, "flush");
    }

    @JRubyMethod(name={"close"})
    public IRubyObject close(ThreadContext threadContext) {
        if (this.io == null) {
            return threadContext.getRuntime().getNil();
        }
        return this.io.callMethod(threadContext, "close");
    }

    @JRubyMethod(name={"write_to"})
    public IRubyObject writeTo(ThreadContext threadContext, IRubyObject iRubyObject) {
        return iRubyObject.callMethod(threadContext, "write", this.readCommon(threadContext, null, false));
    }

    static class BufferAllocator
    implements ObjectAllocator {
        BufferAllocator() {
        }

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new Buffer(ruby, rubyClass);
        }
    }
}

