/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.nlp.lm.io;

import edu.berkeley.nlp.lm.array.LongArray;
import edu.berkeley.nlp.lm.collections.LongRepresentable;
import edu.berkeley.nlp.lm.collections.LongToIntHashMap;
import edu.berkeley.nlp.lm.io.ArpaLmReaderCallback;
import edu.berkeley.nlp.lm.util.Logger;
import java.util.Arrays;
import java.util.List;

public final class FirstPassCallback<V extends LongRepresentable<V>>
implements ArpaLmReaderCallback<V> {
    private LongToIntHashMap valueCounter;
    private LongArray[] numNgramsForEachWord;
    private long[] numNgramsForOrder;
    private final boolean reverse;
    private int maxNgramOrder = 0;

    public FirstPassCallback(boolean reverse) {
        this.reverse = reverse;
        this.valueCounter = new LongToIntHashMap();
    }

    @Override
    public void call(int[] ngram, int startPos, int endPos, V v, String words) {
        this.maxNgramOrder = Math.max(endPos - startPos, this.maxNgramOrder);
        int ngramOrder = endPos - startPos - 1;
        this.allocatedNumNgramArrayIfNecessary(ngramOrder);
        this.allocatedNumNgramForOrderArrayIfNecessary(ngramOrder);
        this.valueCounter.incrementCount(v.asLong(), 1);
        LongArray ngramOrderCounts = this.numNgramsForEachWord[ngramOrder];
        int word = this.reverse ? ngram[startPos] : ngram[ngramOrder];
        ngramOrderCounts.incrementCount(word, 1L);
        int n = ngramOrder;
        this.numNgramsForOrder[n] = this.numNgramsForOrder[n] + 1L;
    }

    @Override
    public void handleNgramOrderFinished(int order) {
    }

    @Override
    public void cleanup() {
        Logger.startTrack("Cleaning up values", new Object[0]);
        Logger.logss("Found " + this.valueCounter.size() + " unique counts");
        Logger.endTrack();
    }

    public LongToIntHashMap getValueCounter() {
        return this.valueCounter;
    }

    @Override
    public void initWithLengths(List<Long> numNGrams) {
        this.maxNgramOrder = numNGrams.size();
        long numWords = numNGrams.get(0);
        this.numNgramsForEachWord = new LongArray[numNGrams.size()];
        for (int ngramOrder = 0; ngramOrder < this.numNgramsForEachWord.length; ++ngramOrder) {
            this.numNgramsForEachWord[ngramOrder] = LongArray.StaticMethods.newLongArray(numNGrams.get(ngramOrder), numWords, numWords);
        }
    }

    public LongArray[] getNumNgramsForEachWord() {
        return Arrays.copyOf(this.numNgramsForEachWord, this.maxNgramOrder);
    }

    public long[] getNumNgramsForEachOrder() {
        return Arrays.copyOf(this.numNgramsForOrder, this.maxNgramOrder);
    }

    private int allocatedNumNgramArrayIfNecessary(int ngramOrder) {
        if (this.numNgramsForEachWord == null) {
            this.numNgramsForEachWord = new LongArray[5];
        }
        if (ngramOrder >= this.numNgramsForEachWord.length) {
            this.numNgramsForEachWord = Arrays.copyOf(this.numNgramsForEachWord, this.numNgramsForEachWord.length * 2);
        }
        if (this.numNgramsForEachWord[ngramOrder] == null) {
            this.numNgramsForEachWord[ngramOrder] = LongArray.StaticMethods.newLongArray(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        return ngramOrder;
    }

    private int allocatedNumNgramForOrderArrayIfNecessary(int ngramOrder) {
        if (this.numNgramsForOrder == null) {
            this.numNgramsForOrder = new long[5];
        }
        if (ngramOrder >= this.numNgramsForOrder.length) {
            this.numNgramsForOrder = Arrays.copyOf(this.numNgramsForOrder, this.numNgramsForOrder.length * 2);
        }
        return ngramOrder;
    }

    @Override
    public void handleNgramOrderStarted(int order) {
    }
}

