/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.propertyeditor;

import java.lang.reflect.Method;
import org.apache.xbean.propertyeditor.AbstractConverter;
import org.apache.xbean.propertyeditor.PropertyEditorException;

public class EnumConverter
extends AbstractConverter {
    public EnumConverter(Class type) {
        super(type);
    }

    protected Object toObjectImpl(String text) {
        Class type = this.getType();
        try {
            return Enum.valueOf(type, text);
        }
        catch (Exception cause) {
            try {
                int index = Integer.parseInt(text);
                Method method = type.getMethod("values", new Class[0]);
                Object[] values = (Object[])method.invoke(null, new Object[0]);
                return values[index];
            }
            catch (NumberFormatException e) {
            }
            catch (Exception e) {
                cause = e;
            }
            throw new PropertyEditorException("Value \"" + text + "\" cannot be converted to enum type " + type.getName(), cause);
        }
    }
}

