/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider;

import com.google.common.base.Objects;
import java.util.Collection;
import java.util.Map;
import org.gradle.api.internal.provider.MapCollector;
import org.gradle.api.internal.provider.MapEntryCollector;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.internal.provider.ValueCollector;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;

public class MapCollectors {

    public static class NoValue
    implements MapCollector<Object, Object> {
        @Override
        public boolean present() {
            return false;
        }

        @Override
        public void collectInto(MapEntryCollector<Object, Object> collector, Map<Object, Object> dest) {
            throw new IllegalStateException("No value has been specified for this provider.");
        }

        @Override
        public boolean maybeCollectInto(MapEntryCollector<Object, Object> collector, Map<Object, Object> dest) {
            return false;
        }

        @Override
        public void collectKeysInto(ValueCollector<Object> collector, Collection<Object> dest) {
            throw new IllegalStateException("No value has been specified for this provider.");
        }

        @Override
        public boolean maybeCollectKeysInto(ValueCollector<Object> collector, Collection<Object> dest) {
            return false;
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            return true;
        }
    }

    public static class EntriesFromMapProvider<K, V>
    implements MapCollector<K, V> {
        private final ProviderInternal<? extends Map<? extends K, ? extends V>> providerOfEntries;

        public EntriesFromMapProvider(ProviderInternal<? extends Map<? extends K, ? extends V>> providerOfEntries) {
            this.providerOfEntries = providerOfEntries;
        }

        @Override
        public boolean present() {
            return this.providerOfEntries.isPresent();
        }

        @Override
        public void collectInto(MapEntryCollector<K, V> collector, Map<K, V> dest) {
            collector.addAll(((Map)this.providerOfEntries.get()).entrySet(), dest);
        }

        @Override
        public boolean maybeCollectInto(MapEntryCollector<K, V> collector, Map<K, V> dest) {
            Map entries = (Map)this.providerOfEntries.getOrNull();
            if (entries != null) {
                collector.addAll(entries.entrySet(), dest);
                return true;
            }
            return false;
        }

        @Override
        public void collectKeysInto(ValueCollector<K> collector, Collection<K> dest) {
            collector.addAll(((Map)this.providerOfEntries.get()).keySet(), dest);
        }

        @Override
        public boolean maybeCollectKeysInto(ValueCollector<K> collector, Collection<K> dest) {
            Map entries = (Map)this.providerOfEntries.getOrNull();
            if (entries != null) {
                collector.addAll(entries.keySet(), dest);
                return true;
            }
            return false;
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            return this.providerOfEntries.maybeVisitBuildDependencies(context);
        }
    }

    public static class EntriesFromMap<K, V>
    implements MapCollector<K, V> {
        private final Map<? extends K, ? extends V> entries;

        public EntriesFromMap(Map<? extends K, ? extends V> entries) {
            this.entries = entries;
        }

        @Override
        public boolean present() {
            return true;
        }

        @Override
        public void collectInto(MapEntryCollector<K, V> collector, Map<K, V> dest) {
            collector.addAll(this.entries.entrySet(), dest);
        }

        @Override
        public boolean maybeCollectInto(MapEntryCollector<K, V> collector, Map<K, V> dest) {
            this.collectInto(collector, dest);
            return true;
        }

        @Override
        public void collectKeysInto(ValueCollector<K> collector, Collection<K> dest) {
            collector.addAll(this.entries.keySet(), dest);
        }

        @Override
        public boolean maybeCollectKeysInto(ValueCollector<K> collector, Collection<K> dest) {
            this.collectKeysInto(collector, dest);
            return true;
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            return false;
        }
    }

    public static class EntryWithValueFromProvider<K, V>
    implements MapCollector<K, V> {
        private final K key;
        private final ProviderInternal<? extends V> providerOfValue;

        public EntryWithValueFromProvider(K key, ProviderInternal<? extends V> providerOfValue) {
            this.key = key;
            this.providerOfValue = providerOfValue;
        }

        @Override
        public boolean present() {
            return this.providerOfValue.isPresent();
        }

        @Override
        public void collectInto(MapEntryCollector<K, V> collector, Map<K, V> dest) {
            collector.add(this.key, this.providerOfValue.get(), dest);
        }

        @Override
        public boolean maybeCollectInto(MapEntryCollector<K, V> collector, Map<K, V> dest) {
            Object value = this.providerOfValue.getOrNull();
            if (value != null) {
                collector.add(this.key, value, dest);
                return true;
            }
            return false;
        }

        @Override
        public void collectKeysInto(ValueCollector<K> collector, Collection<K> dest) {
            if (!this.providerOfValue.isPresent()) {
                throw new IllegalStateException("No value has been specified for this provider.");
            }
            collector.add(this.key, dest);
        }

        @Override
        public boolean maybeCollectKeysInto(ValueCollector<K> collector, Collection<K> dest) {
            if (this.providerOfValue.isPresent()) {
                collector.add(this.key, dest);
                return true;
            }
            return false;
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            return this.providerOfValue.maybeVisitBuildDependencies(context);
        }
    }

    public static class SingleEntry<K, V>
    implements MapCollector<K, V> {
        private final K key;
        private final V value;

        public SingleEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public boolean present() {
            return true;
        }

        @Override
        public void collectInto(MapEntryCollector<K, V> collector, Map<K, V> dest) {
            collector.add(this.key, this.value, dest);
        }

        @Override
        public boolean maybeCollectInto(MapEntryCollector<K, V> collector, Map<K, V> dest) {
            this.collectInto(collector, dest);
            return true;
        }

        @Override
        public void collectKeysInto(ValueCollector<K> collector, Collection<K> dest) {
            collector.add(this.key, dest);
        }

        @Override
        public boolean maybeCollectKeysInto(ValueCollector<K> collector, Collection<K> dest) {
            this.collectKeysInto(collector, dest);
            return true;
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SingleEntry that = (SingleEntry)o;
            return Objects.equal(this.key, that.key) && Objects.equal(this.value, that.value);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.key, this.value});
        }
    }

    public static class EmptyMap
    implements MapCollector<Object, Object> {
        @Override
        public boolean present() {
            return true;
        }

        @Override
        public void collectInto(MapEntryCollector<Object, Object> collector, Map<Object, Object> dest) {
        }

        @Override
        public boolean maybeCollectInto(MapEntryCollector<Object, Object> collector, Map<Object, Object> dest) {
            return true;
        }

        @Override
        public void collectKeysInto(ValueCollector<Object> collector, Collection<Object> dest) {
        }

        @Override
        public boolean maybeCollectKeysInto(ValueCollector<Object> collector, Collection<Object> dest) {
            return true;
        }

        @Override
        public boolean maybeVisitBuildDependencies(TaskDependencyResolveContext context) {
            return true;
        }
    }
}

