/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import org.gradle.api.internal.file.FileResolver;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilderFactory;
import org.gradle.buildinit.plugins.internal.CppProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.TemplateLibraryVersionProvider;
import org.gradle.buildinit.plugins.internal.TemplateOperation;
import org.gradle.buildinit.plugins.internal.TemplateOperationFactory;

public class CppApplicationProjectInitDescriptor
extends CppProjectInitDescriptor {
    public CppApplicationProjectInitDescriptor(BuildScriptBuilderFactory scriptBuilderFactory, TemplateOperationFactory templateOperationFactory, FileResolver fileResolver, TemplateLibraryVersionProvider libraryVersionProvider) {
        super(scriptBuilderFactory, templateOperationFactory, fileResolver, libraryVersionProvider);
    }

    @Override
    public String getId() {
        return "cpp-application";
    }

    @Override
    protected TemplateOperation sourceTemplateOperation(InitSettings settings) {
        return this.fromCppTemplate("cppapp/app.cpp.template", settings, "main", "cpp");
    }

    @Override
    protected TemplateOperation headerTemplateOperation(InitSettings settings) {
        return this.fromCppTemplate("cppapp/app.h.template", settings, "main", "headers");
    }

    @Override
    protected TemplateOperation testTemplateOperation(InitSettings settings) {
        return this.fromCppTemplate("cppapp/app_test.cpp.template", settings, "test", "cpp");
    }

    @Override
    protected void configureBuildScript(InitSettings settings, BuildScriptBuilder buildScriptBuilder) {
        buildScriptBuilder.plugin("Apply the cpp-application plugin to add support for building CPP executables", "cpp-application").plugin("Apply the cpp-unit-test plugin to add support for building and running CPP test executables", "cpp-unit-test").block("Set the target operating system and architecture for this application", "application").methodInvocation(null, "targetMachines.add", buildScriptBuilder.propertyExpression(this.getHostTargetMachineDefinition()));
    }
}

