/***********************************************************************
*                                                                      *
* This file is part of CARAT.                                          *
* Copyright (C) 2015  Tilman Schulz                                    *
*                                                                      *
* CARAT is free software: you can redistribute it and/or modify        *
* it under the terms of the GNU General Public License as published by *
* the Free Software Foundation, either version 3 of the License, or    *
* (at your option) any later version.                                  *
*                                                                      *
* This program is distributed in the hope that it will be useful,      *
* but WITHOUT ANY WARRANTY; without even the implied warranty of       *
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
* GNU General Public License for more details.                         *
*                                                                      *
* You should have received a copy of the GNU General Public License    *
* along with this program.  If not, see <http://www.gnu.org/licenses/> *
*                                                                      *
***********************************************************************/
#ifndef _ZZ_H
#define _ZZ_H

#include <stdlib.h>		/* for atoi */
#include "typedef.h"
#include "tools.h"
#include "matrix.h"
#include "getput.h"
#include "datei.h"

#undef ZZ_PRIVATE

#ifdef __STDC__
#include "../functions/ZZ/ZZ_P.h"





extern bravais_TYP **q2z(bravais_TYP *G,
                         int *number,
                         int ADFLAG,
                         QtoZ_TYP *INZ,
                         int quiet);

extern void free_QtoZ(QtoZ_TYP *inz,
                      int flag);

extern void *ZZ(bravais_TYP * group,
                     matrix_TYP * gram,
                     int *divisors,
	             QtoZ_TYP *inzidenz,
                     char *options,
                     FILE* outputfile,
                     int super_nr,
                     int konst_flag);

extern bravais_TYP **get_groups(bravais_TYP **ADGROUPS,
                         int ad_no,
                         int *number);


#else
extern ZZ_data_t ZZ ();

extern bravais_TYP **q2z();

extern bravais_TYP **get_groups();

extern void free_QtoZ();

#endif

extern int NUMBER;		/* Abbruch nach NUMBER Zentrierungen */
extern int LEVEL;		/* Abbruch nach Iterationszahl LEVEL */

#endif /* _ZZ_H */
