define(["layoutManager","playbackManager","userSettings","alphaPicker","connectionManager","focusManager","loading","globalize"],function(layoutManager,playbackManager,userSettings,AlphaPicker,connectionManager,focusManager,loading,globalize){"use strict";function initAlphaNumericShortcuts(instance){require(["alphaNumericShortcuts"],function(AlphaNumericShortcuts){instance.alphaNumericShortcuts=new AlphaNumericShortcuts({itemsContainer:instance.itemsContainer})})}function trySelectValue(instance,scroller,view,value){if(instance.enablePaging())return instance.startIndex=0,instance.scrollOnNextRefresh=!0,void instance.itemsContainer.refreshItems();var selectableItem;if("#"===value&&(selectableItem=view.querySelector(".card,.listItem")))return void(scroller?scroller.toStart(selectableItem,!1):(selectableItem.querySelector(".cardContent-button")||selectableItem).focus());if(selectableItem=view.querySelector("*[data-prefix^='"+value+"']"))return void(scroller?scroller.toStart(selectableItem,!1):(selectableItem.querySelector(".cardContent-button")||selectableItem).focus());var values=instance.alphaPicker.values(),index=values.indexOf(value);if(index<values.length-2)trySelectValue(instance,scroller,view,values[index+1]);else{var all=view.querySelectorAll(".card,.listItem");selectableItem=all.length?all[all.length-1]:null,selectableItem&&(scroller?scroller.toStart(selectableItem,!1):(selectableItem.querySelector(".cardContent-button")||selectableItem).focus())}}function page(offset){var startIndex=this.startIndex||0,newStartIndex=Math.max(0,startIndex+offset);newStartIndex!==startIndex&&(this.startIndex=newStartIndex,this.scrollOnNextRefresh=!0,this.itemsContainer.refreshItems())}function nextPage(){var instance=this;page.call(instance,100)}function previousPage(){var instance=this;page.call(instance,-100)}function onAlphaValueChanged(){var value=this.alphaPicker.value();trySelectValue(this,this.scroller,this.itemsContainer,value)}function initAlphaPicker(instance,view){instance.itemsContainer=view.querySelector(".itemsContainer"),instance.alphaPicker=new AlphaPicker({element:instance.alphaPickerElement,itemsContainer:instance.itemsContainer,itemClass:["card","listItem"],prefixes:instance.apiClient.isMinServerVersion("3.6.0.60")?[]:null}),instance.alphaPicker.on("alphavaluechanged",onAlphaValueChanged.bind(instance))}function showFilterMenu(){var instance=this;require(["filterMenu"],function(FilterMenu){(new FilterMenu).show({settingsKey:instance.getSettingsKey(),settings:instance.getFilters(),visibleSettings:instance.getVisibleFilters(),onChange:instance.itemsContainer.refreshItems.bind(instance.itemsContainer),parentId:instance.params.parentId,itemTypes:instance.getItemTypes?instance.getItemTypes():[],serverId:instance.apiClient.serverId(),filterMenuOptions:instance.getFilterMenuOptions()}).then(function(){refreshAfterSettingsChange(instance)})})}function updateAlphaPickerState(instance,numItems){if(instance.alphaPicker){var alphaPicker=instance.alphaPickerElement;if(alphaPicker){var values=instance.getSortValues();null==numItems&&(numItems=100);var elemWithPadding=instance.itemsContainer.classList.contains("padded-left")?instance.itemsContainer:instance.itemsContainer.parentNode;"SortName"===values.sortBy&&"Ascending"===values.sortOrder&&numItems>40?(alphaPicker.classList.remove("hide"),layoutManager.tv?(elemWithPadding.classList.remove("padded-right-withalphapicker"),elemWithPadding.classList.add("padded-left-withalphapicker"),alphaPicker.classList.add("alphaPicker-fixed-left"),alphaPicker.classList.remove("alphaPicker-fixed-right")):(elemWithPadding.classList.remove("padded-left-withalphapicker"),elemWithPadding.classList.add("padded-right-withalphapicker"),alphaPicker.classList.remove("alphaPicker-fixed-left"),alphaPicker.classList.add("alphaPicker-fixed-right")),instance.refreshPrefixes()):(alphaPicker.classList.add("hide"),elemWithPadding.classList.remove("padded-left-withalphapicker"),elemWithPadding.classList.remove("padded-right-withalphapicker"))}}}function showSortMenu(){var instance=this;require(["sortMenu"],function(SortMenu){(new SortMenu).show({settingsKey:instance.getSettingsKey(),settings:instance.getSortValues(),onChange:instance.itemsContainer.refreshItems.bind(instance.itemsContainer),serverId:instance.params.serverId,sortOptions:instance.getSortMenuOptions()}).then(function(){updateSortText(instance),refreshAfterSettingsChange(instance)})})}function showViewSettingsMenu(){var instance=this;require(["viewSettings"],function(ViewSettings){(new ViewSettings).show({settingsKey:instance.getSettingsKey(),settings:instance.getViewSettings(),visibleSettings:instance.getVisibleViewSettings()}).then(function(){updateItemsContainerForViewType(instance),refreshAfterSettingsChange(instance)})})}function refreshAfterSettingsChange(instance){instance.totalItemCount=null,instance.startIndex=0,instance.alphaPicker&&instance.enablePaging()&&instance.alphaPicker.value(null,!1),instance.scrollOnNextRefresh=!0,instance.itemsContainer.refreshItems()}function updateItemsContainerForViewType(instance){"list"===instance.getViewSettings().imageType?(instance.itemsContainer.classList.remove("vertical-wrap"),instance.itemsContainer.classList.add("vertical-list")):(instance.itemsContainer.classList.add("vertical-wrap"),instance.itemsContainer.classList.remove("vertical-list"))}function updateSortText(instance){var btnSortText=instance.btnSortText;if(btnSortText){for(var options=instance.getSortMenuOptions(),values=instance.getSortValues(),sortBy=values.sortBy,i=0,length=options.length;i<length;i++)if(sortBy===options[i].value){btnSortText.innerHTML=globalize.translate("sharedcomponents#SortByValue",options[i].name);break}var btnSortIcon=instance.btnSortIcon;btnSortIcon&&(btnSortIcon.innerHTML="Descending"===values.sortOrder?"&#xE5DB;":"&#xE5D8;")}}function bindAll(elems,eventName,fn){for(var i=0,length=elems.length;i<length;i++)elems[i].addEventListener(eventName,fn)}function play(){this.fetchData().then(function(result){playbackManager.play({items:result.Items||result})})}function shuffle(){this.fetchData().then(function(result){playbackManager.play({items:result.Items||result})})}function hideOrShowAll(elems,hide){for(var i=0,length=elems.length;i<length;i++)hide?elems[i].classList.add("hide"):elems[i].classList.remove("hide")}function afterRefresh(result){this.enablePaging()&&this.scrollOnNextRefresh&&window.scrollTo(0,0),this.scrollOnNextRefresh=!1,null==this.totalItemCount&&(null!=result.TotalRecordCount?this.totalItemCount=result.TotalRecordCount:this.totalItemCount=result.Items?result.Items.length:result.length),updateAlphaPickerState(this,this.totalItemCount);var i,length,startIndex=this.startIndex||0,previousPageButtons=this.previousPageButtons;for(i=0,length=previousPageButtons.length;i<length;i++)previousPageButtons[i].disabled=startIndex<=0;var totalRecordCount=result.TotalRecordCount;if(null!=totalRecordCount){var nextPageButtons=this.nextPageButtons;for(i=0,length=nextPageButtons.length;i<length;i++)nextPageButtons[i].disabled=startIndex+100>totalRecordCount}}function ItemsTab(view,params){this.view=view,this.params=params,params.serverId&&(this.apiClient=connectionManager.getApiClient(params.serverId)),this.itemsContainer=view.querySelector(".itemsContainer"),this.scroller=view.querySelector(".scrollFrameY"),this.itemsContainer.fetchData=this.fetchData.bind(this),this.itemsContainer.getItemsHtml=this.getItemsHtml.bind(this),this.itemsContainer.afterRefresh=afterRefresh.bind(this),params.parentId&&this.itemsContainer.setAttribute("data-parentid",params.parentId);var i,length,btnViewSettings=view.querySelectorAll(".btnViewSettings");for(i=0,length=btnViewSettings.length;i<length;i++)btnViewSettings[i].addEventListener("click",showViewSettingsMenu.bind(this));var filterButtons=view.querySelectorAll(".btnFilter");this.filterButtons=filterButtons;var hasVisibleFilters=this.getVisibleFilters().length;for(i=0,length=filterButtons.length;i<length;i++){var btnFilter=filterButtons[i];btnFilter.addEventListener("click",showFilterMenu.bind(this)),hasVisibleFilters?btnFilter.classList.remove("hide"):btnFilter.classList.add("hide")}var nextPageButtons=view.querySelectorAll(".btnNextPage");for(this.nextPageButtons=nextPageButtons,i=0,length=nextPageButtons.length;i<length;i++)nextPageButtons[i].addEventListener("click",nextPage.bind(this));var previousPageButtons=view.querySelectorAll(".btnPreviousPage");for(this.previousPageButtons=previousPageButtons,i=0,length=previousPageButtons.length;i<length;i++)previousPageButtons[i].addEventListener("click",previousPage.bind(this));var sortButtons=view.querySelectorAll(".btnSort");for(this.sortButtons=sortButtons,i=0,length=sortButtons.length;i<length;i++){var sortButton=sortButtons[i];sortButton.addEventListener("click",showSortMenu.bind(this)),"nextup"!==params.type&&sortButton.classList.remove("hide")}this.btnSortText=view.querySelector(".btnSortText"),this.btnSortIcon=view.querySelector(".btnSortIcon"),this.enableAlphaNumericShortcuts="true"===this.itemsContainer.getAttribute("data-alphanumericshortcuts")&&!layoutManager.mobile&&!this.enablePaging(),this.alphaPickerElement=view.querySelector(".alphaPicker"),hideOrShowAll(view.querySelectorAll(".btnShuffle"),!0),bindAll(view.querySelectorAll(".btnPlay"),"click",play.bind(this)),bindAll(view.querySelectorAll(".btnShuffle"),"click",shuffle.bind(this)),this.scrollOnNextRefresh=!0}function compareByName(a,b){return a.name<b.name?-1:a.name>b.name?1:0}return ItemsTab.prototype.refreshPrefixes=function(){var instance=this;instance.prefixesLoaded||this.getPrefixes().then(function(prefixes){instance.prefixesLoaded=!0,instance.alphaPicker.setPrefixes(prefixes)})},ItemsTab.prototype.getPrefixes=function(){var queryInfo=this.getQueryInfo(!1),apiClient=this.apiClient,query=queryInfo.query;return query.SortBy=null,query.SortOrder=null,query.StartIndex=null,query.Limit=null,query.Fields=null,query.EnableImageTypes=null,query.ImageTypeLimit=null,query.NameStartsWithOrGreater=null,query.IncludeItemTypes=this.getPrefixQueryIncludeItemTypes().join(","),apiClient.getPrefixes(apiClient.getCurrentUserId(),query).then(function(result){return result.map(function(i){return i.Name})})},ItemsTab.prototype.getPrefixQueryIncludeItemTypes=function(){return this.getQueryIncludeItemTypes()},ItemsTab.prototype.getQueryIncludeItemTypes=function(){return this.getItemTypes()},ItemsTab.prototype.getBaseQuery=function(){var parentId=this.params.parentId,sortValues=this.getSortValues(),fields="BasicSyncInfo,MediaSourceCount";layoutManager.mobile||(fields+=",SortName"),"primary"===this.getViewSettings().imageType&&(fields+=",PrimaryImageAspectRatio");var query={SortBy:sortValues.sortBy,SortOrder:sortValues.sortOrder,IncludeItemTypes:this.getQueryIncludeItemTypes().join(","),Recursive:!0,Fields:fields,ImageTypeLimit:1,EnableImageTypes:"Primary,Backdrop,Banner,Thumb,Disc,Logo",StartIndex:this.startIndex||0,Limit:this.enablePaging()?100:null,ParentId:parentId},alphaPicker=this.alphaPicker;return alphaPicker&&(query.NameStartsWithOrGreater=alphaPicker.value()),query},ItemsTab.prototype.getQueryInfo=function(enableFilters){var hasFilters,query=this.getBaseQuery(),queryFilters=[];if("unwatched"===this.mode?queryFilters.push("IsUnplayed"):"favorites"===this.mode&&queryFilters.push("IsFavorite"),!1!==enableFilters){var filters=this.getFilters();filters.SeriesStatus&&(query.SeriesStatus=filters.SeriesStatus,hasFilters=!0),filters.IsPlayed&&(queryFilters.push("IsPlayed"),hasFilters=!0),filters.IsUnplayed&&(queryFilters.push("IsUnplayed"),hasFilters=!0),filters.IsFavorite&&(queryFilters.push("IsFavorite"),hasFilters=!0),filters.IsResumable&&(queryFilters.push("IsResumable"),hasFilters=!0),filters.Containers&&(hasFilters=!0,query.Containers=filters.Containers),filters.AudioCodecs&&(hasFilters=!0,query.AudioCodecs=filters.AudioCodecs),filters.VideoCodecs&&(hasFilters=!0,query.VideoCodecs=filters.VideoCodecs),filters.SubtitleCodecs&&(hasFilters=!0,query.SubtitleCodecs=filters.SubtitleCodecs),filters.GenreIds&&(hasFilters=!0,query.GenreIds=filters.GenreIds),filters.OfficialRatings&&(hasFilters=!0,query.OfficialRatings=filters.OfficialRatings),filters.StudioIds&&(hasFilters=!0,query.StudioIds=filters.StudioIds),filters.Tags&&(hasFilters=!0,query.Tags=filters.Tags),filters.Years&&(hasFilters=!0,query.Years=filters.Years),filters.Is4K&&(query.Is4K=!0,hasFilters=!0),filters.IsHD&&(query.IsHD=!0,hasFilters=!0),filters.IsSD&&(query.IsHD=!1,hasFilters=!0),filters.Is3D&&(query.Is3D=!0,hasFilters=!0),filters.HasSubtitles&&(query.HasSubtitles=!0,hasFilters=!0),filters.HasTrailer&&(query.HasTrailer=!0,hasFilters=!0),filters.HasSpecialFeature&&(query.HasSpecialFeature=!0,hasFilters=!0),filters.HasThemeSong&&(query.HasThemeSong=!0,hasFilters=!0),filters.HasThemeVideo&&(query.HasThemeVideo=!0,hasFilters=!0)}return query.Filters=queryFilters.length?queryFilters.join(","):null,this.getViewSettings().groupItemsIntoCollections&&(query.GroupItemsIntoCollections=!0),{query:query,hasFilters:hasFilters}},ItemsTab.prototype.fetchData=function(){var queryInfo=this.getQueryInfo();this.setFilterStatus(queryInfo.hasFilters);var apiClient=this.apiClient;return apiClient.getItems(apiClient.getCurrentUserId(),queryInfo.query)},ItemsTab.prototype.getViewSettings=function(){var basekey=this.getSettingsKey();return{showTitle:"false"!==userSettings.get(basekey+"-showTitle"),showYear:"false"!==userSettings.get(basekey+"-showYear"),groupItemsIntoCollections:"true"===userSettings.get(basekey+"-groupItemsIntoCollections"),imageType:userSettings.get(basekey+"-imageType")||this.getDefaultImageType()}},ItemsTab.prototype.getDefaultImageType=function(){return"primary"},ItemsTab.prototype.getSettingsKey=function(){return this.params.parentId+"-1"},ItemsTab.prototype.onResume=function(options){options&&options.refresh&&(updateSortText(this),updateItemsContainerForViewType(this),loading.show());var view=this.view,scroller=this.scroller;scroller&&scroller.resume&&scroller.resume();var itemsContainer=this.itemsContainer;itemsContainer&&itemsContainer.resume&&itemsContainer.resume(),this.enableAlphaPicker&&!this.alphaPicker&&initAlphaPicker(this,view),this.enableAlphaNumericShortcuts&&initAlphaNumericShortcuts(this);var instance=this,autoFocus=options.autoFocus;this.itemsContainer.resume(options).then(function(result){loading.hide(),autoFocus&&focusManager.autoFocus(instance.itemsContainer)})},ItemsTab.prototype.refresh=function(options){loading.show();var instance=this,autoFocus=options.autoFocus;this.itemsContainer.refreshItems(options).then(function(result){loading.hide(),autoFocus&&focusManager.autoFocus(instance.itemsContainer)})},ItemsTab.prototype.getVisibleViewSettings=function(){return["showTitle","showYear","imageType"]},ItemsTab.prototype.getFilters=function(){var basekey=this.getSettingsKey();return{IsPlayed:"true"===userSettings.getFilter(basekey+"-filter-IsPlayed"),IsUnplayed:"true"===userSettings.getFilter(basekey+"-filter-IsUnplayed"),IsFavorite:"true"===userSettings.getFilter(basekey+"-filter-IsFavorite"),IsResumable:"true"===userSettings.getFilter(basekey+"-filter-IsResumable"),Is4K:"true"===userSettings.getFilter(basekey+"-filter-Is4K"),IsHD:"true"===userSettings.getFilter(basekey+"-filter-IsHD"),IsSD:"true"===userSettings.getFilter(basekey+"-filter-IsSD"),Is3D:"true"===userSettings.getFilter(basekey+"-filter-Is3D"),VideoTypes:userSettings.getFilter(basekey+"-filter-VideoTypes"),SeriesStatus:userSettings.getFilter(basekey+"-filter-SeriesStatus"),HasSubtitles:userSettings.getFilter(basekey+"-filter-HasSubtitles"),HasTrailer:userSettings.getFilter(basekey+"-filter-HasTrailer"),HasSpecialFeature:userSettings.getFilter(basekey+"-filter-HasSpecialFeature"),HasThemeSong:userSettings.getFilter(basekey+"-filter-HasThemeSong"),HasThemeVideo:userSettings.getFilter(basekey+"-filter-HasThemeVideo"),GenreIds:userSettings.getFilter(basekey+"-filter-GenreIds"),StudioIds:userSettings.getFilter(basekey+"-filter-StudioIds"),Tags:userSettings.getFilter(basekey+"-filter-Tags"),Containers:userSettings.getFilter(basekey+"-filter-Containers"),AudioCodecs:userSettings.getFilter(basekey+"-filter-AudioCodecs"),VideoCodecs:userSettings.getFilter(basekey+"-filter-VideoCodecs"),SubtitleCodecs:userSettings.getFilter(basekey+"-filter-SubtitleCodecs"),OfficialRatings:userSettings.getFilter(basekey+"-filter-OfficialRatings"),Years:userSettings.getFilter(basekey+"-filter-Years")}},ItemsTab.prototype.getSortValues=function(){var basekey=this.getSettingsKey();return{sortBy:userSettings.getFilter(basekey+"-sortby")||this.getDefaultSortBy(),sortOrder:"Descending"===userSettings.getFilter(basekey+"-sortorder")?"Descending":"Ascending"}},ItemsTab.prototype.getVisibleFilters=function(){return[]},ItemsTab.prototype.getDefaultSortBy=function(){return"SortName"},ItemsTab.prototype.sortOptionsByName=function(options){options.sort(compareByName)},ItemsTab.prototype.getSortMenuOptions=function(){var sortBy=[],option=this.getNameSortOption();return option&&sortBy.push(option),option=this.getFolderSortOption(),option&&sortBy.push(option),option=this.getCommunityRatingSortOption(),option&&sortBy.push(option),option=this.getCriticRatingSortOption(),option&&sortBy.push(option),sortBy.push({name:globalize.translate("sharedcomponents#DateAdded"),value:"DateCreated,SortName"}),option=this.getDatePlayedSortOption(),option&&sortBy.push(option),sortBy.push({name:globalize.translate("sharedcomponents#ParentalRating"),value:"OfficialRating,SortName"}),option=this.getPlayCountSortOption(),option&&sortBy.push(option),sortBy.push({name:globalize.translate("sharedcomponents#ReleaseDate"),value:"PremiereDate,ProductionYear,SortName"}),sortBy.push({name:globalize.translate("sharedcomponents#Runtime"),value:"Runtime,SortName"}),this.sortOptionsByName(sortBy),sortBy},ItemsTab.prototype.getNameSortOption=function(){return{name:globalize.translate("sharedcomponents#Name"),value:"SortName"}},ItemsTab.prototype.getFolderSortOption=function(){return null},ItemsTab.prototype.getPlayCountSortOption=function(){return{name:globalize.translate("sharedcomponents#PlayCount"),value:"PlayCount,SortName"}},ItemsTab.prototype.getDatePlayedSortOption=function(){return{name:globalize.translate("sharedcomponents#DatePlayed"),value:"DatePlayed,SortName"}},ItemsTab.prototype.getCriticRatingSortOption=function(){return{name:globalize.translate("sharedcomponents#CriticRating"),value:"CriticRating,SortName"}},ItemsTab.prototype.enablePaging=function(){return this.nextPageButtons.length},ItemsTab.prototype.getCommunityRatingSortOption=function(){return{name:globalize.translate("sharedcomponents#CommunityRating"),value:"CommunityRating,SortName"}},ItemsTab.prototype.getFilterMenuOptions=function(){this.params;return{}},ItemsTab.prototype.getItemTypes=function(){return[]},ItemsTab.prototype.setFilterStatus=function(hasFilters){this.hasFilters=hasFilters;var filterButtons=this.filterButtons;if(filterButtons.length)for(var i=0,length=filterButtons.length;i<length;i++){var btnFilter=filterButtons[i],bubble=btnFilter.querySelector(".filterButtonBubble");if(!bubble){if(!hasFilters)continue;btnFilter.insertAdjacentHTML("afterbegin",'<div class="filterButtonBubble">!</div>'),btnFilter.classList.add("btnFilterWithBubble"),bubble=btnFilter.querySelector(".filterButtonBubble")}hasFilters?bubble.classList.remove("hide"):bubble.classList.add("hide")}},ItemsTab.prototype.onPause=function(){var scroller=this.scroller;scroller&&scroller.pause&&scroller.pause();var itemsContainer=this.itemsContainer;itemsContainer&&itemsContainer.pause&&itemsContainer.pause();var alphaNumericShortcuts=this.alphaNumericShortcuts;alphaNumericShortcuts&&(alphaNumericShortcuts.destroy(),this.alphaNumericShortcuts=null)},ItemsTab.prototype.destroy=function(){this.view=null,this.itemsContainer=null,this.params=null,this.apiClient=null,this.scroller=null,this.filterButtons=null,this.nextPageButtons=null,this.previousPageButtons=null,this.alphaPicker&&(this.alphaPicker.destroy(),this.alphaPicker=null),this.sortButtons=null,this.btnSortText=null,this.btnSortIcon=null,this.alphaPickerElement=null,this.startIndex=null,this.prefixesLoaded=null,this.totalItemCount=null,this.scrollOnNextRefresh=null},ItemsTab});