define([],function(){"use strict";function addObject(db,key,val,storeName){return new Promise(function(resolve,reject){var objectStore=getStore(db,storeName,"readwrite"),request=objectStore.put(val,key);request.onerror=reject,request.onsuccess=resolve})}function updateObject(db,key,val,storeName){return new Promise(function(resolve,reject){var objectStore=getStore(db,storeName,"readwrite"),request=objectStore.put(val,key);request.onerror=reject,request.onsuccess=function(){resolve(request.result)}})}function deleteObject(db,key,storeName){return new Promise(function(resolve,reject){var objectStore=getStore(db,storeName,"readwrite"),request=objectStore.delete(key);request.onerror=reject,request.onsuccess=resolve})}function clearObjects(db,storeName){return new Promise(function(resolve,reject){var objectStore=getStore(db,storeName,"readwrite"),request=objectStore.clear();request.onerror=reject,request.onsuccess=resolve})}function getAllObjects(db,storeName){return new Promise(function(resolve,reject){var request,objectStore=getStore(db,storeName);if("function"==typeof objectStore.getAll)request=objectStore.getAll(),request.onsuccess=function(event){resolve(event.target.result)};else{var results=[];request=objectStore.openCursor(),request.onsuccess=function(event){var cursor=event.target.result;cursor?(results.push(cursor.value),cursor.continue()):resolve(results)}}request.onerror=reject})}function getObjectByKey(db,key,storeName){return new Promise(function(resolve,reject){var objectStore=getStore(db,storeName),request=objectStore.get(key);request.onerror=reject,request.onsuccess=function(){resolve(request.result)}})}function getObjectsByKeys(db,keys,storeName){if(!Array.isArray(keys)||1===keys.length){return getObjectByKey(db,Array.isArray(keys)?keys[0]:keys,storeName)}return keys.length>4?getObjectsByKeysSequentialSeek(db,keys,storeName):getObjectsByKeysParallelLookup(db,keys,storeName)}function getObjectsByKeysParallelLookup(db,keys,storeName){var actions=keys.map(function(key){return getObjectByKey(db,key,storeName)});return Promise.all(actions).then(function(results){var flattened=results.reduce(function(acc,val){return acc.concat(val)},[]);return Promise.resolve(flattened)})}function getObjectsByKeysSequentialSeek(db,keys,storeName){return new Promise(function(resolve,reject){var objectStore=getStore(db,storeName),set=keys.slice(0);set.sort(function(a,b){return indexedDB.cmp(a,b)});var i=0,range=IDBKeyRange.bound(set[0],set[set.length-1]),results=[],request=objectStore.openCursor(range);request.onsuccess=function(event){var cursor=event.target.result;if(!cursor)return void resolve(results);for(var key=cursor.key;indexedDB.cmp(key,set[i])>0;)if(++i===set.length)return void resolve(results);key===set[i]?(results.push(cursor.value),cursor.continue()):cursor.continue(set[i])},request.onerror=reject})}function getObjectsByIndexKeys(db,indexName,keys,storeName){if(!Array.isArray(keys)||1===keys.length){return getObjectsBySingleIndexKey(db,indexName,Array.isArray(keys)?keys[0]:keys,storeName)}return keys.length>4?getObjectsByIndexKeysSequentialSeek(db,indexName,keys,storeName):getObjectsByIndexKeysParallelLookup(db,indexName,keys,storeName)}function getObjectsByIndexKeysParallelLookup(db,indexName,keys,storeName){var actions=keys.map(function(key){return getObjectsBySingleIndexKey(db,indexName,key,storeName)});return Promise.all(actions).then(function(results){var flattened=results.reduce(function(acc,val){return acc.concat(val)},[]);return Promise.resolve(flattened)})}function getObjectsBySingleIndexKey(db,indexName,key,storeName){return new Promise(function(resolve,reject){storeName=storeName||db.name;var request,transaction=db.transaction([storeName],"readonly"),objectStore=transaction.objectStore(storeName),index=objectStore.index(indexName);if("function"==typeof index.getAll)request=index.getAll(key),request.onsuccess=function(event){resolve(event.target.result)};else{var results=[];request=index.openCursor(key),request.onsuccess=function(event){var cursor=event.target.result;cursor?(results.push(cursor.value),cursor.continue()):resolve(results)}}request.onerror=reject})}function getObjectsByIndexKeysSequentialSeek(db,indexName,keys,storeName){return new Promise(function(resolve,reject){var objectStore=getStore(db,storeName),index=objectStore.index(indexName),set=keys.slice(0);set.sort(function(a,b){return indexedDB.cmp(a,b)});var i=0,range=IDBKeyRange.bound(set[0],set[set.length-1]),results=[],request=index.openCursor(range);request.onsuccess=function(event){var cursor=event.target.result;if(!cursor)return void resolve(results);for(var key=cursor.key;indexedDB.cmp(key,set[i])>0;)if(++i===set.length)return void resolve(results);key===set[i]?(results.push(cursor.value),cursor.continue()):cursor.continue(set[i])},request.onerror=reject})}function getDistinctndexKeys(db,indexName,storeName){return new Promise(function(resolve,reject){var objectStore=getStore(db,storeName),index=objectStore.index(indexName),results=[],request=index.openKeyCursor(null,"nextunique");request.onsuccess=function(event){var cursor=event.target.result;cursor?(results.push(cursor.key),cursor.continue()):resolve(results)},request.onerror=reject})}function getStore(db,storeName,access){return storeName=storeName||db.name,access=access||"readonly",db.transaction(storeName,access).objectStore(storeName)}var indexedDB=self.indexedDB;return{addObject:addObject,updateObject:updateObject,deleteObject:deleteObject,clearObjects:clearObjects,getAllObjects:getAllObjects,getObjectByKey:getObjectByKey,getObjectsByKeys:getObjectsByKeys,getObjectsByIndexKeys:getObjectsByIndexKeys,getDistinctndexKeys:getDistinctndexKeys}});