/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.routineeditor.result;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.datatools.sqltools.core.DBHelper;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.ISqlDataValidator;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.dbitem.ParameterDescriptor;
import org.eclipse.datatools.sqltools.core.profile.NoSuchProfileException;
import org.eclipse.datatools.sqltools.core.profile.ProfileUtil;
import org.eclipse.datatools.sqltools.editor.core.connection.IConnectionTracker;
import org.eclipse.datatools.sqltools.editor.core.result.ResultSupportRunnable;
import org.eclipse.datatools.sqltools.result.OperationCommand;
import org.eclipse.datatools.sqltools.result.Parameter;
import org.eclipse.datatools.sqltools.routineeditor.internal.RoutineEditorActivator;
import org.eclipse.datatools.sqltools.routineeditor.internal.result.Messages;
import org.eclipse.datatools.sqltools.routineeditor.launching.LaunchHelper;
import org.eclipse.datatools.sqltools.routineeditor.parameter.ParameterInOutWrapper;
import org.eclipse.datatools.sqltools.sql.util.SQLUtil;
import org.eclipse.debug.core.ILaunchConfiguration;

public class CallableSQLResultRunnable
extends ResultSupportRunnable {
    protected Connection _connection;
    protected String _sql;
    protected String _detailSql;
    protected boolean _closeCon;
    protected IConnectionTracker _tracker;
    protected ILaunchConfiguration _configuration;
    protected ParameterInOutWrapper[] _pws;
    protected String _procName;

    public CallableSQLResultRunnable(Connection con, ILaunchConfiguration configuration, boolean closeCon, IConnectionTracker tracker, DatabaseIdentifier databaseIdentifier) throws CoreException, SQLException, NoSuchProfileException {
        super(null, null, databaseIdentifier);
        this._connection = con;
        this._configuration = configuration;
        this._sql = LaunchHelper.constructCallableStatementSQLString(configuration);
        this._detailSql = LaunchHelper.constructCallableStatementDisplayString(configuration);
        this._closeCon = closeCon;
        this._tracker = tracker;
    }

    protected Connection getConnection() {
        return this._connection;
    }

    protected OperationCommand createDefaultOperationCommand() {
        return new OperationCommand(this.getActionType(), this._detailSql, this.getConsumerName(), this._databaseIdentifier.getProfileName(), this._databaseIdentifier.getDBname());
    }

    public String getConsumerName() {
        if (this._consumerName == null) {
            this._consumerName = "";
        }
        return this._consumerName;
    }

    protected void getStatementOutParam(Statement stmt, ParameterInOutWrapper[] pws) {
        if (!(stmt instanceof CallableStatement)) {
            return;
        }
        CallableStatement cstmt = (CallableStatement)stmt;
        if (cstmt == null || pws == null) {
            return;
        }
        int j = 0;
        int i = 0;
        while (i < pws.length) {
            pws[i].getParameterDescriptor().getSqlDataType();
            int paramType = pws[i].getParameterDescriptor().getParmType();
            String name = pws[i].getParameterDescriptor().getName();
            if (paramType == 1) {
                ++j;
            } else if (paramType == 5 || paramType == 4 || paramType == 2) {
                if (name.equals(this._procName)) {
                    pws[i].setOutValue(pws[0].getOutValue());
                } else {
                    ++j;
                    try {
                        String outValue = "0x";
                        Object o = cstmt.getObject(j);
                        if (o != null) {
                            if (o instanceof byte[]) {
                                byte[] os = (byte[])o;
                                outValue = SQLUtil.toHexString((byte[])os);
                            } else {
                                outValue = o.toString();
                            }
                        }
                        pws[i].setOutValue(outValue);
                    }
                    catch (SQLException e1) {
                        RoutineEditorActivator.getDefault().log("", e1);
                    }
                    catch (NumberFormatException e1) {
                        RoutineEditorActivator.getDefault().log("", e1);
                    }
                }
            }
            ++i;
        }
    }

    protected void registerOutParameter(Statement stmt, ParameterInOutWrapper[] pws) throws SQLException {
        if (!(stmt instanceof CallableStatement)) {
            return;
        }
        CallableStatement cstmt = (CallableStatement)stmt;
        if (cstmt == null || pws == null) {
            return;
        }
        int j = 0;
        int returnParamIndex = this._sql.indexOf("{?");
        if (returnParamIndex >= 0) {
            ++j;
        }
        int i = 0;
        while (i < pws.length) {
            int sqlType = pws[i].getParameterDescriptor().getSqlDataType();
            pws[i].getParameterDescriptor().getTypeName();
            int paramType = pws[i].getParameterDescriptor().getParmType();
            pws[i].getParameterDescriptor().getParamTypeAsString();
            String name = pws[i].getParameterDescriptor().getName();
            if (paramType == 1) {
                ++j;
            } else if (paramType == 5 && returnParamIndex >= 0) {
                cstmt.registerOutParameter(1, sqlType);
            } else if (!(paramType != 0 && paramType != 4 && paramType != 2 || name.equals(this._procName))) {
                cstmt.registerOutParameter(++j, sqlType);
            }
            ++i;
        }
    }

    protected void setInParameter(Statement stmt, ParameterInOutWrapper[] pws) throws SQLException {
        if (!(stmt instanceof CallableStatement)) {
            return;
        }
        CallableStatement cstmt = (CallableStatement)stmt;
        if (cstmt == null || pws == null) {
            return;
        }
        int j = 0;
        int returnParamIndex = this._sql.indexOf("{?");
        if (returnParamIndex >= 0) {
            ++j;
        }
        int k = 0;
        List values = null;
        try {
            values = LaunchHelper.readParameterList(this._configuration);
        }
        catch (CoreException e) {
            RoutineEditorActivator.getDefault().log(e);
        }
        DBHelper helper = SQLToolsFacade.getConfiguration(null, (DatabaseIdentifier)this.getDatabaseIdentifier()).getDBHelper();
        int i = 0;
        while (i < pws.length) {
            int sqlType = pws[i].getParameterDescriptor().getSqlDataType();
            int paramType = pws[i].getParameterDescriptor().getParmType();
            if (helper != null) {
                paramType = helper.getCorrectParamType(paramType);
            }
            pws[i].getParameterDescriptor().getParamTypeAsString();
            pws[i].getParameterDescriptor().getName();
            if (paramType != 5) {
                if (paramType == 4 || paramType == 5) {
                    ++j;
                } else if (paramType == 1 || paramType == 2) {
                    ++j;
                    String value = null;
                    if (values != null && k < values.size()) {
                        value = (String)values.get(k++);
                    }
                    pws[i].setInValue(value);
                    if (value == null) {
                        cstmt.setNull(j, sqlType);
                    } else {
                        Object v = null;
                        try {
                            ISqlDataValidator validator = SQLToolsFacade.getConfiguration(null, (DatabaseIdentifier)this.getDatabaseIdentifier()).getSQLDataService().getSQLDataValidator(this.getDatabaseIdentifier());
                            v = validator.convert(pws[i].getParameterDescriptor().getTypeName(), value, this.getDatabaseIdentifier().getProfileName(), this.getDatabaseIdentifier().getDBname());
                        }
                        catch (Exception exception) {
                            v = value;
                        }
                        try {
                            cstmt.setObject(j, v, sqlType);
                        }
                        catch (Exception exception) {
                            cstmt.setObject(j, v);
                        }
                    }
                }
            }
            ++i;
        }
    }

    protected Statement prepareStatement(Connection connection) throws SQLException {
        CallableStatement cstmt = connection.prepareCall(this._sql);
        if (this._configuration != null) {
            try {
                ProcIdentifier proc = LaunchHelper.readProcIdentifier(this._configuration);
                if (proc != null) {
                    this._procName = proc.getProcName();
                    this._pws = LaunchHelper.getAllParameterWrappersByOrder(proc);
                    this.setInParameter(cstmt, this._pws);
                    this.registerOutParameter(cstmt, this._pws);
                }
            }
            catch (NoSuchProfileException e1) {
                RoutineEditorActivator.getDefault().log("", e1);
            }
            catch (CoreException e) {
                RoutineEditorActivator.getDefault().log("", e);
            }
        }
        return cstmt;
    }

    protected boolean runStatement(Statement stmt) throws SQLException {
        if (stmt != null && stmt instanceof CallableStatement) {
            CallableStatement cstmt = (CallableStatement)stmt;
            return cstmt.execute();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean handleSuccess(boolean moreResult) {
        boolean success = super.handleSuccess(moreResult);
        if (this._pws != null) {
            this.getStatementOutParam(this._stmt, this._pws);
            OperationCommand operationCommand = this.getOperationCommand();
            synchronized (operationCommand) {
                this.resultsViewAPI.appendStatusMessage(this.getOperationCommand(), this.getReturnStatusString());
                this.resultsViewAPI.showParameters(this.getOperationCommand(), this.convert(this._pws));
            }
        }
        return success;
    }

    protected String getReturnStatusString() {
        StringBuffer buffer = new StringBuffer("");
        int i = 0;
        while (i < this._pws.length) {
            int paramType = this._pws[i].getParameterDescriptor().getParmType();
            this._pws[i].getParameterDescriptor().getName();
            String outValue = this._pws[i].getOutValue();
            if (paramType == 5) {
                buffer.append(Messages.bind((String)Messages.CallableSQLResultRunnable_return_status, (Object)outValue));
            }
            ++i;
        }
        return buffer.toString();
    }

    private List convert(ParameterInOutWrapper[] pws) {
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        int i = 0;
        while (i < pws.length) {
            ParameterDescriptor pd = pws[i].getParameterDescriptor();
            if (pd.getParmType() != 3 && pd.getParmType() != 5) {
                Parameter param = new Parameter(pd.getName(), pd.getParamTypeAsString(), pws[i].getInValue(), pd.getTypeName(), pws[i].getOutValue());
                params.add(param);
            }
            ++i;
        }
        return params;
    }

    protected void handleEnd(Connection connection, Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
            if (connection != null && !this.isTerminated() && !this.isCanceled() && this._closeCon) {
                ProfileUtil.closeConnection((String)this._databaseIdentifier.getProfileName(), (String)this._databaseIdentifier.getDBname(), (Connection)connection);
            }
        }
        catch (Exception exception) {}
        if (this._closeCon && this._tracker != null) {
            this._tracker.connectionClosed();
        }
    }

    public static char byteToChar(byte[] b) {
        int s = 0;
        s = b[0] > 0 ? (s += b[0]) : (s += 256 + b[0]);
        s *= 256;
        s = b[1] > 0 ? (s += b[1]) : (s += 256 + b[1]);
        char ch = (char)s;
        return ch;
    }

    public ILaunchConfiguration getConfiguration() {
        return this._configuration;
    }
}

