/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.hierarchy;

import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryField;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryNestedType;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryType;

public class HierarchyBinaryType
implements IBinaryType {
    private int modifiers;
    private char[] sourceName;
    private char[] name;
    private char[] enclosingTypeName;
    private char[] superclass;
    private char[] genericSignature;

    public HierarchyBinaryType(int modifiers, char[] qualification, char[] sourceName, char[] enclosingTypeName) {
        this.modifiers = modifiers;
        this.sourceName = sourceName;
        if (enclosingTypeName == null) {
            this.name = CharOperation.concat(qualification, sourceName, '/');
        } else {
            this.name = CharOperation.concat(qualification, '/', enclosingTypeName, '$', sourceName);
            this.enclosingTypeName = CharOperation.concat(qualification, enclosingTypeName, '/');
            CharOperation.replace(this.enclosingTypeName, '.', '/');
        }
        CharOperation.replace(this.name, '.', '/');
    }

    @Override
    public char[] getEnclosingTypeName() {
        return this.enclosingTypeName;
    }

    @Override
    public IBinaryField[] getFields() {
        return null;
    }

    @Override
    public char[] getFileName() {
        return null;
    }

    @Override
    public char[] getGenericSignature() {
        return this.genericSignature;
    }

    @Override
    public IBinaryNestedType[] getMemberTypes() {
        return null;
    }

    @Override
    public IBinaryMethod[] getMethods() {
        return null;
    }

    @Override
    public int getModifiers() {
        return this.modifiers;
    }

    @Override
    public char[] getName() {
        return this.name;
    }

    @Override
    public char[] getSourceName() {
        return this.sourceName;
    }

    @Override
    public char[] getSuperclassName() {
        return this.superclass;
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    @Override
    public boolean isBinaryType() {
        return true;
    }

    @Override
    public boolean isLocal() {
        return false;
    }

    @Override
    public boolean isMember() {
        return false;
    }

    public void recordSuperType(char[] superTypeName, char[] superQualification) {
        int length;
        if (superQualification != null && superQualification.length > 0 && superQualification[(length = superQualification.length) - 1] == '$') {
            char[] enclosingSuperName = CharOperation.lastSegment(superQualification, '.');
            superTypeName = CharOperation.concat(enclosingSuperName, superTypeName);
            superQualification = CharOperation.subarray(superQualification, 0, length - enclosingSuperName.length - 1);
        }
        char[] encodedName = CharOperation.concat(superQualification, superTypeName, '/');
        CharOperation.replace(encodedName, '.', '/');
        this.superclass = encodedName;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.modifiers == 1) {
            buffer.append("public ");
        }
        switch (TypeDeclaration.kind(this.modifiers)) {
            case 1: {
                buffer.append("class ");
            }
        }
        if (this.name != null) {
            buffer.append(this.name);
        }
        if (this.superclass != null) {
            buffer.append("\n  extends ");
            buffer.append(this.superclass);
        }
        return buffer.toString();
    }

    @Override
    public char[] sourceFileName() {
        return null;
    }

    @Override
    public long getTagBits() {
        return 0L;
    }
}

