/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.result;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.datatools.sqltools.result.ClassVersionIncompatibleException;
import org.eclipse.datatools.sqltools.result.OperationCommand;
import org.eclipse.datatools.sqltools.result.core.IResultManagerListener;
import org.eclipse.datatools.sqltools.result.internal.core.IResultManager;
import org.eclipse.datatools.sqltools.result.internal.utils.SerializationHelper;
import org.eclipse.datatools.sqltools.result.model.IResultInstance;
import org.eclipse.datatools.sqltools.result.model.ResultItem;

public class ResultManager
implements IResultManager {
    private static final long serialVersionUID = -344302636933874156L;
    private transient ListenerList _listeners = new ListenerList();
    private static transient String _ClassVersionID = SerializationHelper.getResultManagerVersion();
    private Map _operationInstanceMap = new Hashtable();
    private List _results = new Vector();

    protected ResultManager() {
    }

    @Override
    public void addResultManagerListener(IResultManagerListener listener) {
        this._listeners.add((Object)listener);
    }

    @Override
    public void fireAdded(IResultInstance instance) {
        boolean isSubInstance;
        this._operationInstanceMap.put(instance.getOperationCommand(), instance);
        boolean bl = isSubInstance = instance.getParentResult() != null;
        if (!isSubInstance) {
            this._results.add(instance);
            Object[] listeners = this._listeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IResultManagerListener)listeners[i]).resultInstanceCreated(instance);
                ++i;
            }
        }
    }

    protected void fireAllRemoved() {
        Object[] listeners = this._listeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IResultManagerListener)listeners[i]).allResultInstancesRemoved();
            ++i;
        }
    }

    @Override
    public void fireAppended(IResultInstance instance, ResultItem r, int index) {
        Object[] listeners = this._listeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IResultManagerListener)listeners[i]).resultInstanceAppended(instance, r, index);
            ++i;
        }
    }

    @Override
    public void fireInstanceReset(IResultInstance instance) {
        Object[] listeners = this._listeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IResultManagerListener)listeners[i]).resultInstanceReset(instance);
            ++i;
        }
    }

    @Override
    public void fireParametersShow(IResultInstance instance, List params) {
        Object[] listeners = this._listeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IResultManagerListener)listeners[i]).parametersShow(instance, params);
            ++i;
        }
    }

    protected void fireRemoved(IResultInstance instance) {
        Object[] listeners = this._listeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IResultManagerListener)listeners[i]).resultInstanceRemoved(instance);
            ++i;
        }
    }

    protected void fireRemoved(IResultInstance[] instances) {
        Object[] listeners = this._listeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IResultManagerListener)listeners[i]).resultInstancesRemoved(instances);
            ++i;
        }
    }

    @Override
    public void fireStatusUpdated(IResultInstance instance) {
        Object[] listeners = this._listeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IResultManagerListener)listeners[i]).resultInstanceStatusUpdated(instance);
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IResultInstance[] getAllResults() {
        List list = this._results;
        synchronized (list) {
            return this._results.toArray(new IResultInstance[this._results.size()]);
        }
    }

    @Override
    public IResultInstance getInstance(OperationCommand cmd) {
        return (IResultInstance)this._operationInstanceMap.get(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAllFinished() {
        boolean removed = false;
        List list = this._results;
        synchronized (list) {
            this._operationInstanceMap.clear();
            Iterator iter = this._results.iterator();
            while (iter.hasNext()) {
                IResultInstance instance = (IResultInstance)iter.next();
                if (!instance.isFinished()) continue;
                iter.remove();
                removed = true;
                instance.dispose();
            }
        }
        if (removed) {
            this.fireAllRemoved();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeResultInstance(IResultInstance instance) {
        boolean removed;
        List list = this._results;
        synchronized (list) {
            removed = this._results.remove(instance);
            if (instance.getSubResults().size() > 0) {
                for (Object subri : instance.getSubResults()) {
                    if (!(subri instanceof IResultInstance)) continue;
                    this._operationInstanceMap.remove(((IResultInstance)subri).getOperationCommand());
                    ((IResultInstance)subri).dispose();
                }
            }
            this._operationInstanceMap.remove(instance.getOperationCommand());
            instance.dispose();
        }
        if (removed) {
            this.fireRemoved(instance);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeResultInstances(IResultInstance[] instances) {
        if (instances != null) {
            boolean removed = false;
            List list = this._results;
            synchronized (list) {
                int i = 0;
                while (i < instances.length) {
                    if (instances[i] != null) {
                        boolean succeeded = this._results.remove(instances[i]);
                        if (instances[i].getSubResults().size() > 0) {
                            for (Object subri : instances[i].getSubResults()) {
                                if (!(subri instanceof IResultInstance)) continue;
                                this._operationInstanceMap.remove(((IResultInstance)subri).getOperationCommand());
                                ((IResultInstance)subri).dispose();
                            }
                        }
                        this._operationInstanceMap.remove(instances[i].getOperationCommand());
                        instances[i].dispose();
                        if (succeeded && !removed) {
                            removed = true;
                        }
                    }
                    ++i;
                }
            }
            if (removed) {
                this.fireRemoved(instances);
            }
        }
    }

    @Override
    public void removeResultManagerListener(IResultManagerListener listener) {
        this._listeners.remove((Object)listener);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        Object obj = stream.readObject();
        if (!(obj instanceof String) || !((String)obj).startsWith(SerializationHelper.RESULT_FLAG)) {
            throw new ClassVersionIncompatibleException("Invalid result file format.");
        }
        if (!SerializationHelper.resultManagerVersionCompatible(obj.toString())) {
            throw new ClassVersionIncompatibleException(obj.toString(), SerializationHelper.getResultManagerVersion());
        }
        stream.defaultReadObject();
        this._listeners = new ListenerList();
    }

    private void writeObject(ObjectOutputStream oos) throws IOException, ClassNotFoundException {
        oos.writeObject(_ClassVersionID);
        oos.defaultWriteObject();
    }

    public void initializeContent(IResultManager manager) {
        this._operationInstanceMap = ((ResultManager)manager)._operationInstanceMap;
        this._results = ((ResultManager)manager)._results;
    }
}

