/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.configuration;

import java.util.Map;
import org.eclipse.buildship.core.internal.configuration.GradleProjectMarker;
import org.eclipse.buildship.core.internal.configuration.GradleProjectValidationResourceDeltaVisitor;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public final class DefaultGradleProjectBuilder
extends IncrementalProjectBuilder {
    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        if (kind == 6) {
            this.fullBuild(project);
        } else {
            IResourceDelta delta = this.getDelta(project);
            if (delta == null) {
                this.fullBuild(project);
            } else {
                this.incrementalBuild(delta, project);
            }
        }
        return null;
    }

    private void fullBuild(IProject project) throws CoreException {
        new GradleProjectValidationResourceDeltaVisitor(project).validate();
    }

    private void incrementalBuild(IResourceDelta delta, IProject project) throws CoreException {
        delta.accept((IResourceDeltaVisitor)new GradleProjectValidationResourceDeltaVisitor(project));
    }

    protected void clean(IProgressMonitor monitor) throws CoreException {
        GradleProjectMarker.INSTANCE.removeMarkerFromResourceRecursively((IResource)this.getProject());
    }
}

