/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl;

import org.antlr.runtime.tree.CommonTree;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TsdlUtils;

public final class TypeSpecifierListNameParser
implements ICommonTreeParser {
    public static final TypeSpecifierListNameParser INSTANCE = new TypeSpecifierListNameParser();

    private TypeSpecifierListNameParser() {
    }

    @Override
    public StringBuilder parse(CommonTree typeSpecifier, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        StringBuilder sb = new StringBuilder();
        switch (typeSpecifier.getType()) {
            case 8: 
            case 11: 
            case 19: 
            case 20: 
            case 25: 
            case 32: 
            case 38: 
            case 39: 
            case 43: 
            case 46: 
            case 62: 
            case 64: 
            case 78: 
            case 80: {
                TypeSpecifierListNameParser.parseSimple(typeSpecifier, sb);
                break;
            }
            case 106: {
                TypeSpecifierListNameParser.parseStruct(typeSpecifier, sb);
                break;
            }
            case 123: {
                TypeSpecifierListNameParser.parseVariant(typeSpecifier, sb);
                break;
            }
            case 91: {
                TypeSpecifierListNameParser.parseEnum(typeSpecifier, sb);
                break;
            }
            case 100: 
            case 101: 
            case 105: {
                throw new ParseException("CTF type found in createTypeSpecifierString");
            }
            default: {
                throw TsdlUtils.childTypeError(typeSpecifier);
            }
        }
        return sb;
    }

    private static void parseEnum(CommonTree typeSpecifier, StringBuilder sb) throws ParseException {
        CommonTree enumName = (CommonTree)typeSpecifier.getFirstChildWithType(95);
        if (enumName == null) {
            throw new ParseException("nameless enum found in createTypeSpecifierString");
        }
        CommonTree enumNameIdentifier = (CommonTree)enumName.getChild(0);
        TypeSpecifierListNameParser.parseSimple(enumNameIdentifier, sb);
    }

    private static void parseVariant(CommonTree typeSpecifier, StringBuilder sb) throws ParseException {
        CommonTree variantName = (CommonTree)typeSpecifier.getFirstChildWithType(125);
        if (variantName == null) {
            throw new ParseException("nameless variant found in createTypeSpecifierString");
        }
        CommonTree variantNameIdentifier = (CommonTree)variantName.getChild(0);
        TypeSpecifierListNameParser.parseSimple(variantNameIdentifier, sb);
    }

    private static void parseSimple(CommonTree typeSpecifier, StringBuilder sb) {
        sb.append(typeSpecifier.getText());
    }

    private static void parseStruct(CommonTree typeSpecifier, StringBuilder sb) throws ParseException {
        CommonTree structName = (CommonTree)typeSpecifier.getFirstChildWithType(108);
        if (structName == null) {
            throw new ParseException("nameless struct found in createTypeSpecifierString");
        }
        CommonTree structNameIdentifier = (CommonTree)structName.getChild(0);
        TypeSpecifierListNameParser.parseSimple(structNameIdentifier, sb);
    }
}

