/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditorBase;
import org.jkiss.dbeaver.ui.editors.sql.templates.SQLTemplatesPage;
import org.jkiss.dbeaver.ui.editors.sql.util.ExclusivePositionUpdater;

public class SQLSymbolInserter
implements VerifyKeyListener,
ILinkedModeListener {
    protected static final Log log = Log.getLog(SQLSymbolInserter.class);
    private boolean closeSingleQuotes = true;
    private boolean closeDoubleQuotes = true;
    private boolean closeBrackets = true;
    private final String CATEGORY = this.toString();
    private IPositionUpdater positionUpdater = new ExclusivePositionUpdater(this.CATEGORY);
    private List<SymbolLevel> bracketLevelStack = new ArrayList<SymbolLevel>();
    private SQLEditorBase editor;
    private ISourceViewer sourceViewer;

    public SQLSymbolInserter(SQLEditorBase editor) {
        this.editor = editor;
        this.sourceViewer = editor.getViewer();
    }

    public void setCloseSingleQuotesEnabled(boolean enabled) {
        this.closeSingleQuotes = enabled;
    }

    public void setCloseDoubleQuotesEnabled(boolean enabled) {
        this.closeDoubleQuotes = enabled;
    }

    public void setCloseBracketsEnabled(boolean enabled) {
        this.closeBrackets = enabled;
    }

    private boolean hasIdentifierToTheRight(IDocument document, int offset) {
        try {
            int end = offset;
            IRegion endLine = document.getLineInformationOfOffset(end);
            int maxEnd = endLine.getOffset() + endLine.getLength();
            while (end != maxEnd && Character.isWhitespace(document.getChar(end))) {
                ++end;
            }
            return end != maxEnd && Character.isJavaIdentifierPart(document.getChar(end));
        }
        catch (BadLocationException e) {
            log.debug((Object)e);
            return true;
        }
    }

    private boolean hasIdentifierToTheLeft(IDocument document, int offset) {
        try {
            IRegion startLine = document.getLineInformationOfOffset(offset);
            int minStart = startLine.getOffset();
            return offset != minStart && Character.isJavaIdentifierPart(document.getChar(offset - 1));
        }
        catch (BadLocationException e) {
            log.debug((Object)e);
            return true;
        }
    }

    private boolean hasCharacterToTheRight(IDocument document, int offset, char character) {
        try {
            int end = offset;
            IRegion endLine = document.getLineInformationOfOffset(end);
            int maxEnd = endLine.getOffset() + endLine.getLength();
            while (end != maxEnd && Character.isWhitespace(document.getChar(end))) {
                ++end;
            }
            return end != maxEnd && document.getChar(end) == character;
        }
        catch (BadLocationException e) {
            log.debug((Object)e);
            return true;
        }
    }

    public void verifyKey(VerifyEvent event) {
        if (!event.doit) {
            return;
        }
        if (this.editor.isBlockSelectionModeEnabled()) {
            return;
        }
        IDocument document = this.sourceViewer.getDocument();
        Point selection = this.sourceViewer.getSelectedRange();
        int offset = selection.x;
        int length = selection.y;
        switch (event.character) {
            case '(': 
            case '[': {
                if (!this.closeBrackets) {
                    return;
                }
                try {
                    if (offset < document.getLength() && !Character.isWhitespace(document.getChar(offset + length))) {
                        return;
                    }
                }
                catch (BadLocationException e) {
                    log.debug((Object)e);
                    return;
                }
                if (this.hasCharacterToTheRight(document, offset + length, event.character)) {
                    return;
                }
            }
            case '\'': {
                if (event.character == '\'') {
                    if (!this.closeSingleQuotes) {
                        return;
                    }
                    if (this.hasIdentifierToTheLeft(document, offset) || this.hasIdentifierToTheRight(document, offset + length)) {
                        return;
                    }
                }
            }
            case '\"': {
                if (event.character == '\"') {
                    if (!this.closeDoubleQuotes) {
                        return;
                    }
                    if (this.hasIdentifierToTheLeft(document, offset) || this.hasIdentifierToTheRight(document, offset + length)) {
                        return;
                    }
                }
                try {
                    ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)"___sql_partitioning", (int)offset, (boolean)true);
                    if (!"__dftl_partition_content_type".equals(partition.getType()) && partition.getOffset() != offset) {
                        return;
                    }
                    if (!this.editor.validateEditorInputState()) {
                        return;
                    }
                    char character = event.character;
                    char closingCharacter = SQLSymbolInserter.getPeerCharacter(character);
                    document.replace(offset, length, String.valueOf(String.valueOf(character)) + closingCharacter);
                    SymbolLevel level = new SymbolLevel();
                    this.bracketLevelStack.add(level);
                    LinkedPositionGroup group = new LinkedPositionGroup();
                    group.addPosition(new LinkedPosition(document, offset + 1, 0, -1));
                    LinkedModeModel model = new LinkedModeModel();
                    model.addLinkingListener((ILinkedModeListener)this);
                    model.addGroup(group);
                    model.forceInstall();
                    level.offset = offset;
                    level.length = 2;
                    if (this.bracketLevelStack.size() == 1) {
                        document.addPositionCategory(this.CATEGORY);
                        document.addPositionUpdater(this.positionUpdater);
                    }
                    level.firstPosition = new Position(offset, 1);
                    level.secondPosition = new Position(offset + 1, 1);
                    document.addPosition(this.CATEGORY, level.firstPosition);
                    document.addPosition(this.CATEGORY, level.secondPosition);
                    level.uI = new EditorLinkedModeUI(model, (ITextViewer)this.sourceViewer);
                    level.uI.setSimpleMode(true);
                    level.uI.setExitPolicy((LinkedModeUI.IExitPolicy)new ExitPolicy(closingCharacter, this.getEscapeCharacter(closingCharacter), this.bracketLevelStack));
                    level.uI.setExitPosition((ITextViewer)this.sourceViewer, offset + 2, 0, Integer.MAX_VALUE);
                    level.uI.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
                    level.uI.enter();
                    IRegion newSelection = level.uI.getSelectedRegion();
                    this.sourceViewer.setSelectedRange(newSelection.getOffset(), newSelection.getLength());
                    event.doit = false;
                }
                catch (BadLocationException | BadPositionCategoryException e) {
                    log.debug((Object)e);
                }
                break;
            }
            case '\t': {
                try {
                    int curOffset = offset;
                    while (curOffset > 0) {
                        if (!Character.isJavaIdentifierPart(document.getChar(curOffset - 1))) break;
                        --curOffset;
                    }
                    if (curOffset == offset) break;
                    String templateName = document.get(curOffset, offset - curOffset);
                    SQLTemplatesPage templatesPage = this.editor.getTemplatesPage();
                    Template template = templatesPage.getTemplateStore().findTemplate(templateName);
                    if (template == null || !template.isAutoInsertable()) break;
                    this.sourceViewer.setSelectedRange(curOffset, offset - curOffset);
                    templatesPage.insertTemplate(template, document);
                    event.doit = false;
                    break;
                }
                catch (BadLocationException e) {
                    log.debug((Object)e);
                }
            }
        }
    }

    public void left(LinkedModeModel environment, int flags) {
        final SymbolLevel level = this.bracketLevelStack.remove(this.bracketLevelStack.size() - 1);
        if (flags != 8) {
            return;
        }
        final IDocument document = this.sourceViewer.getDocument();
        if (document instanceof IDocumentExtension) {
            IDocumentExtension extension = (IDocumentExtension)document;
            extension.registerPostNotificationReplace(null, new IDocumentExtension.IReplace(){

                public void perform(IDocument d, IDocumentListener owner) {
                    if ((level.firstPosition.isDeleted || level.firstPosition.length == 0) && !level.secondPosition.isDeleted && level.secondPosition.offset == level.firstPosition.offset) {
                        try {
                            document.replace(level.secondPosition.offset, level.secondPosition.length, null);
                        }
                        catch (BadLocationException badLocationException) {}
                    }
                    if (SQLSymbolInserter.this.bracketLevelStack.size() == 0) {
                        document.removePositionUpdater(SQLSymbolInserter.this.positionUpdater);
                        try {
                            document.removePositionCategory(SQLSymbolInserter.this.CATEGORY);
                        }
                        catch (BadPositionCategoryException badPositionCategoryException) {}
                    }
                }
            });
        }
    }

    public void suspend(LinkedModeModel environment) {
    }

    public void resume(LinkedModeModel environment, int flags) {
    }

    public char getEscapeCharacter(char character) {
        switch (character) {
            case '\"': 
            case '\'': {
                return this.editor.getSyntaxManager().getEscapeChar();
            }
        }
        return '\u0000';
    }

    public static char getPeerCharacter(char character) {
        switch (character) {
            case '(': {
                return ')';
            }
            case ')': {
                return '(';
            }
            case '[': {
                return ']';
            }
            case ']': {
                return '[';
            }
            case '\"': {
                return character;
            }
            case '\'': {
                return character;
            }
        }
        throw new IllegalArgumentException();
    }

    public static class EditorLinkedModeUI
    extends LinkedModeUI {
        public EditorLinkedModeUI(LinkedModeModel model, ITextViewer viewer) {
            super(model, viewer);
            this.setPositionListener(new EditorHistoryUpdater());
        }

        private static class EditorHistoryUpdater
        implements LinkedModeUI.ILinkedModeUIFocusListener {
            private EditorHistoryUpdater() {
            }

            public void linkingFocusLost(LinkedPosition position, LinkedModeUI.LinkedModeUITarget target) {
                IWorkbenchPage page;
                IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (win != null && (page = win.getActivePage()) != null) {
                    IEditorPart part = page.getActiveEditor();
                    page.getNavigationHistory().markLocation(part);
                }
            }

            public void linkingFocusGained(LinkedPosition position, LinkedModeUI.LinkedModeUITarget target) {
            }
        }
    }

    private class ExitPolicy
    implements LinkedModeUI.IExitPolicy {
        final char exitCharacter;
        final char escapeCharacter;
        final List<SymbolLevel> stack;
        final int size;

        public ExitPolicy(char exitCharacter, char escapeCharacter, List<SymbolLevel> stack) {
            this.exitCharacter = exitCharacter;
            this.escapeCharacter = escapeCharacter;
            this.stack = stack;
            this.size = this.stack.size();
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
            if (event.character == this.exitCharacter && this.size == this.stack.size() && !this.isMasked(offset)) {
                SymbolLevel level = this.stack.get(this.stack.size() - 1);
                if (level.firstPosition.offset > offset || level.secondPosition.offset < offset) {
                    return null;
                }
                if (level.secondPosition.offset == offset && length == 0) {
                    return new LinkedModeUI.ExitFlags(2, false);
                }
            }
            return null;
        }

        private boolean isMasked(int offset) {
            IDocument document = SQLSymbolInserter.this.sourceViewer.getDocument();
            try {
                return this.escapeCharacter == document.getChar(offset - 1);
            }
            catch (BadLocationException e) {
                log.debug((Object)e);
                return false;
            }
        }
    }

    private static class SymbolLevel {
        int offset;
        int length;
        LinkedModeUI uI;
        Position firstPosition;
        Position secondPosition;

        private SymbolLevel() {
        }
    }
}

