/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.format.sqlworkbenchj;

import java.io.File;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.format.sqlworkbenchj.SQLWorkbenchJManager;
import org.jkiss.dbeaver.model.sql.format.SQLFormatter;
import org.jkiss.dbeaver.model.sql.format.SQLFormatterConfiguration;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class SQLWorkbenchJFormatter
implements SQLFormatter {
    private static final Log log = Log.getLog(SQLWorkbenchJFormatter.class);

    public String format(String source, SQLFormatterConfiguration configuration) {
        String workbenchPath = CommonUtils.toString((Object)configuration.getPreferenceStore().getString("workbenchPath"));
        if (CommonUtils.isEmpty((String)workbenchPath)) {
            log.error((Object)"SQL Workbench/J path not set");
            return source;
        }
        try {
            SQLWorkbenchJManager.initManager(new File(workbenchPath));
            return SQLWorkbenchJManager.getInstance().format(configuration.getDataSource(), source);
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("Workbench format error", "Error formatting with SQL Workbench/J", (Throwable)e);
            return source;
        }
    }
}

