/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.erd.part;

import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.jkiss.dbeaver.ext.erd.directedit.ExtendedDirectEditManager;
import org.jkiss.dbeaver.ext.erd.directedit.LabelCellEditorLocator;
import org.jkiss.dbeaver.ext.erd.directedit.TableNameCellEditorValidator;
import org.jkiss.dbeaver.ext.erd.directedit.ValidationMessageHandler;
import org.jkiss.dbeaver.ext.erd.editor.ERDGraphicalViewer;
import org.jkiss.dbeaver.ext.erd.figures.EditableLabel;
import org.jkiss.dbeaver.ext.erd.figures.EntityFigure;
import org.jkiss.dbeaver.ext.erd.model.ERDAssociation;
import org.jkiss.dbeaver.ext.erd.model.ERDEntity;
import org.jkiss.dbeaver.ext.erd.model.ERDEntityAttribute;
import org.jkiss.dbeaver.ext.erd.model.ERDUtils;
import org.jkiss.dbeaver.ext.erd.model.EntityDiagram;
import org.jkiss.dbeaver.ext.erd.part.AssociationPart;
import org.jkiss.dbeaver.ext.erd.part.NodePart;
import org.jkiss.dbeaver.ext.erd.policy.EntityConnectionEditPolicy;
import org.jkiss.dbeaver.ext.erd.policy.EntityContainerEditPolicy;
import org.jkiss.dbeaver.ext.erd.policy.EntityEditPolicy;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.struct.DBSEntity;

public class EntityPart
extends NodePart {
    protected DirectEditManager manager;

    public ERDEntity getEntity() {
        return (ERDEntity)this.getModel();
    }

    protected List<ERDEntityAttribute> getModelChildren() {
        return this.getEntity().getAttributes();
    }

    protected List<ERDAssociation> getModelSourceConnections() {
        return this.getEntity().getAssociations();
    }

    protected List<ERDAssociation> getModelTargetConnections() {
        return this.getEntity().getReferences();
    }

    protected void createEditPolicies() {
        boolean editEnabled = this.isEditEnabled();
        if (editEnabled) {
            this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)new EntityConnectionEditPolicy());
            this.installEditPolicy("ContainerEditPolicy", (EditPolicy)new EntityContainerEditPolicy());
            this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new EntityEditPolicy());
        }
    }

    public void performRequest(Request request) {
        if (request.getType() != "direct edit" && request.getType() == "open") {
            ERDUtils.openObjectEditor(this.getEntity());
        }
    }

    private boolean directEditHitTest(Point requestLoc) {
        EntityFigure figure = this.getFigure();
        EditableLabel nameLabel = figure.getNameLabel();
        nameLabel.translateToRelative((Translatable)requestLoc);
        return nameLabel.containsPoint(requestLoc);
    }

    protected void performDirectEdit() {
        if (this.manager == null) {
            ERDGraphicalViewer viewer = this.getViewer();
            ValidationMessageHandler handler = viewer.getValidationHandler();
            EntityFigure figure = this.getFigure();
            EditableLabel nameLabel = figure.getNameLabel();
            this.manager = new ExtendedDirectEditManager((GraphicalEditPart)this, TextCellEditor.class, new LabelCellEditorLocator(nameLabel), (IFigure)nameLabel, new TableNameCellEditorValidator(handler));
        }
        this.manager.show();
    }

    public void handleNameChange(String value) {
        EntityFigure entityFigure = this.getFigure();
        EditableLabel label = entityFigure.getNameLabel();
        label.setVisible(false);
        this.refreshVisuals();
    }

    public void revertNameChange() {
        EntityFigure entityFigure = this.getFigure();
        EditableLabel label = entityFigure.getNameLabel();
        ERDEntity entity = this.getEntity();
        label.setText(((DBSEntity)entity.getObject()).getName());
        label.setVisible(true);
        this.refreshVisuals();
    }

    public String toString() {
        return DBUtils.getObjectFullName((DBPNamedObject)((DBPNamedObject)this.getEntity().getObject()), (DBPEvaluationContext)DBPEvaluationContext.UI);
    }

    @Override
    protected void commitNameChange(PropertyChangeEvent evt) {
        EntityFigure entityFigure = this.getFigure();
        EditableLabel label = entityFigure.getNameLabel();
        label.setText(((DBSEntity)this.getEntity().getObject()).getName());
        label.setVisible(true);
        this.refreshVisuals();
        entityFigure.refreshColors();
    }

    protected EntityFigure createFigure() {
        EntityDiagram diagram = this.getDiagram();
        EntityFigure figure = this.createFigureImpl();
        EntityDiagram.NodeVisualInfo visualInfo = diagram.getVisualInfo((DBSEntity)this.getEntity().getObject());
        if (visualInfo != null) {
            if (visualInfo.initBounds != null) {
                figure.setLocation(visualInfo.initBounds.getLocation());
            }
            this.customBackground = visualInfo.bgColor;
            if (this.customBackground != null) {
                figure.setBackgroundColor(this.customBackground);
            }
            if (this.getEntity().getAttributeVisibility() == null && visualInfo.attributeVisibility != null) {
                this.getEntity().setAttributeVisibility(visualInfo.attributeVisibility);
            }
        }
        return figure;
    }

    protected EntityFigure createFigureImpl() {
        return new EntityFigure(this);
    }

    public EntityFigure getFigure() {
        return (EntityFigure)super.getFigure();
    }

    protected void refreshVisuals() {
        EntityFigure entityFigure = this.getFigure();
        Point location = entityFigure.getLocation();
        Rectangle constraint = new Rectangle(location.x, location.y, -1, -1);
        this.getDiagramPart().setLayoutConstraint((EditPart)this, (IFigure)entityFigure, constraint);
    }

    public EntityFigure getContentPane() {
        return this.getFigure();
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor((IFigure)this.getFigure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new ChopboxAnchor((IFigure)this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new ChopboxAnchor((IFigure)this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new ChopboxAnchor((IFigure)this.getFigure());
    }

    public void setSelected(int value) {
        super.setSelected(value);
        EntityFigure entityFigure = this.getFigure();
        if (value != 0) {
            entityFigure.setSelected(true);
        } else {
            entityFigure.setSelected(false);
        }
        entityFigure.repaint();
    }

    public AssociationPart getConnectionPart(ERDAssociation rel, boolean source) {
        for (Object conn : source ? this.getSourceConnections() : this.getTargetConnections()) {
            if (!(conn instanceof AssociationPart) || ((AssociationPart)conn).getAssociation() != rel) continue;
            return (AssociationPart)conn;
        }
        return null;
    }

    public ERDGraphicalViewer getViewer() {
        return (ERDGraphicalViewer)super.getViewer();
    }

    @Override
    public void activate() {
        super.activate();
        this.getViewer().handleTableActivate((DBSEntity)this.getEntity().getObject());
    }

    @Override
    public void deactivate() {
        this.getViewer().handleTableDeactivate((DBSEntity)this.getEntity().getObject());
        super.deactivate();
    }

    protected void registerVisuals() {
        super.registerVisuals();
        Map visualPartMap = this.getViewer().getVisualPartMap();
        visualPartMap.put(this.getFigure().getNameLabel(), this);
        visualPartMap.put(this.getFigure().getKeyFigure(), this);
        visualPartMap.put(this.getFigure().getColumnsFigure(), this);
    }

    protected void unregisterVisuals() {
        Map visualPartMap = this.getViewer().getVisualPartMap();
        visualPartMap.remove((Object)this.getFigure().getColumnsFigure());
        visualPartMap.remove((Object)this.getFigure().getKeyFigure());
        visualPartMap.remove((Object)this.getFigure().getNameLabel());
        super.unregisterVisuals();
    }

    public EditPart getTargetEditPart(Request request) {
        if ("move".equals(request.getType()) || "add children".equals(request.getType())) {
            return this;
        }
        return super.getTargetEditPart(request);
    }

    public DragTracker getDragTracker(Request request) {
        return super.getDragTracker(request);
    }
}

